/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.interactive.chart;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.dynamicanalyzer.ui.interactive.chart.InteractiveChartView;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineEditItemsDialog;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;

public class InteractiveEditItemsDialog
extends TimelineEditItemsDialog {
    private InteractiveChartView chartView;
    private DACustomButtonClickEventListener okButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            TableItem[] tableitems = InteractiveEditItemsDialog.this.chartTableViewer.getTable().getItems();
            ArrayList<Integer> order = new ArrayList<Integer>();
            ArrayList<Boolean> showInfo = new ArrayList<Boolean>();
            ArrayList<TimelineChart> selectedChartList = new ArrayList<TimelineChart>();
            ArrayList tempChartList = new ArrayList(InteractiveEditItemsDialog.this.chartList);
            InteractiveEditItemsDialog.this.chartList.clear();
            TableItem[] tableItemArray = tableitems;
            int n = tableitems.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                TimelineEditItemsDialog.TableItemData itemData = (TimelineEditItemsDialog.TableItemData)item.getData();
                TimelineChart chart = InteractiveEditItemsDialog.this.findChart(tempChartList, itemData.chartType);
                InteractiveEditItemsDialog.this.chartList.add(chart);
                if (itemData.isEnabled) {
                    selectedChartList.add(chart);
                    showInfo.add(true);
                } else {
                    showInfo.add(false);
                }
                order.add(itemData.index);
                ++n2;
            }
            InteractiveDataManager.getInstance().setShowTimelineChartList(selectedChartList);
            InteractiveEditItemsDialog.this.chartView.reArrangeChart(order, showInfo);
            InteractiveEditItemsDialog.this.shell.dispose();
            RunningDialog = false;
        }
    };

    public InteractiveEditItemsDialog(Shell parent, InteractiveChartView chartView_) {
        super(parent);
        this.chartView = chartView_;
        this.chartList = InteractiveDataManager.getInstance().getTimelineChartList();
        this.setOkButtonListener(this.okButtonListener);
    }

    @Override
    protected Set<String> getSelectedChartSet() {
        HashSet<String> chartNameList = new HashSet<String>();
        List<TimelineChart> selectedChartList = InteractiveDataManager.getInstance().getShowTimelineChartList();
        int i = 0;
        while (i < selectedChartList.size()) {
            chartNameList.add(selectedChartList.get(i).getChartName());
            ++i;
        }
        return chartNameList;
    }

    private TimelineChart findChart(List<TimelineChart> chartList, int chartType) {
        if (chartList != null) {
            int i = 0;
            while (i < chartList.size()) {
                if (chartType == chartList.get(i).getChartType()) {
                    return chartList.get(i);
                }
                ++i;
            }
        }
        return null;
    }
}

