/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.interactive.table;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.model.FilterProperty;
import org.tizen.dynamicanalyzer.model.TreeInput;
import org.tizen.dynamicanalyzer.ui.interactive.InteractivePage;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveDataManager;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveUIData;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveValue;
import org.tizen.dynamicanalyzer.ui.interactive.model.InteractiveInfo;
import org.tizen.dynamicanalyzer.ui.interactive.table.InteractiveTableCellRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableHeaderRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATreeComposite;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class InteractiveTable
extends DATreeComposite {
    private InteractiveInfo interactiveInfo;
    private Map<Long, Boolean> beforeExpandMap;

    public InteractiveTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] ti = ((Grid)e.widget).getSelection();
                if (ti == null || ti.length == 0) {
                    return;
                }
                int size = ti.length;
                List<Object> startData = ((DATableDataFormat)ti[0].getData()).getData();
                List<Object> endData = ((DATableDataFormat)ti[size - 1].getData()).getData();
                long startTime = (Long)startData.get(0);
                long endTime = (Long)endData.get(0);
                DASelectionData data = new DASelectionData(InteractivePage.listViewID, startTime, endTime, ti[size - 1], (Control)InteractiveTable.this.table);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)data);
                InteractiveTable.this.table.setSelection(((Grid)e.widget).getSelectionIndices()[((Grid)e.widget).getSelectionCount() - 1]);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    @Override
    public void setColumns(String[] columnNames) {
        this.columnNames = columnNames;
        int size = columnNames.length;
        int i = 0;
        while (i < size) {
            GridColumn column = new GridColumn(this.table, 0);
            column.setText(columnNames[i]);
            if (this.isTree && i == 0) {
                column.setTree(true);
            }
            column.setCellRenderer((GridCellRenderer)new InteractiveTableCellRenderer());
            column.setHeaderRenderer((GridHeaderRenderer)new DATableHeaderRenderer());
            if (this.columnAlignment != null && this.columnAlignment.length > i) {
                column.setAlignment(this.columnAlignment[i]);
            }
            column.pack();
            if (this.comparator != null && this.sortTypes != null) {
                final int type = this.sortTypes[i];
                final int columnIndex = i;
                column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        InteractiveTable.this.comparator.setType(type);
                        InteractiveTable.this.comparator.setColumn(columnIndex);
                        InteractiveTable.this.comparator.reverseDirection();
                        InteractiveTable.this.updateTable();
                    }
                });
            }
            ++i;
        }
    }

    public void setInteractiveInfo(InteractiveInfo interactiveInfo) {
        this.interactiveInfo = interactiveInfo;
    }

    public void updateTree(long startTime, long endTime) {
        GridItem[] items = this.table.getItems();
        if (items != null) {
            ArrayList<Integer> selectionList = new ArrayList<Integer>();
            int i = 0;
            while (i < items.length) {
                GridItem item = items[i];
                long time = (Long)((DATableDataFormat)item.getData()).getData().get(0);
                if (startTime <= time && time <= endTime) {
                    selectionList.add(i);
                }
                ++i;
            }
            int[] sels = new int[selectionList.size()];
            int i2 = 0;
            while (i2 < selectionList.size()) {
                sels[i2] = (Integer)selectionList.get(i2);
                ++i2;
            }
            this.table.setSelection(sels);
        }
        this.updateTree();
    }

    @Override
    public void updateTree() {
        this.beforeExpandMap = (Map)this.getExpandMap().clone();
        super.updateTree();
    }

    @Override
    public List<TreeInput> makeTreeInput() {
        if (this.interactiveInfo == null) {
            return null;
        }
        ResultSet rs = InteractiveDataManager.getInstance().getValueDataFromDB(this.interactiveInfo);
        if (rs == null) {
            return null;
        }
        Map<Long, List<InteractiveValue>> valueInfoMap = InteractiveDataManager.getInstance().makeInteractiveValueMap(rs);
        if (valueInfoMap == null) {
            return null;
        }
        ArrayList<InteractiveUIData> beforeUIDataList = new ArrayList<InteractiveUIData>();
        ArrayList<InteractiveUIData> afterUIDataList = new ArrayList<InteractiveUIData>();
        boolean result = InteractiveDataManager.getInstance().makeInteractiveUIData(this.interactiveInfo, valueInfoMap, beforeUIDataList, afterUIDataList);
        if (result) {
            ArrayList<InteractiveUIData> parsedUIDataList = new ArrayList<InteractiveUIData>();
            parsedUIDataList.addAll(beforeUIDataList);
            parsedUIDataList.addAll(afterUIDataList);
            long tableID = 0L;
            Collections.sort(parsedUIDataList);
            List<FilterProperty> filterList = this.getFilterPropertyList();
            ArrayList<TreeInput> output = new ArrayList<TreeInput>();
            int i = 0;
            while (i < parsedUIDataList.size()) {
                InteractiveUIData valueData = (InteractiveUIData)parsedUIDataList.get(i);
                if (valueData != null) {
                    tableID = this.setUIDataID(valueData, tableID);
                    TreeInput valueInput = this.makeInput(valueData, valueData.getTime(), false);
                    boolean isChildAdded = this.makeChildTree(valueData, valueInput, valueData.getTime(), valueData.getName(), filterList);
                    if (isChildAdded || this.checkFilter(valueInput, filterList)) {
                        output.add(valueInput);
                    }
                } else {
                    output.add(null);
                }
                ++i;
            }
            return output;
        }
        return null;
    }

    @Override
    protected GridItem checkExpand(GridItem gridItem, DATableDataFormat gridData) {
        long seq = gridData.getSelectionKey();
        Boolean expand = this.beforeExpandMap.get(seq);
        if (expand == null) {
            if (gridItem.getParent() == null) {
                gridItem.setExpanded(true);
                this.getExpandMap().put(seq, true);
            } else {
                gridItem.setExpanded(false);
                this.getExpandMap().put(seq, false);
            }
        } else {
            gridItem.setExpanded(expand.booleanValue());
        }
        return gridItem;
    }

    private TreeInput makeInput(InteractiveUIData input, long time, boolean isChild) {
        if (input == null) {
            return null;
        }
        DATableDataFormat tableData = new DATableDataFormat(input.getTableRowID());
        tableData.setObject(input);
        ArrayList<String> text = new ArrayList<String>();
        if (isChild) {
            text.add(input.getName());
        } else {
            String strTime = Formatter.toTimeFormat(input.getTime());
            text.add(String.valueOf(strTime) + " / " + input.getName());
        }
        text.add(input.getType());
        if (input.getValue() != null) {
            text.add(input.getValue().toString());
        }
        TreeInput output = new TreeInput();
        output.setText(text);
        tableData.getData().add(time);
        tableData.setType(2048);
        output.setData(tableData);
        return output;
    }

    private boolean checkFilter(TreeInput input, List<FilterProperty> filterList) {
        if (filterList.isEmpty()) {
            return true;
        }
        List<String> textList = input.getText();
        int i = 0;
        while (i < filterList.size()) {
            FilterProperty prop = filterList.get(i);
            if (!textList.get(prop.getColumnIndex()).contains(prop.getKeyWord())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean makeChildTree(InteractiveUIData parentData, TreeInput parentInput, long time, String parentName, List<FilterProperty> filterList) {
        boolean isChildAdded = false;
        List<InteractiveUIData> children = parentData.getChildren();
        if (children == null) {
            return isChildAdded;
        }
        int i = 0;
        while (i < children.size()) {
            InteractiveUIData data = children.get(i);
            if (data != null) {
                TreeInput input;
                boolean isGrandChildAdded;
                if (parentData.isArray()) {
                    data.setName("[" + i + "]");
                }
                if ((isGrandChildAdded = this.makeChildTree(data, input = this.makeInput(data, time, true), time, data.getName(), filterList)) || this.checkFilter(input, filterList)) {
                    parentInput.getChildren().add(input);
                    input.setParent(parentName);
                    isChildAdded = true;
                }
            }
            ++i;
        }
        return isChildAdded;
    }

    private long setUIDataID(InteractiveUIData uiData, long tableRowID) {
        uiData.setTableRowID(tableRowID++);
        if (uiData.getChildren() != null) {
            int i = 0;
            while (i < uiData.getChildren().size()) {
                if (uiData.getChildren().get(i) != null) {
                    tableRowID = this.setUIDataID(uiData.getChildren().get(i), tableRowID);
                }
                ++i;
            }
        }
        return tableRowID;
    }
}

