/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.kernel.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class FunctionDataDBTable
extends DBTable {
    private static final String TABLENAME = "FUNCTION_CALL_DATA";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public FunctionDataDBTable() {
        this.addColumn(new DBColumn(COLUMN.SEQ.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.TID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.CPUNUM.name, "", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.STARTTIME.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.STARTTYPE.name, "", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.STARTADDR.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.ENDTIME.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.ENDTYPE.name, "", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.ENDADDR.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.FUNCID.name, "", "INTEGER"));
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(COLUMN.SEQ.index + 1, (Long)rowData.get(COLUMN.SEQ.index));
                prep.setInt(COLUMN.PID.index + 1, (Integer)rowData.get(COLUMN.PID.index));
                prep.setInt(COLUMN.TID.index + 1, (Integer)rowData.get(COLUMN.TID.index));
                prep.setInt(COLUMN.CPUNUM.index + 1, (Integer)rowData.get(COLUMN.CPUNUM.index));
                prep.setLong(COLUMN.STARTTIME.index + 1, (Long)rowData.get(COLUMN.STARTTIME.index));
                prep.setInt(COLUMN.STARTTYPE.index + 1, (Integer)rowData.get(COLUMN.STARTTYPE.index));
                prep.setLong(COLUMN.STARTADDR.index + 1, (Long)rowData.get(COLUMN.STARTADDR.index));
                prep.setLong(COLUMN.ENDTIME.index + 1, (Long)rowData.get(COLUMN.ENDTIME.index));
                prep.setInt(COLUMN.ENDTYPE.index + 1, (Integer)rowData.get(COLUMN.ENDTYPE.index));
                prep.setLong(COLUMN.ENDADDR.index + 1, (Long)rowData.get(COLUMN.ENDADDR.index));
                prep.setInt(COLUMN.FUNCID.index + 1, (Integer)rowData.get(COLUMN.FUNCID.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(1));
            row.add(rs.getInt(2));
            row.add(rs.getInt(3));
            row.add(rs.getInt(4));
            row.add(rs.getLong(5));
            row.add(rs.getInt(6));
            row.add(rs.getLong(7));
            row.add(rs.getLong(8));
            row.add(rs.getInt(9));
            row.add(rs.getLong(10));
            row.add(rs.getInt(11));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        SEQ(0, "SEQUENCE_NUMBER"),
        PID(1, "PID"),
        TID(2, "TID"),
        CPUNUM(3, "CPU_NUM"),
        STARTTIME(4, "START_TIME"),
        STARTTYPE(5, "START_TYPE"),
        STARTADDR(6, "START_PCADDR"),
        ENDTIME(7, "END_TIME"),
        ENDTYPE(8, "END_TYPE"),
        ENDADDR(9, "END_PCADDR"),
        FUNCID(10, "FUNCTION_ID");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

