/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.ui.memory.chart.MemoryChart;
import org.tizen.dynamicanalyzer.ui.memory.chart.MemoryChartBoard;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItemList;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardSelectionListener;

public class HeapChartsSelectionListener
extends DAChartBoardSelectionListener {
    private Grid table = null;

    public HeapChartsSelectionListener(Grid statisticsTable) {
        this.table = statisticsTable;
    }

    public void handleSelectionEvent(DAChartBoardItem item) {
        Composite parentItem;
        if (this.table == null || item == null) {
            return;
        }
        this.table.deselectAll();
        MemoryChartBoard chartBoard = (MemoryChartBoard)item.getChartBoard();
        if (item.getParent() != null && item.getParent() instanceof DAChartBoardItemList && (parentItem = ((DAChartBoardItemList)item.getParent()).getParent()) instanceof DAChartBoardItem) {
            chartBoard = (MemoryChartBoard)((DAChartBoardItem)parentItem).getChartBoard();
        }
        if (chartBoard == null) {
            return;
        }
        int pid = 0;
        String entryName = "";
        for (MemoryChart chart : chartBoard.getMemoryChartList()) {
            if (chart.getChartItem() != item) continue;
            pid = chart.getPid();
            if (chart.getChartName().equals(MemoryPageLabels.MEMORY_CHART_HEAP_MEMORY)) {
                entryName = Integer.toString(pid);
                break;
            }
            entryName = chart.getChartName().replace('\n', '/');
            break;
        }
        this.selectEntry(pid, entryName);
    }

    private void selectEntry(int pid, String name) {
        if (pid == 0 || name.isEmpty()) {
            return;
        }
        GridItem[] gridItemArray = this.table.getItems();
        int n = gridItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            block2: {
                GridItem gridItem;
                block3: {
                    block4: {
                        gridItem = gridItemArray[n2];
                        DATableDataFormat itemData = (DATableDataFormat)gridItem.getData();
                        if (!((String)itemData.getObject()).equals(name)) break block2;
                        if (CommonUtil.isNumeric((String)name)) break block3;
                        if (gridItem.getParentItem() == null) break block4;
                        DATableDataFormat parentData = (DATableDataFormat)gridItem.getParentItem().getData();
                        if (((String)parentData.getObject()).equals(Integer.toString(pid))) break block3;
                        break block2;
                    }
                    return;
                }
                this.table.select(this.table.indexOf(gridItem));
                this.table.showItem(gridItem);
                return;
            }
            ++n2;
        }
    }
}

