/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TreeInput;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.ui.memory.data.HeapDataManager;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATreeComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.ui.widgets.table.TableColumnSizePackListener;

public class MemoryStatisticsTable
extends DATreeComposite {
    private int[] columnSizes = new int[]{265, 140, 90, 90, 90, 110, 15, 800};
    private int[] columnAlignment = new int[]{16384, 131072, 131072, 131072, 131072, 131072, 131072, 0x1000000};
    private boolean[] columnVisibilityEnable;
    private boolean[] columnVisibilityDisable;
    private Long StartTime;
    private Long EndTime;
    private String[] columnNames;
    private int[] sortTypes;

    public MemoryStatisticsTable(Composite parent, int style, int tableStyle) {
        super(parent, style, tableStyle);
        boolean[] blArray = new boolean[8];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        this.columnVisibilityEnable = blArray;
        boolean[] blArray2 = new boolean[8];
        blArray2[7] = true;
        this.columnVisibilityDisable = blArray2;
        this.columnNames = new String[]{MemoryPageLabels.MEMORY_STATISTICS_VIEW_PATH, MemoryPageLabels.MEMORY_STATISTICS_VIEW_TOTAL, MemoryPageLabels.MEMORY_STATISTICS_VIEW_FREED, MemoryPageLabels.MEMORY_STATISTICS_VIEW_PERSISTENT, MemoryPageLabels.MEMORY_STATISTICS_VIEW_TOTAL_BYTE, MemoryPageLabels.MEMORY_STATISTICS_VIEW_PERSISTENT_BYTE, "", "Streaming is not supported. Please select range or stop Tracing"};
        int[] nArray = new int[8];
        nArray[0] = 2;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        this.sortTypes = nArray;
        this.StartTime = 0L;
        this.EndTime = 0L;
        this.setTableName(MemoryPageLabels.MEMORY_STATISTICS_VIEW_TITLE);
        this.setComparator(new DefaultTableComparator());
        this.setTree(true);
        this.setSortTypes(this.sortTypes);
        this.setColumnAlignment(this.columnAlignment);
        this.setColumns(this.columnNames);
        this.setColumnSize(this.columnSizes);
        this.setTableToolTipEnable(false);
        this.comparator.setType(1);
        this.comparator.setColumn(1);
        parent.addControlListener((ControlListener)new TableColumnSizePackListener(this, this.columnSizes));
    }

    public void setSelectionRange(Long start, Long end) {
        this.StartTime = start;
        this.EndTime = end;
    }

    @Override
    public List<TreeInput> makeTreeInput() {
        ArrayList<TreeInput> output = new ArrayList<TreeInput>();
        if (Global.getProject() == null) {
            return output;
        }
        HeapDataManager.getInstance().makeStatisticsData(this.StartTime, this.EndTime);
        return HeapDataManager.getInstance().getStatisticsTreeInput();
    }

    public void removeSelection() {
        this.table.removeAll();
        this.updateTable();
    }

    @Override
    public void clear() {
        this.table.removeAll();
        this.getSelectionIndex().clear();
        this.getSelections().clear();
        this.StartTime = 0L;
        this.EndTime = 0L;
    }

    public void setColumnVisibilityState(boolean enabled) {
        if (enabled) {
            this.setColumnVisibility(this.columnVisibilityEnable);
        } else {
            this.setColumnVisibility(this.columnVisibilityDisable);
        }
    }
}

