/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.profiling;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.project.callstack.BaseCallstackManager;
import org.tizen.dynamicanalyzer.swap.model.data.ProfileData;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackItem;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackUnit;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfileDataMaker;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingData;

public class RangeProfileDataMaker
extends ProfileDataMaker {
    public RangeProfileDataMaker(BaseCallstackManager callstackManager) {
        super(callstackManager);
    }

    @Override
    public void makeFunctionUsageProfileData(ProfileData sampleLog) {
        ProfilingData child;
        ++this.totalSampleCount;
        ArrayList<Long> addrs = new ArrayList<Long>();
        long selfAddr = sampleLog.getPcAddr();
        int pid = sampleLog.getPid();
        int tid = sampleLog.getTid();
        long sampleTime = sampleLog.getTime();
        Map<Long, CallStackUnit> addrMap = this.callstackManager.getCallStackApiAddrByPidMap(pid);
        CallStackUnit selfCallstackUnit = addrMap.get(selfAddr);
        if (selfCallstackUnit == null) {
            selfCallstackUnit = new CallStackUnit(selfAddr, this.callstackManager.getCallStackSymbol(selfAddr, pid, sampleTime), sampleLog);
            addrMap.put(selfAddr, selfCallstackUnit);
        }
        List<CallStackItem> userCallstack = this.callstackManager.getUserCallstack(tid);
        int callstackSize = userCallstack.size();
        int i = 0;
        while (i < callstackSize) {
            long addr = userCallstack.get(i).getCallStackUnit().getAddr();
            addrs.add(addr);
            ++i;
        }
        addrs.add(selfAddr);
        if (selfCallstackUnit.getPath().startsWith("/usr/lib/da_probe")) {
            return;
        }
        String inputPath = selfCallstackUnit.getPath();
        String inputFuncName = selfCallstackUnit.getFunctionName();
        ProfilingData parent = this.getProfilingDataByKey(inputPath);
        if (parent == null) {
            parent = this.makeNewProfilingData(selfCallstackUnit, true);
            this.checkUserCall(selfCallstackUnit, parent, null, sampleLog);
            if (inputFuncName.equals("")) {
                parent.addExCount();
            } else {
                child = this.makeNewProfilingData(selfCallstackUnit, false);
                parent.addChild(child);
                child.addExCount();
                child.setParent(parent.getName());
            }
        } else if (inputFuncName.isEmpty()) {
            parent.addExCount();
        } else {
            child = this.getProfilingDataByKey(selfCallstackUnit.getSymbol());
            if (child == null) {
                child = this.makeNewProfilingData(selfCallstackUnit, false);
                parent.addChild(child);
                child.setParent(parent.getName());
            }
            child.addExCount();
        }
        int size = 0;
        if (addrs != null) {
            size = addrs.size();
        }
        int i2 = 0;
        while (i2 < size) {
            String pInParentName;
            CallStackUnit callstackCsa = addrMap.get(addrs.get(i2));
            if (callstackCsa.getFunctionName().equals("")) {
                ProfilingData inParent = this.getProfilingDataByKey(callstackCsa.getPath());
                ProfilingData pp = null;
                if (inParent == null) {
                    inParent = this.makeNewProfilingData(callstackCsa, true);
                    this.checkUserCall(callstackCsa, inParent, pp, sampleLog);
                }
                inParent.addInCount(this.totalSampleCount);
                if (inParent.getParent() != null && (pp = this.getProfilingDataByKey(pInParentName = inParent.getParent())) != null) {
                    pp.addInCount(this.totalSampleCount);
                }
            } else {
                ProfilingData fupData = this.getProfilingDataByKey(callstackCsa.getSymbol());
                if (fupData == null) {
                    ProfilingData pp;
                    ProfilingData inParent = this.getProfilingDataByKey(callstackCsa.getPath());
                    if (inParent == null) {
                        inParent = this.makeNewProfilingData(callstackCsa, true);
                        this.checkUserCall(callstackCsa, inParent, null, sampleLog);
                    }
                    fupData = this.makeNewProfilingData(callstackCsa, false);
                    fupData.setParent(inParent.getName());
                    inParent.addChild(fupData);
                    inParent.addInCount(this.totalSampleCount);
                    if (inParent.getParent() != null && (pp = this.getProfilingDataByKey(pInParentName = inParent.getParent())) != null) {
                        pp.addInCount(this.totalSampleCount);
                    }
                } else {
                    String pInParentName2;
                    ProfilingData ppData;
                    String pName = fupData.getParent();
                    ProfilingData inParent = this.getProfilingDataByKey(pName);
                    inParent.addInCount(this.totalSampleCount);
                    if (inParent.getParent() != null && (ppData = this.getProfilingDataByKey(pInParentName2 = inParent.getParent())) != null) {
                        ppData.addInCount(this.totalSampleCount);
                    }
                }
                fupData.addInCount(this.totalSampleCount);
            }
            ++i2;
        }
    }
}

