/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.replayEditor;

import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.nebula.widgets.grid.internal.DefaultCellRenderer;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;

public class ReplayEditTableCellRenderer
extends DefaultCellRenderer {
    int leftMargin = 4;
    int rightMargin = 4;
    int textTopMargin = 1;
    public Image menuImg = null;

    public void paint(GC gc, Object value) {
        GridItem item = (GridItem)value;
        gc.setFont(item.getFont(this.getColumn()));
        this.paintImage(gc, item);
        this.paintText(gc, item);
        this.paintTableBoardLine(gc, item);
        this.paintMouseOverColumn(gc, item);
        this.paintSelectedInputKey(gc, item);
        this.paintVaildTime(gc, item);
    }

    private void paintImage(GC gc, GridItem item) {
        this.menuImg = item.getImage();
        if (this.menuImg == null || !item.getChecked(this.getColumn())) {
            return;
        }
        int y = this.getBounds().y;
        gc.drawImage(this.menuImg, this.getBounds().x, y += (this.getBounds().height - this.menuImg.getBounds().height) / 2);
    }

    private void paintText(GC gc, GridItem item) {
        int x = this.leftMargin;
        int width = this.getBounds().width - x - this.rightMargin;
        String text = item.getText(this.getColumn());
        int len = gc.stringExtent((String)text).x;
        if (len < width) {
            x += (width - len) / 2;
        }
        gc.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
        gc.setFont(FontResources.TABLE_CELL_FONT);
        gc.drawText(text, this.getBounds().x + x, this.getBounds().y + this.textTopMargin, true);
    }

    private void paintTableBoardLine(GC gc, GridItem item) {
        if (!item.getParent().getLinesVisible()) {
            return;
        }
        gc.setForeground(ColorResources.TABLE_LINE);
        gc.drawLine(this.getBounds().x, this.getBounds().y + this.getBounds().height, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height);
        gc.drawLine(this.getBounds().x + this.getBounds().width - 1, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height);
    }

    private void paintMouseOverColumn(GC gc, GridItem item) {
        if (!item.getChecked(this.getColumn())) {
            return;
        }
        Rectangle focusRect = new Rectangle(this.getBounds().x - 1, this.getBounds().y - 1, this.getBounds().width, this.getBounds().height + 1);
        gc.setForeground(ColorResources.TABLE_CONTENTS_SELECTED_START);
        gc.drawRectangle(focusRect);
        if (!this.isFocus()) {
            return;
        }
        ++focusRect.x;
        focusRect.width -= 2;
        ++focusRect.y;
        focusRect.height -= 2;
        gc.drawRectangle(focusRect);
    }

    private void paintSelectedInputKey(GC gc, GridItem item) {
        String optionColumn = item.getText(6);
        if (!item.getChecked(this.getColumn()) || !optionColumn.contains("SELECTED_ITEM_KEY_INPUT ")) {
            return;
        }
        Rectangle focusRect = new Rectangle(this.getBounds().x - 1, this.getBounds().y - 1, this.getBounds().width, this.getBounds().height + 1);
        gc.setForeground(ColorResources.RED);
        gc.drawRectangle(focusRect);
        if (!this.isFocus()) {
            return;
        }
        ++focusRect.x;
        focusRect.width -= 2;
        ++focusRect.y;
        focusRect.height -= 2;
        gc.drawRectangle(focusRect);
    }

    private void paintVaildTime(GC gc, GridItem item) {
        String optionColumn = item.getText(6);
        if (!optionColumn.contains("ITEM_TIME_VAILD_FALSE ")) {
            return;
        }
        gc.setForeground(ColorResources.RED);
        gc.setLineWidth(1);
        gc.drawLine(this.getBounds().x, this.getBounds().y + this.getBounds().height / 3, this.getBounds().x + this.getBounds().width, this.getBounds().y + this.getBounds().height / 3);
        gc.setLineWidth(1);
    }
}

