/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.userinterface.profiling;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.model.ColumnData;
import org.tizen.dynamicanalyzer.model.TreeInput;
import org.tizen.dynamicanalyzer.nl.UserInterfacePageLabels;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingData;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.userinterface.UIDataManager;
import org.tizen.dynamicanalyzer.ui.userinterface.UIPage;
import org.tizen.dynamicanalyzer.ui.userinterface.profiling.UIFunctionProfilingColumnGroupRenderer;
import org.tizen.dynamicanalyzer.ui.userinterface.profiling.UIFunctionProfilingData;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableCellRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableHeaderRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATreeComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.TreeDataComparator;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class UIFunctionProfilingTable
extends DATreeComposite {
    public UIFunctionProfilingTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.setComparator(new TreeDataComparator());
        this.comparator.setType(1);
        this.comparator.setColumn(2);
        this.comparator.reverseDirection();
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = UIFunctionProfilingTable.this.table.getSelection();
                if (items.length <= 0) {
                    return;
                }
                DATableDataFormat dataFormat = (DATableDataFormat)items[0].getData();
                String className = (String)dataFormat.getData().get(dataFormat.getData().size() - 1);
                UIDataManager.getInstance().setTableSeleteClassName(className);
                DASelectionData selData = new DASelectionData(UIPage.profilingViewID, 0L, 0L, items, (Control)UIFunctionProfilingTable.this.table);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
                UIFunctionProfilingTable.this.updateTree();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                GridItem[] items = UIFunctionProfilingTable.this.table.getSelection();
                if (items == null || items.length == 0) {
                    return;
                }
                GridItem item = items[0];
                if (item.isExpanded()) {
                    UIFunctionProfilingTable.this.setExpand(item, false);
                } else {
                    UIFunctionProfilingTable.this.setExpand(item, true);
                }
                UIFunctionProfilingTable.this.updateTree();
            }
        });
    }

    public void setColumns(List<ColumnData> columnData) {
        int size = columnData.size();
        int index = 0;
        int i = 0;
        while (i < size) {
            if (columnData.get(i).isParent()) {
                GridColumnGroup columnGroup = new GridColumnGroup(this.table, 0);
                columnGroup.setHeaderRenderer((GridHeaderRenderer)new UIFunctionProfilingColumnGroupRenderer());
                columnGroup.setText(columnData.get(i).getText());
                List<ColumnData> children = columnData.get(i).getChildren();
                int childSize = children.size();
                int ii = 0;
                while (ii < childSize) {
                    this.createColumn(columnGroup, children.get(ii), index++);
                    ++ii;
                }
            } else {
                this.createColumn(this.table, columnData.get(i), index++);
            }
            ++i;
        }
    }

    private void createColumn(Object parent, ColumnData columnData, int index) {
        GridColumn column = null;
        if (parent instanceof GridColumnGroup) {
            GridColumnGroup group = (GridColumnGroup)parent;
            column = new GridColumn(group, 0);
        } else {
            Grid table = (Grid)parent;
            column = new GridColumn(table, 0);
        }
        column.setCellRenderer((GridCellRenderer)new DATableCellRenderer());
        column.setHeaderRenderer((GridHeaderRenderer)new DATableHeaderRenderer());
        column.setText(columnData.getText());
        if (this.columnAlignment != null && this.columnAlignment.length > index) {
            column.setAlignment(this.columnAlignment[index]);
        }
        if (columnData.getWidth() == 0) {
            column.pack();
        } else {
            column.setWidth(columnData.getWidth());
        }
        if (this.isTree && index == 0) {
            column.setTree(true);
        }
        if (this.comparator != null && this.sortTypes != null) {
            final int type = this.sortTypes[index];
            final int columnIndex = index;
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    UIFunctionProfilingTable.this.comparator.setType(type);
                    UIFunctionProfilingTable.this.comparator.setColumn(columnIndex);
                    UIFunctionProfilingTable.this.comparator.reverseDirection();
                    UIFunctionProfilingTable.this.updateTree();
                }
            });
        }
    }

    public List<ProfilingData> difference(ArrayList<ProfilingData> base, ArrayList<ProfilingData> target) {
        ArrayList result = (ArrayList)base.clone();
        result.removeAll(target);
        return result;
    }

    private TreeInput makeInput(UIFunctionProfilingData input) {
        DATableDataFormat tableData = new DATableDataFormat(input.getUIFunctionDataID());
        ArrayList<String> inputData = new ArrayList<String>();
        inputData.add(Integer.toString(input.getUIFunctionDataID()));
        inputData.add(input.getAPIName());
        inputData.add(input.getInclElapsedTime());
        inputData.add(input.getInclElapsedAvgTime());
        inputData.add(input.getExclElapsedTime());
        inputData.add(input.getExclElapsedAvgTime());
        inputData.add(input.getInclCPUTime());
        inputData.add(input.getInclCPUAvgTime());
        inputData.add(input.getExclCPUTime());
        inputData.add(input.getExclCPUAvgTime());
        inputData.add(input.getClassKeyName());
        tableData.getData().addAll(inputData);
        if (input.getParent().equals("")) {
            tableData.setObject(String.valueOf(input.getAPIName()) + " " + "(" + UserInterfacePageLabels.PID + input.getPid() + ")");
        } else {
            tableData.setObject(input.getAPIName());
        }
        ArrayList<String> text = new ArrayList<String>();
        text.add(input.getAPIName());
        text.add(input.getInclElapsedTime());
        text.add(input.getInclElapsedAvgTime());
        text.add(input.getExclElapsedTime());
        text.add(input.getExclElapsedAvgTime());
        text.add(input.getInclCPUTime());
        text.add(input.getInclCPUAvgTime());
        text.add(input.getExclCPUTime());
        text.add(input.getExclCPUAvgTime());
        TreeInput output = new TreeInput();
        output.setText(text);
        output.setData(tableData);
        String strSelectedClassname = UIDataManager.getInstance().getTableSeleteClassName();
        if (strSelectedClassname.equals(input.getClassKeyName())) {
            output.setSecondSelection(true);
        }
        return output;
    }

    public boolean makeChildTree(TreeInput nodeParent, TreeInput currentNode, int nNodeDepth) {
        String strParentName = nodeParent.getText().get(0);
        if (currentNode.getParent().trim().equals(strParentName)) {
            nodeParent.getChildren().add(currentNode);
            return true;
        }
        int i = 0;
        while (i < nodeParent.getChildren().size()) {
            if (this.makeChildTree(nodeParent.getChildren().get(i), currentNode, nNodeDepth++)) break;
            ++i;
        }
        return false;
    }

    @Override
    public List<TreeInput> makeTreeInput() {
        UIDataManager tManager = UIDataManager.getInstance();
        List<UIFunctionProfilingData> controlList = tManager.getfunctionProfilingDataChecker().getDataList();
        ArrayList<TreeInput> output = new ArrayList<TreeInput>();
        int size = controlList.size();
        int nNodeDepth = 0;
        int i = 0;
        while (i < size) {
            int pid;
            int selectedPid = Toolbar.INSTANCE.getSelectedPid();
            if (selectedPid == 0 || (pid = controlList.get(i).getPid()) == selectedPid) {
                TreeInput currentNode = this.makeInput(controlList.get(i));
                currentNode.setParent(controlList.get(i).getParent());
                if (controlList.get(i).getParent().equals("")) {
                    output.add(currentNode);
                } else {
                    int j = 0;
                    while (j < output.size()) {
                        if (this.makeChildTree((TreeInput)output.get(j), currentNode, nNodeDepth++)) break;
                        ++j;
                    }
                }
            }
            ++i;
        }
        return output;
    }
}

