/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.common;

import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.handlers.CommandAction;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;

public class DALimit {
    public static final int FUNCTION_NAME_LENGTH = 1024;
    public static final int FILEPATH_LENGTH = 1024;
    public static final int FUNCTION_ARGUMENTS_FORMAT_LENGTH = 100;
    public static final int FUNCTION_ARGUMENTS_VALUE_LENGTH = 1024;
    public static final int FUNCTION_RETURN_VALUE_LENGTH = 1024;
    public static final int SHADER_SOURCE_LENGTH = 4096;
    public static final int SHADER_VARIABLE_LENGTH = 1024;
    public static final int HTML_SCRIPT_LENGTH = 4096;
    public static final int CLASS_NAME_LENGTH = 1024;
    public static final int TOOLTIP_LENGTH = 256;
    public static final int MAX_TRACE_TIME_INSECOND = 86400;
    public static final long MAX_SEQUENCE_NUMBER = Long.MAX_VALUE;
    public static final int MAX_PROCESS_COUNT = (int)Math.pow(2.0, 16.0);
    public static final int MAX_BINARY_COUNT = (int)Math.pow(2.0, 16.0);
    public static final int MAX_FUNCTION_COUNT = (int)Math.pow(2.0, 20.0);
    public static final int MAX_FUNCTION_ARGUMENTS_COUNT = 100;
    public static final long MAX_DAEMON_LOG_SIZE = 0x100000L;
    public static final int MAX_PAYLOAD_SIZE = (int)Math.pow(2.0, 16.0);
    public static final int MAX_LEAK_CHECK_BUFFER_SIZE = (int)Math.pow(2.0, 20.0);
    public static final int MAX_FILE_STATUS_COUNT = (int)Math.pow(2.0, 10.0) * 100;
    public static final int MAX_FILE_ACCESS_COUNT = (int)Math.pow(2.0, 10.0) * 100;
    public static final int MAX_STRING_LENGTH = 16;
    public static final int MAX_CALLSTACK_SEQTIMEMAP_SIZE = 1000000;

    public static void stopTraceAndOpenWarningDialog() {
        if (!DAState.isRunning()) {
            return;
        }
        DAResult result = new DAResult(DAResult.ErrorCode.ERR_OUT_OF_MEMORY);
        result.setDetailMessage(String.valueOf(AnalyzerLabels.HEAP_MEMORY_WARNING_PRE) + PathManager.DA_INSTALL_PATH + AnalyzerLabels.HEAP_MEMORY_WARNING_POST);
        CommandAction.stopTrace(result, false);
    }
}

