/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.control;

import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.control.ResourceMonitor;
import org.tizen.dynamicanalyzer.handlers.ReplayManager;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.MenuBarLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.setting.Feature;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.swap.communicator.DataChannelThread;
import org.tizen.dynamicanalyzer.swap.logparser.DataManagerRegistry;
import org.tizen.dynamicanalyzer.swap.logparser.LogParser;
import org.tizen.dynamicanalyzer.swap.logparser.MessageParser;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackInserter;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ScreenshotTimer;
import org.tizen.dynamicanalyzer.ui.memory.data.HeapDataManager;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.page.MenuBar;
import org.tizen.dynamicanalyzer.ui.page.UpdateViewTimer;
import org.tizen.dynamicanalyzer.ui.timeline.dlog.DLogDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;

public class StopTraceManager
implements Runnable {
    private DAResult error;
    private boolean stopFromTarget = false;
    private Thread stopThread = null;

    public StopTraceManager(DAResult err, boolean stopFromTarget) {
        this.error = err;
        this.stopFromTarget = stopFromTarget;
    }

    @Override
    public void run() {
        try {
            ResourceMonitor.stop();
            try {
                if (!this.stopFromTarget) {
                    DACommunicator.stopTrace();
                }
            }
            catch (Exception e) {
                Logger.error((Object)"Failed : Stop Trace");
                e.printStackTrace();
            }
            Thread stopTimers = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (Global.isGUIMode()) {
                        Toolbar.INSTANCE.stopTimer();
                    }
                    ReplayManager.resetStopAlarm();
                    ScreenshotTimer.stop();
                    UpdateViewTimer.stop();
                }
            });
            stopTimers.start();
            if (this.error.equals((Object)DAResult.ErrorCode.ERR_BY_USER_CANCEL)) {
                this.stopThread = new ForcedStopThread();
            } else {
                this.stopThread = new NormalStopThread();
                Project project = Global.getProject();
                if (project != null && project.isValid()) {
                    if (Global.isGUIMode()) {
                        project.setTotalStopTime(Toolbar.INSTANCE.getTime());
                    }
                } else {
                    Logger.error((Object)"project is not valid to save");
                }
            }
            this.stopThread.start();
            UIActionHolder.getUIAction().applyStopTraceUI();
            DLogDataManager.getInstance().stopDlog();
            if (Global.isGUIMode()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
                        baseView.getTopComposite().updateView();
                    }
                });
            }
        }
        finally {
            if (Global.isGUIMode()) {
                this.startUpdateHeapDataManager();
            }
            this.updateDAState();
        }
    }

    private void startUpdateHeapDataManager() {
        if (SettingDataManager.INSTANCE.getSelectedFeatureSet().contains((Object)Feature.INTERNAL_PROBE_MEMORY)) {
            Thread calculateAllocData = new Thread(new Runnable(){

                @Override
                public void run() {
                    Logger.info((Object)"Run : HeapDataManager for calculating alloc data");
                    HeapDataManager.getInstance().makeWholeAllocationTraceData();
                    HeapDataManager.getInstance().makeStatisticsData(0L, 0L);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
                            baseView.getTopComposite().updateView();
                        }
                    });
                }
            });
            calculateAllocData.start();
        }
    }

    private void updateDAState() {
        if (this.stopThread != null) {
            try {
                this.stopThread.join();
            }
            catch (InterruptedException interruptedException) {}
            this.stopThread = null;
        }
        DAState.changeCurrentState(DAState.DONE);
        if (Global.isGUIMode()) {
            ShortCutManager.getInstance().setEnabled(true);
            Toolbar.INSTANCE.changeUIState(DAState.getCurrentState());
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MenuBar.getInstance().setMenuItemEnable(MenuBarLabels.FILE_SAVE, true);
                    MenuBar.getInstance().setMenuItemEnable(MenuBarLabels.ANALYZE_SCREENSHOT, false);
                    MenuBar.getInstance().setMenuItemEnable(MenuBarLabels.FILE_NEW, true);
                    MenuBar.getInstance().setMenuItemEnable(MenuBarLabels.FILE_LOAD, true);
                    AnalyzerManager.getCurrentPage().updateView();
                }
            });
        }
    }

    private static class ForcedStopThread
    extends Thread {
        private ForcedStopThread() {
        }

        @Override
        public void run() {
            DataChannelThread.getInstance().stopForced();
            MessageParser.getInstance().stopForced();
            LogParser.getInstance().stopForced();
            DataManagerRegistry.stopThreadsForced();
            CallStackInserter.getInstance().stopForced();
        }
    }

    private static class NormalStopThread
    extends Thread {
        private NormalStopThread() {
        }

        @Override
        public void run() {
            DataChannelThread.getInstance().stopNormal();
            MessageParser.getInstance().stopNormal();
            LogParser.getInstance().stopNormal();
            DataManagerRegistry.stopThreadsNormal();
            CallStackInserter.getInstance().stopNormal();
        }
    }
}

