/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.handlers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.DALogExport;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.handlers.UIAction;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.TargetData;
import org.tizen.dynamicanalyzer.setting.UILayoutDataManager;
import org.tizen.dynamicanalyzer.ui.info.appStartup.AppStartupView;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.page.PageInfoRegistry;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfilingView;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.CallTraceView;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineChartManager;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineTableView;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DADialog;
import org.tizen.dynamicanalyzer.widgets.da.view.DATabComposite;

public class GUIAction
implements UIAction {
    public static final int DEFAULT_WARNING_WIDTH = 446;
    public static final int DEFAULT_WARNING_HEIGHT = 153;
    private static DACustomButtonClickEventListener exportListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            new DALogExport();
        }
    };
    private static SelectionListener exportButtonListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            new DALogExport();
            if (e.getSource() != null && e.getSource() instanceof Button) {
                ((Button)e.getSource()).getParent().getParent().dispose();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    @Override
    public void applyStartTraceUI() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                AnalyzerUtil.setLatestTraceMode(TimelinePage.pageID, true);
            }
        });
    }

    @Override
    public void applyStopTraceUI() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                AnalyzerUtil.setLatestTraceMode(TimelinePage.pageID, true);
            }
        });
    }

    @Override
    public void applyWebProfilingUI(final boolean isWeb) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DATabComposite timelineTabComp = (DATabComposite)AnalyzerUtil.getView(TimelinePage.pageID, TimelineTableView.tabID);
                AppStartupView appStartup = (AppStartupView)timelineTabComp.getView(TimelineTableView.appStartupViewID);
                appStartup.changeTable(isWeb);
                CallTraceView apiListView = (CallTraceView)AnalyzerUtil.getView(TimelinePage.pageID, TimelinePage.calltraceViewID);
                apiListView.changeTable(isWeb);
                FunctionUsageProfilingView userFunctionProfilingView = (FunctionUsageProfilingView)AnalyzerUtil.getView(TimelinePage.pageID, FunctionUsageProfilingView.class.getName());
                if (userFunctionProfilingView != null) {
                    userFunctionProfilingView.changeTable(isWeb);
                }
            }
        });
    }

    @Override
    public void showWarning(final String message, final int width, final int height) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                DADialog dialog = new DADialog(shell, DADialog.DIALOGTYPE.ERROR_WITH_EXPORT, 0, width, height);
                dialog.setIcon(ImageResources.DIALOG_ERROR_ICON);
                dialog.setMessage(message);
                dialog.setDialog();
                dialog.getExportButton().addSelectionListener(exportButtonListener);
                dialog.open();
            }
        });
    }

    @Override
    public void showWarning(DAResult result, int width, int height) {
        this.showWarning(String.valueOf(result.getMessage()) + " (" + result.getErrorNumber() + ")", width, height);
    }

    @Override
    public void showWarning(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                DADialog dialog = new DADialog(shell, DADialog.DIALOGTYPE.ERROR_WITH_EXPORT, 0);
                dialog.setIcon(ImageResources.DIALOG_ERROR_ICON);
                dialog.setMessage(message);
                dialog.setDialog();
                dialog.getExportButton().addSelectionListener(exportButtonListener);
                dialog.open();
            }
        });
    }

    @Override
    public void showWarning(String title, String message) {
    }

    @Override
    public void showWarning(DAResult result) {
        this.showWarning(String.valueOf(result.getMessage()) + " " + "(" + result.getErrorNumber() + ")");
    }

    @Override
    public void showWarning(final Shell shell, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DADialog dialog = new DADialog(shell, DADialog.DIALOGTYPE.ERROR_WITH_EXPORT, 0);
                dialog.setIcon(ImageResources.DIALOG_ERROR_ICON);
                dialog.setMessage(message);
                dialog.setDialog();
                dialog.getExportButton().addSelectionListener(exportButtonListener);
                dialog.open();
            }
        });
    }

    @Override
    public void showWarning(Shell shell, DAResult result) {
        this.showWarning(shell, String.valueOf(result.getMessage()) + " " + "(" + result.getErrorNumber() + ")");
    }

    @Override
    public List<String> getPageNames() {
        BaseView bv = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
        List idList = bv.getMainTab().getViewIDList();
        List<String> nameList = PageInfoRegistry.convertPageIDtoPageName(idList);
        return nameList;
    }

    @Override
    public void setUIElements(Project project) {
        this.setPages(project.getPageTabList());
        this.setCharts(project.getTimelineChartList());
    }

    private void setPages(String[] pageNames) {
        if (pageNames != null) {
            final HashSet<String> pageNameSet = new HashSet<String>(Arrays.asList(pageNames));
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    BaseView bv = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
                    bv.compositePages(pageNameSet);
                }
            });
        }
    }

    private void setCharts(String[] chartNames) {
        if (chartNames != null) {
            final List<String> chartNameList = Arrays.asList(chartNames);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    TimelineChartManager.getInstance().loadSelectedChartListByFile(chartNameList);
                }
            });
        }
    }

    @Override
    public void setUIElementsBySetting() {
        this.setPageBySetting();
        this.setChartBySetting();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                WorkbenchUtil.getWorkbenchWindow().getShell().layout(true, true);
            }
        });
    }

    @Override
    public void setPageBySetting() {
        TargetData target = SettingDataManager.INSTANCE.getConnectedTargetOrSelected();
        final String targetName = target.getTargetName();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Logger.debug((Object)targetName);
                BaseView bv = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
                bv.createPagesByTarget(targetName);
            }
        });
        UILayoutDataManager.INSTANCE.setDirty(false);
    }

    private void setChartBySetting() {
        final HashSet<String> selectedChartSet = new HashSet<String>();
        TargetData target = SettingDataManager.INSTANCE.getConnectedTargetOrSelected();
        Set<String> targetChartList = SettingDataManager.INSTANCE.getSelectedChartSet(target.getTargetName());
        selectedChartSet.addAll(targetChartList);
        selectedChartSet.addAll(SettingDataManager.INSTANCE.getOptionsSelectedFeatureChartSet());
        Logger.debug(selectedChartSet);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Logger.debug((Object)selectedChartSet);
                TimelineChartManager.getInstance().loadSelectedChartList(selectedChartSet);
            }
        });
    }
}

