/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.platform.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.swap.platform.BinarySettingManager;
import org.tizen.dynamicanalyzer.swap.platform.ui.InputRow;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;
import org.tizen.dynamicanalyzer.widgets.da.base.DATextBox;

public class SaveSettingDialog
extends DAMessageBox {
    private int MAX_SAVE_FILE_NAME_LENGTH = 35;
    private final String DEFAULT_TIME_FORMAT = "_yyyy-MM-dd-HH-mm-ss";
    private DATextBox textBox = null;
    private String saveFileName = null;
    private DAButton okButton = null;
    private DAButton cancelButton = null;
    private DACustomButtonClickEventListener okButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            SaveSettingDialog.this.saveFileName = SaveSettingDialog.this.textBox.getText();
            if (SaveSettingDialog.this.saveFileName.length() > SaveSettingDialog.this.MAX_SAVE_FILE_NAME_LENGTH) {
                String old = SaveSettingDialog.this.saveFileName;
                SaveSettingDialog.this.saveFileName = old.substring(0, SaveSettingDialog.this.MAX_SAVE_FILE_NAME_LENGTH - 1);
            }
            if (SaveSettingDialog.this.executeSaveTrace()) {
                SaveSettingDialog.this.setResult(1);
            }
            SaveSettingDialog.this.shell.dispose();
        }
    };
    private DACustomButtonClickEventListener cancelButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            SaveSettingDialog.this.shell.dispose();
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            if (!SaveSettingDialog.this.checkValidFileName(SaveSettingDialog.this.textBox.getText())) {
                SaveSettingDialog.this.okButton.setButtonEnabled(false);
            } else {
                SaveSettingDialog.this.okButton.setButtonEnabled(true);
            }
        }

        public void keyPressed(KeyEvent e) {
        }
    };

    public SaveSettingDialog(Shell parentShell, List<InputRow> inputs) {
        super(parentShell);
    }

    private String getSaveFileName() {
        String saveFileName;
        SimpleDateFormat format = new SimpleDateFormat("_yyyy-MM-dd-HH-mm-ss", Locale.KOREA);
        Date date = new Date();
        String tmpAppName = "da_";
        int length = tmpAppName.length() - this.MAX_SAVE_FILE_NAME_LENGTH;
        if (length > 0) {
            tmpAppName = tmpAppName.substring(0, this.MAX_SAVE_FILE_NAME_LENGTH - 1);
        }
        if ((saveFileName = String.valueOf(tmpAppName) + format.format(date)) == null || saveFileName.isEmpty()) {
            return null;
        }
        return saveFileName;
    }

    private boolean executeSaveTrace() {
        boolean success;
        block6: {
            String targetPath = String.valueOf(PathManager.DA_SETTING_PATH) + File.separator + this.saveFileName + ".setting";
            File saveFile = new File(targetPath);
            FileWriter fileWriter = null;
            BufferedWriter bufWriter = null;
            success = false;
            try {
                try {
                    fileWriter = new FileWriter(saveFile);
                    bufWriter = new BufferedWriter(fileWriter);
                    BinarySettingManager.getInstance().saveData(bufWriter);
                    success = true;
                }
                catch (IOException e) {
                    Logger.exception((Throwable)e);
                    CommonUtil.tryClose((Object[])new Object[]{bufWriter, fileWriter});
                    break block6;
                }
            }
            catch (Throwable throwable) {
                CommonUtil.tryClose((Object[])new Object[]{bufWriter, fileWriter});
                throw throwable;
            }
            CommonUtil.tryClose((Object[])new Object[]{bufWriter, fileWriter});
        }
        if (!success) {
            Logger.debug((Object)"save binary setting fail...");
            return false;
        }
        Logger.debug((Object)"save binary setting complete!!");
        return true;
    }

    protected boolean run() {
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(446, 149);
        this.shell.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.shell.setText("Save Binary Settings");
        AnalyzerUtil.setCenter(this.shell);
        Label label = new Label((Composite)this.shell, 0x40000000);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 11);
        data.left = new FormAttachment(0, 12);
        data.height = 15;
        data.width = 150;
        label.setLayoutData((Object)data);
        label.setForeground(ColorResources.BLACK);
        label.setText(AnalyzerLabels.SAVE_TRACE_DLG_SAVE_FILE_NAME);
        label.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.textBox = new DATextBox((Composite)this.shell, 4);
        data = new FormData();
        data.top = new FormAttachment((Control)label, 10);
        data.left = new FormAttachment(0, 9);
        data.height = 24;
        data.width = 410;
        this.textBox.setLayoutData((Object)data);
        this.textBox.setBackground(ColorResources.VIEW_BG_COLOR);
        this.textBox.getControl().addKeyListener(this.keyListener);
        Composite buttonComp = new Composite((Composite)this.shell, 0);
        buttonComp.setLayout((Layout)new FormLayout());
        buttonComp.setBackground(ColorResources.DIALOG_BG_LOWER);
        buttonComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_1);
                e.gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
                e.gc.setForeground(ColorResources.DIALOG_SUNKEN_2);
                e.gc.drawLine(rect.x, rect.y + 1, rect.x + rect.width, rect.y + 1);
            }
        });
        FormData compData = new FormData();
        compData.top = new FormAttachment(0, 76);
        compData.left = new FormAttachment(0, 0);
        compData.right = new FormAttachment(100, 0);
        compData.bottom = new FormAttachment(100, 0);
        buttonComp.setLayoutData((Object)compData);
        this.okButton = new DAButton(buttonComp, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 7);
        data.left = new FormAttachment(50, -90);
        data.height = 24;
        data.width = 86;
        this.okButton.setLayoutData((Object)data);
        this.okButton.setText(WidgetLabels.OK);
        this.okButton.addClickListener(this.okButtonListener);
        this.cancelButton = new DAButton(buttonComp, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 7);
        data.left = new FormAttachment(50, 4);
        data.height = 24;
        data.width = 86;
        this.cancelButton.setLayoutData((Object)data);
        this.cancelButton.setText(WidgetLabels.CANCEL);
        this.cancelButton.addClickListener(this.cancelButtonListener);
        this.saveFileName = this.getSaveFileName();
        if (this.saveFileName == null) {
            Logger.debug((Object)"save file name is null");
            return false;
        }
        this.textBox.setText(this.saveFileName);
        String textString = this.textBox.getText();
        this.textBox.getControl().setSelection(0, textString.length());
        return true;
    }

    private boolean checkValidFileName(String str) {
        return str != null && !str.isEmpty() && !str.contains("\\") && !str.contains("/") && !str.contains(":") && !str.contains("*") && !str.contains("\\?") && !str.contains("\"") && !str.contains("<") && !str.contains(">") && !str.contains("|");
    }
}

