/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.common.explorer;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.nl.WidgetLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.common.explorer.DAFileTreeExplorer;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;
import org.tizen.sdblib.service.FileEntry;

public class FileTreeExplorerDialog
extends DAMessageBox {
    private DAFileTreeExplorer explorerTree = null;
    private DACustomButton okButton = null;
    private DACustomButton cancelButton = null;

    public FileTreeExplorerDialog(Shell parentShell) {
        super(parentShell);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(500, 600);
        this.shell.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.shell.setText("Select binary");
        this.explorerTree = new DAFileTreeExplorer((Composite)this.shell);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 15);
        data.left = new FormAttachment(0, 20);
        data.height = 510;
        data.width = 460;
        this.explorerTree.setLayoutData(data);
        this.explorerTree.makeTree();
        this.cancelButton = new DAButton((Composite)this.shell, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.explorerTree, 10);
        data.right = new FormAttachment(100, -15);
        data.height = 25;
        data.width = 100;
        this.cancelButton.setLayoutData((Object)data);
        this.cancelButton.setText(WidgetLabels.CANCEL);
        this.cancelButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                FileTreeExplorerDialog.this.shell.dispose();
            }
        });
        this.okButton = new DAButton((Composite)this.shell, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.explorerTree, 10);
        data.right = new FormAttachment((Control)this.cancelButton, -5);
        data.height = 25;
        data.width = 100;
        this.okButton.setLayoutData((Object)data);
        this.okButton.setText(WidgetLabels.OK);
        this.okButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                FileTreeExplorerDialog.this.setResult(FileTreeExplorerDialog.this.explorerTree.getSelection());
                FileTreeExplorerDialog.this.shell.dispose();
            }
        });
        this.explorerTree.getTree().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                Grid table = (Grid)e.widget;
                GridItem[] items = table.getSelection();
                if (items == null || items.length == 0) {
                    return;
                }
                GridItem item = items[0];
                FileEntry entry = (FileEntry)item.getData();
                if (entry.isDirectory() || entry.isRoot()) {
                    if (item.isExpanded()) {
                        item.fireEvent(18);
                    } else {
                        item.fireEvent(17);
                    }
                } else {
                    FileTreeExplorerDialog.this.setResult(entry);
                    FileTreeExplorerDialog.this.shell.dispose();
                }
            }
        });
    }
}

