/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.callstack;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.IResultSet;
import org.tizen.dynamicanalyzer.util.Logger;

public class CallStackDataDBTable
extends DBTable {
    private static final String TABLENAME = "CALL_STACK_DATA";
    private static final String queryto_withSeq = "where %s = %s";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public CallStackDataDBTable() {
        this.addColumn(new DBColumn(COLUMN.SEQUENCE_NUMBER.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.ADDRESS_ARRAY.name, "NOT NULL", "BIGINT ARRAY"));
    }

    public List<List<Object>> getCallStackAddrsFromDB(long seq) {
        String where = String.format(queryto_withSeq, COLUMN.SEQUENCE_NUMBER.name, seq);
        ArrayList<String> selectColumn = new ArrayList<String>();
        selectColumn.add(COLUMN.ADDRESS_ARRAY.name);
        return this.selectData(selectColumn, where, new IResultSet(){

            @Override
            public List<Object> extractDataFromResultSet(ResultSet rs) {
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(CallStackDataDBTable.this.getArrayFromResultSet(rs, 1, 0L));
                return row;
            }
        });
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(COLUMN.SEQUENCE_NUMBER.index + 1, (Long)rowData.get(COLUMN.SEQUENCE_NUMBER.index));
                this.setArrayToPreparedStatement(COLUMN.ADDRESS_ARRAY.index, "BIGINT", prep, rowData);
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            Object[] buf;
            row.add(rs.getLong(COLUMN.SEQUENCE_NUMBER.index + 1));
            ArrayList<Long> addrs = new ArrayList<Long>();
            Object[] objectArray = buf = (Object[])rs.getArray(COLUMN.ADDRESS_ARRAY.index + 1).getArray();
            int n = buf.length;
            int n2 = 0;
            while (n2 < n) {
                Object b = objectArray[n2];
                addrs.add((Long)b);
                ++n2;
            }
            row.add(addrs);
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        SEQUENCE_NUMBER(0, "SEQUENCE_NUMBER"),
        ADDRESS_ARRAY(1, "ADDRESS_ARRAY");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

