/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.interactive.chart;

import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.widgets.Canvas;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.ui.interactive.InteractivePage;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;

public class InteractiveChartMouseEventListener
extends MouseAdapter
implements MouseMoveListener {
    private RangeDataManager rangeDataManager = RangeDataManager.getInstance();
    private DAPopupMenu menu;
    private DATimeline timeline;
    private DAChartBoard chartBoard;
    private double baseTime = -1.0;
    private static final int SELECTION_MARKER_INDEX = 0;

    public InteractiveChartMouseEventListener(DAPopupMenu menu, DATimeline timeline, DAChartBoard chartBoard) {
        this.menu = menu;
        this.timeline = timeline;
        this.chartBoard = chartBoard;
    }

    public void mouseDown(MouseEvent e) {
        DAChart chart = (DAChart)e.widget;
        DAChartPlot plot = chart.getPlot();
        DAChartPlotMarker marker = (DAChartPlotMarker)plot.getMarkers().get(0);
        if (!(marker instanceof DAChartPlotIntervalMarker)) {
            return;
        }
        DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)marker;
        double eventTime = plot.getXFromXPixel(e.x);
        if (e.button == 3) {
            List itemList = this.menu.getItems();
            DAPopupMenuItem startItem = (DAPopupMenuItem)itemList.get(0);
            DAPopupMenuItem endItem = (DAPopupMenuItem)itemList.get(1);
            DAPopupMenuItem fromSelectionItem = (DAPopupMenuItem)itemList.get(2);
            DAPopupMenuItem analysisItem = (DAPopupMenuItem)itemList.get(3);
            DAPopupMenuItem clearItem = (DAPopupMenuItem)itemList.get(4);
            if (eventTime * 1000000.0 <= (double)Toolbar.INSTANCE.getTime()) {
                startItem.setEnabled(true);
                endItem.setEnabled(true);
                analysisItem.setEnabled(this.rangeDataManager.isAnalyzable());
                clearItem.setEnabled(this.rangeDataManager.isBeingAnalyzed());
                startItem.setDoubleData(eventTime);
                endItem.setDoubleData(eventTime);
            } else {
                startItem.setEnabled(false);
                endItem.setEnabled(false);
                analysisItem.setEnabled(this.rangeDataManager.isAnalyzable());
                clearItem.setEnabled(this.rangeDataManager.isBeingAnalyzed());
            }
            if (intervalMarker.getStartVal() != intervalMarker.getEndVal()) {
                fromSelectionItem.setEnabled(true);
            } else {
                fromSelectionItem.setEnabled(false);
            }
            return;
        }
        AnalyzerUtil.setLatestTraceMode(InteractivePage.pageID, false);
        boolean bShift = false;
        if ((e.stateMask & 0x20000) != 0) {
            bShift = true;
        }
        if (bShift && intervalMarker.getStartVal() != -1.0) {
            if (this.baseTime > eventTime) {
                intervalMarker.setInterval(eventTime, this.baseTime);
            } else {
                intervalMarker.setInterval(this.baseTime, eventTime);
            }
        } else {
            intervalMarker.setInterval(eventTime, eventTime);
            this.baseTime = eventTime;
        }
        chart.redraw();
    }

    public void mouseUp(MouseEvent e) {
        double markerEndTime;
        double markerStartTime;
        if (e.button == 3) {
            return;
        }
        DAChart chart = (DAChart)e.widget;
        DAChartPlot plot = chart.getPlot();
        DAChartPlotMarker marker = (DAChartPlotMarker)plot.getMarkers().get(0);
        if (!(marker instanceof DAChartPlotIntervalMarker)) {
            return;
        }
        DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)marker;
        double eventTime = plot.getXFromXPixel(e.x);
        if (intervalMarker.getStartVal() >= eventTime) {
            markerStartTime = eventTime;
            markerEndTime = intervalMarker.getEndVal();
        } else {
            markerStartTime = intervalMarker.getStartVal();
            markerEndTime = eventTime;
        }
        double toolbarTime = (double)Toolbar.INSTANCE.getTime() / 1000000.0;
        if (markerStartTime < 0.0) {
            markerStartTime = 0.0;
        } else if (markerStartTime > toolbarTime) {
            markerStartTime = toolbarTime;
        }
        if (markerEndTime > toolbarTime) {
            markerEndTime = toolbarTime;
        } else if (markerEndTime < 0.0) {
            markerEndTime = 0.0;
        }
        if (markerEndTime <= plot.getVisibleEndX()) {
            intervalMarker.setInterval(markerStartTime, markerEndTime);
        } else {
            intervalMarker.setInterval(markerStartTime, plot.getVisibleEndX());
        }
        this.sendSelectionTimes(intervalMarker.getStartVal(), intervalMarker.getEndVal());
    }

    public void mouseMove(MouseEvent e) {
        double newStartVal;
        double oldStartVal;
        double newYPosRatio;
        DAChartPlotTooltip tooltip;
        DAChart chart = (DAChart)e.widget;
        DAChartPlot plot = chart.getPlot();
        DAChartPlotMarker marker = (DAChartPlotMarker)plot.getMarkers().get(0);
        if (!(marker instanceof DAChartPlotIntervalMarker)) {
            Logger.debug((Object)"mouseMove !IntervalMarker");
            return;
        }
        DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)marker;
        if ((e.stateMask & 0x80000) != 0) {
            double eventTime = plot.getXFromXPixel(e.x);
            if (this.baseTime > eventTime) {
                intervalMarker.setInterval(eventTime, this.baseTime);
            } else {
                intervalMarker.setInterval(this.baseTime, eventTime);
            }
        }
        if ((tooltip = plot.getTooltip()) == null) {
            return;
        }
        double oldYPosRatio = tooltip.getYPosRatio();
        if (Double.compare(oldYPosRatio, newYPosRatio = (double)e.y / (double)((Canvas)e.widget).getSize().y) != 0) {
            if (newYPosRatio < 0.0) {
                newYPosRatio = 0.01;
            } else if (newYPosRatio >= 1.0) {
                newYPosRatio = 0.99;
            }
            tooltip.setYPosRatio(newYPosRatio);
        }
        if ((oldStartVal = tooltip.getStartVal()) != (newStartVal = this.getTooltipStartX(plot, chart.getSeriesList(), e.x, newYPosRatio))) {
            tooltip.setStartVal(newStartVal);
        }
        this.timeline.setDetailTime(plot.getXFromXPixel(e.x));
        this.timeline.setDetailTimePosition(e.x);
        this.timeline.setDrawDetailTime(true);
        this.timeline.redraw();
    }

    private void sendSelectionTimes(double start, double end) {
        long endTime = (long)(end * 1000000.0);
        long startTime = (long)(start * 1000000.0);
        if (endTime < startTime) {
            long temp = startTime;
            startTime = endTime;
            endTime = temp;
        }
        if (startTime < 0L) {
            startTime = 0L;
        }
        DAChartBoardItem selectedItem = this.chartBoard.getSelectItem();
        Object data = selectedItem.getData();
        AnalyzerManager.getCurrentPage().updateView((DAViewData)new DASelectionData(InteractivePage.chartViewID, startTime, endTime, data, null));
    }

    private double getTooltipStartX(DAChartPlot plot, List<DAChartSeries> seriesList, int x, double yPosRatio) {
        double ret = -1.0;
        int i = 0;
        while (i < seriesList.size()) {
            double startVal;
            DAChartSeries series = seriesList.get(i);
            int index = series.getPrevIndexByXvalue(plot.getXFromXPixel(x));
            if (-1 != index && ret < (startVal = ((DAChartSeriesItem)series.getSeriesItemList().get(index)).getX())) {
                ret = startVal;
            }
            ++i;
        }
        return ret;
    }
}

