/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.interactive.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.FunctionBodyInstrumentData;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.ui.interactive.InteractivePage;
import org.tizen.dynamicanalyzer.ui.interactive.chart.InteractiveChartView;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveUIData;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveValue;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveValueDBTable;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveVariableDBTable;
import org.tizen.dynamicanalyzer.ui.interactive.model.InteractiveInfo;
import org.tizen.dynamicanalyzer.ui.interactive.model.InteractiveParser;
import org.tizen.dynamicanalyzer.ui.interactive.model.VAR_TYPE;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.timeline.chart.CPUChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.CPUCoreChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.CPUFrequencyChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.DeviceChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.DiskIOChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.EnergyChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.HeapChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.NetworkIOChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.ProcessMemoryChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.ScreenshotChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.SystemMemoryChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.ui.timeline.chart.UIEventChart;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.widgets.chartBoard.IDAChartSeriesMaker;

public class InteractiveDataManager
extends PageDataManager
implements IDAChartSeriesMaker {
    private static InteractiveDataManager instance = null;
    private InteractiveVariableDBTable variableDBTable = null;
    private InteractiveValueDBTable valueDBTable = null;
    private DBInserter valueDBInserter = null;
    private List<InteractiveInfo> variableInfoList = new ArrayList<InteractiveInfo>();
    private InteractiveChartView chartView;
    private List<TimelineChart> timelineChartList = new ArrayList<TimelineChart>();
    private List<TimelineChart> showTimelineChartList = new ArrayList<TimelineChart>();

    private InteractiveDataManager() {
        this.variableDBTable = new InteractiveVariableDBTable();
        this.valueDBTable = new InteractiveValueDBTable();
        this.valueDBInserter = this.makeInserter(this.valueDBTable);
        this.timelineChartList.add(new CPUChart(InteractivePage.pageID));
        this.timelineChartList.add(new CPUCoreChart(InteractivePage.pageID));
        this.timelineChartList.add(new CPUFrequencyChart(InteractivePage.pageID));
        this.timelineChartList.add(new HeapChart(InteractivePage.pageID));
        this.timelineChartList.add(new ProcessMemoryChart(InteractivePage.pageID));
        this.timelineChartList.add(new SystemMemoryChart(InteractivePage.pageID));
        this.timelineChartList.add(new ScreenshotChart(InteractivePage.pageID));
        this.timelineChartList.add(new UIEventChart(InteractivePage.pageID));
        this.timelineChartList.add(new DiskIOChart(InteractivePage.pageID));
        this.timelineChartList.add(new NetworkIOChart(InteractivePage.pageID));
        this.timelineChartList.add(new DeviceChart(InteractivePage.pageID));
        this.timelineChartList.add(new EnergyChart(InteractivePage.pageID));
    }

    public static synchronized InteractiveDataManager getInstance() {
        if (instance == null) {
            instance = new InteractiveDataManager();
        }
        return instance;
    }

    public List<InteractiveInfo> getVariableInfoList() {
        return this.variableInfoList;
    }

    public void setChartView(InteractiveChartView chartView) {
        this.chartView = chartView;
    }

    public List<TimelineChart> getTimelineChartList() {
        return this.timelineChartList;
    }

    public List<TimelineChart> getShowTimelineChartList() {
        return this.showTimelineChartList;
    }

    public void setShowTimelineChartList(List<TimelineChart> chartList) {
        this.showTimelineChartList.clear();
        this.showTimelineChartList.addAll(chartList);
    }

    public void addVariableInfo(InteractiveInfo info) {
        this.variableInfoList.add(info);
    }

    public static ResultSet getValueDataFromDB(long start, long end) {
        String query = "SELECT SEQUENCE_NUMBER, SAMPLING_TIME, VARIABLE_ID, VALUE_SIZE, VALUE FROM CHECKPOINT_VALUE WHERE SAMPLING_TIME BETWEEN " + start + " AND " + end + " ORDER BY SAMPLING_TIME";
        ResultSet rs = SqlConnectionManager.executeQueryRS(query);
        return rs;
    }

    public ResultSet getValueDataFromDB(InteractiveInfo interactiveInfo) {
        String query = "SELECT SEQUENCE_NUMBER, SAMPLING_TIME, VARIABLE_ID, VALUE_SIZE, VALUE FROM CHECKPOINT_VALUE WHERE VARIABLE_ID IN (";
        ArrayList<Long> variableIDList = new ArrayList<Long>();
        interactiveInfo.getAllRelatedVariableIDs(variableIDList, interactiveInfo.getCheckLocation());
        int i = 0;
        while (i < variableIDList.size()) {
            query = String.valueOf(query) + variableIDList.get(i);
            if (i + 1 < variableIDList.size()) {
                query = String.valueOf(query) + ",";
            }
            ++i;
        }
        query = String.valueOf(query) + ")";
        ResultSet rs = SqlConnectionManager.executeQueryRS(query);
        return rs;
    }

    @Override
    public void saveData(Map<String, String> dataMap) {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        this.insertVariableInfo(this.variableInfoList, list);
        this.variableDBTable.insertData(list);
    }

    private void insertVariableInfo(List<InteractiveInfo> infoList, List<List<Object>> list) {
        int i = 0;
        while (i < infoList.size()) {
            ArrayList<Object> dbVariableData = new ArrayList<Object>();
            InteractiveInfo info = infoList.get(i);
            dbVariableData.add(info.getVariableID(1));
            dbVariableData.add(info.getVariableID(2));
            dbVariableData.add(info.getCheckLocation());
            dbVariableData.add(info.getType().ordinal());
            dbVariableData.add(info.getTypeName());
            dbVariableData.add(info.getVariableName());
            dbVariableData.add(info.getFunctionID());
            dbVariableData.add(info.getSourceLineNum());
            dbVariableData.add(info.getSourceFileName());
            dbVariableData.add(info.getPointerOrder());
            dbVariableData.add(info.getPointerSize());
            dbVariableData.add(info.getArrayCount());
            dbVariableData.add(info.getByteSize());
            dbVariableData.add(info.getOffset());
            dbVariableData.add(info.isTarget());
            dbVariableData.add(info.getChildrenIDs());
            list.add(dbVariableData);
            if (info.getChildren() != null) {
                this.insertVariableInfo(info.getChildren(), list);
            }
            ++i;
        }
    }

    @Override
    public void openData(Map<String, String> dataMap) {
        this.variableInfoList.clear();
        List<List<Object>> datas = this.variableDBTable.selectAllColumnData(null);
        if (datas == null) {
            return;
        }
        HashMap<InteractiveInfo, List<Long>> relationMap = new HashMap<InteractiveInfo, List<Long>>();
        int i = 0;
        while (i < datas.size()) {
            List<Object> row = datas.get(i);
            long beforeVariableID = (Long)row.get(InteractiveVariableDBTable.COLUMN.BEFORE_VARIABLE_ID.ordinal());
            long afterVariableID = (Long)row.get(InteractiveVariableDBTable.COLUMN.AFTER_VARIABLE_ID.ordinal());
            int checkLocation = (Integer)row.get(InteractiveVariableDBTable.COLUMN.CHECK_LOCATION.ordinal());
            VAR_TYPE variableType = VAR_TYPE.values()[(Integer)row.get(InteractiveVariableDBTable.COLUMN.VARIABLE_TYPE.ordinal())];
            String typeName = (String)row.get(InteractiveVariableDBTable.COLUMN.VARIABLE_TYPE_NAME.ordinal());
            String variableName = (String)row.get(InteractiveVariableDBTable.COLUMN.VARIABLE_NAME.ordinal());
            int functionID = (Integer)row.get(InteractiveVariableDBTable.COLUMN.FUNCTION_ID.ordinal());
            int sourceLineNum = (Integer)row.get(InteractiveVariableDBTable.COLUMN.SOURCE_LINE_NUMBER.ordinal());
            String sourceFileName = (String)row.get(InteractiveVariableDBTable.COLUMN.SOURCE_FILE_NAME.ordinal());
            int pointerOrder = (Integer)row.get(InteractiveVariableDBTable.COLUMN.POINTER_ORDER.ordinal());
            int pointerSize = (Integer)row.get(InteractiveVariableDBTable.COLUMN.POINTER_SIZE.ordinal());
            int arrayCount = (Integer)row.get(InteractiveVariableDBTable.COLUMN.ARRAY_COUNT.ordinal());
            int byteSize = (Integer)row.get(InteractiveVariableDBTable.COLUMN.BYTE_SIZE.ordinal());
            boolean isTarget = (Boolean)row.get(InteractiveVariableDBTable.COLUMN.IS_TARGET.ordinal());
            int offset = (Integer)row.get(InteractiveVariableDBTable.COLUMN.OFFSET.ordinal());
            List childrenID = (List)row.get(InteractiveVariableDBTable.COLUMN.CHILDREN_VARIABLE_ID.ordinal());
            InteractiveInfo valueInfo = new InteractiveInfo();
            valueInfo.setVariableID(1, beforeVariableID);
            valueInfo.setVariableID(2, afterVariableID);
            valueInfo.setCheckLocation(checkLocation);
            valueInfo.setType(variableType);
            valueInfo.setTypeName(typeName);
            valueInfo.setVariableName(variableName);
            valueInfo.setFunctionID(functionID);
            valueInfo.setSourceLineNum(sourceLineNum);
            valueInfo.setSourceFileName(sourceFileName);
            valueInfo.setPointerOrder(pointerOrder);
            valueInfo.setPointerSize(pointerSize);
            valueInfo.setArrayCount(arrayCount);
            valueInfo.setByteSize(byteSize);
            valueInfo.setOffset(offset);
            valueInfo.setTarget(isTarget);
            if (isTarget) {
                this.variableInfoList.add(valueInfo);
            }
            relationMap.put(valueInfo, childrenID);
            ++i;
        }
        this.makeRelation(relationMap);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (InteractiveDataManager.this.chartView != null) {
                    InteractiveDataManager.this.chartView.clear();
                }
            }
        });
    }

    private void makeRelation(Map<InteractiveInfo, List<Long>> relationMap) {
        for (InteractiveInfo parent : relationMap.keySet()) {
            List<Long> childrenIDs = relationMap.get(parent);
            if (childrenIDs == null) continue;
            ArrayList<InteractiveInfo> children = new ArrayList<InteractiveInfo>();
            int i = 0;
            while (i < childrenIDs.size()) {
                InteractiveInfo child = this.findInfo(relationMap.keySet(), childrenIDs.get(i));
                if (child == null) {
                    Logger.error((Object)"Child does not exist.");
                } else {
                    if (!children.contains(child)) {
                        child.setParent(parent);
                        children.add(child);
                    }
                    parent.setChildren(children);
                }
                ++i;
            }
        }
    }

    private InteractiveInfo findInfo(Set<InteractiveInfo> infoSet, long variableID) {
        for (InteractiveInfo target : infoSet) {
            if (!target.hasVariableID(variableID)) continue;
            return target;
        }
        return null;
    }

    @Override
    protected void makeData(LogPackage pack) {
        List<LogData> fbiLogList;
        Logs fbiLogs = pack.getLogs(32);
        List<LogData> list = fbiLogList = fbiLogs == null ? null : fbiLogs.getRawLogs();
        if (fbiLogList != null) {
            ArrayList valueDataList = new ArrayList();
            int i = 0;
            while (i < fbiLogList.size()) {
                FunctionBodyInstrumentData log = (FunctionBodyInstrumentData)fbiLogList.get(i);
                try {
                    long variableID = log.getVariableID().getValue();
                    long size = log.getSize().getValue();
                    byte[] data = log.getData();
                    ArrayList<Object> dbValueData = new ArrayList<Object>();
                    dbValueData.add(new Long(log.getSeq()));
                    dbValueData.add(new Long(log.getTime()));
                    dbValueData.add(new Long(variableID));
                    dbValueData.add(new Long(size));
                    dbValueData.add(data);
                    valueDataList.add(dbValueData);
                }
                catch (UnsupportedProtocolException ex) {
                    Logger.exception((Throwable)ex);
                }
                ++i;
            }
            this.valueDBInserter.pushData(valueDataList);
        }
    }

    public void makeChartSeries(long startTime, long endTime) {
        this.chartView.inputChartSeries(InteractiveDataManager.getValueDataFromDB(startTime, endTime));
        List<List<Object>> systemDBData = TimelineDataManager.getInstance().getSystemDataFromDB(startTime, endTime);
        List<List<Object>> uiEventDBData = TimelineDataManager.getInstance().getUIEventDataFromDB(startTime, endTime);
        List<List<Object>> screenShotDBData = TimelineDataManager.getInstance().getScreenShotDataFromDB(startTime, endTime);
        int selectedPID = 0;
        if (Toolbar.INSTANCE != null) {
            selectedPID = Toolbar.INSTANCE.getSelectedPid();
        }
        Map<Integer, List<List<Object>>> targetProcessDBData = TimelineDataManager.getInstance().getTargetProcessDataFromDB(startTime, endTime, selectedPID);
        for (TimelineChart chart : this.timelineChartList) {
            ArrayList<Object> dataList;
            if (chart.getProbeType() == 5) {
                dataList = new ArrayList<Object>();
                dataList.add(systemDBData);
                dataList.add(targetProcessDBData);
                chart.inputChartSeries(dataList);
                continue;
            }
            if (chart.getProbeType() == 259) {
                dataList = new ArrayList();
                dataList.add(uiEventDBData);
                chart.inputChartSeries(dataList);
                continue;
            }
            if (chart.getProbeType() != 262) continue;
            dataList = new ArrayList();
            dataList.add(screenShotDBData);
            chart.inputChartSeries(dataList);
        }
    }

    public Map<Long, List<InteractiveValue>> makeInteractiveValueMap(ResultSet rs) {
        if (rs == null) {
            return null;
        }
        HashMap<Long, List<InteractiveValue>> valueInfoMap = new HashMap<Long, List<InteractiveValue>>();
        try {
            try {
                while (rs.next()) {
                    long seq = rs.getLong(1);
                    long time = rs.getLong(2);
                    long id = rs.getLong(3);
                    byte[] value = rs.getBytes(5);
                    ArrayList<InteractiveValue> valueInfoList = (ArrayList<InteractiveValue>)valueInfoMap.get(id);
                    if (valueInfoList == null) {
                        valueInfoList = new ArrayList<InteractiveValue>();
                        valueInfoMap.put(id, valueInfoList);
                    }
                    valueInfoList.add(new InteractiveValue(seq, time, id, value));
                }
            }
            catch (SQLException e) {
                Logger.error((Object)e);
                SqlConnectionManager.releaseResultSet(rs);
                return null;
            }
        }
        finally {
            SqlConnectionManager.releaseResultSet(rs);
        }
        if (valueInfoMap.isEmpty()) {
            return null;
        }
        return valueInfoMap;
    }

    public boolean makeInteractiveUIData(InteractiveInfo interactiveInfo, Map<Long, List<InteractiveValue>> valueInfoMap, List<InteractiveUIData> beforeUIDataList, List<InteractiveUIData> afterUIDataList) {
        List<InteractiveValue> rootBeforeValueInfoList = valueInfoMap.get(interactiveInfo.getVariableID(1));
        List<InteractiveValue> rootAfterValueInfoList = valueInfoMap.get(interactiveInfo.getVariableID(2));
        if (rootBeforeValueInfoList == null && rootAfterValueInfoList == null) {
            return false;
        }
        ArrayList<List<InteractiveValue>> childrenBeforeValueInfoList = new ArrayList<List<InteractiveValue>>();
        ArrayList<List<InteractiveValue>> childrenAfterValueInfoList = new ArrayList<List<InteractiveValue>>();
        for (long variableID : valueInfoMap.keySet()) {
            if (interactiveInfo.hasChild(variableID, 1)) {
                childrenBeforeValueInfoList.add(valueInfoMap.get(variableID));
                continue;
            }
            if (!interactiveInfo.hasChild(variableID, 2)) continue;
            childrenAfterValueInfoList.add(valueInfoMap.get(variableID));
        }
        this.parseValue(interactiveInfo, 1, rootBeforeValueInfoList, childrenBeforeValueInfoList, beforeUIDataList);
        this.parseValue(interactiveInfo, 2, rootAfterValueInfoList, childrenAfterValueInfoList, afterUIDataList);
        return true;
    }

    private void parseValue(InteractiveInfo interactiveInfo, int checkLocation, List<InteractiveValue> rootValueInfoList, List<List<InteractiveValue>> childrenValueInfoList, List<InteractiveUIData> parsedUIDataList) {
        if (rootValueInfoList == null) {
            return;
        }
        int i = 0;
        while (i < rootValueInfoList.size()) {
            HashMap<Long, byte[]> valueMap = new HashMap<Long, byte[]>();
            valueMap.put(interactiveInfo.getVariableID(checkLocation), rootValueInfoList.get((int)i).value);
            int k = 0;
            while (k < childrenValueInfoList.size()) {
                if (childrenValueInfoList.get(k).size() > i) {
                    InteractiveValue valueInfo = childrenValueInfoList.get(k).get(i);
                    valueMap.put(valueInfo.variableID, valueInfo.value);
                } else {
                    Logger.error((Object)"rootValueInfo size is larger than childrenValueInfo size.");
                }
                ++k;
            }
            InteractiveUIData uiData = InteractiveParser.parseValue(interactiveInfo, checkLocation, valueMap);
            if (uiData != null) {
                uiData.setSeq(rootValueInfoList.get((int)i).seq);
                uiData.setTime(rootValueInfoList.get((int)i).time);
                parsedUIDataList.add(uiData);
            }
            ++i;
        }
    }

    public void clear() {
        BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
        if (baseView != null) {
            baseView.removeTabViewPage(InteractivePage.pageID, true);
        } else {
            Logger.error((Object)"BaseView is null!!");
        }
        this.variableInfoList.clear();
    }
}

