/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.interactive.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayType;
import org.eclipse.cdt.debug.edc.internal.symbols.IConstType;
import org.eclipse.cdt.debug.edc.internal.symbols.IField;
import org.eclipse.cdt.debug.edc.internal.symbols.ILexicalBlockScope;
import org.eclipse.cdt.debug.edc.internal.symbols.IPointerType;
import org.eclipse.cdt.debug.edc.internal.symbols.ITypedef;
import org.eclipse.cdt.debug.edc.internal.symbols.LexicalBlockScope;
import org.eclipse.cdt.debug.edc.internal.symbols.StructType;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfCompileUnit;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfDebugInfoProvider;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfInfoReader;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.LocationExpression;
import org.eclipse.cdt.debug.edc.internal.symbols.files.ElfExecutableSymbolicsReaderFactory;
import org.eclipse.cdt.debug.edc.symbols.ICompileUnitScope;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.cdt.debug.edc.symbols.ILocationProvider;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.IVariable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveUIData;
import org.tizen.dynamicanalyzer.ui.interactive.model.InteractiveIDGenerator;
import org.tizen.dynamicanalyzer.ui.interactive.model.InteractiveInfo;
import org.tizen.dynamicanalyzer.ui.interactive.model.VAR_TYPE;
import org.tizen.dynamicanalyzer.util.ByteUtil;
import org.tizen.dynamicanalyzer.util.Logger;

public class InteractiveParser {
    private static int GLOBAL_VARIABLE_ID = 255;

    public static InteractiveUIData parseValue(InteractiveInfo interactiveInfo, int checkLocation, Map<Long, byte[]> valueMap) {
        InteractiveUIData uiData = null;
        byte[] value = valueMap.get(interactiveInfo.getVariableID(checkLocation));
        if (value != null && value.length > 0) {
            if (!interactiveInfo.isStructType() && !interactiveInfo.isArray()) {
                uiData = InteractiveParser.parseScalar(interactiveInfo, checkLocation, value);
            } else if (interactiveInfo.isArray()) {
                uiData = InteractiveParser.parseArray(interactiveInfo, checkLocation, value, valueMap);
            } else if (interactiveInfo.isStructType()) {
                uiData = InteractiveParser.parseStruct(interactiveInfo, checkLocation, value, valueMap);
            } else {
                Logger.warning((Object)"value is not scalar, array, struct.");
            }
        }
        return uiData;
    }

    private static InteractiveUIData parseScalar(InteractiveInfo info, int checkLocation, byte[] data) {
        InteractiveUIData uiData = new InteractiveUIData(info, checkLocation);
        Object value = null;
        switch (info.getType()) {
            case CHAR: 
            case UNSIGNED_CHAR: 
            case SIGNED_CHAR: {
                if (info.getPointerOrder() > 0) {
                    value = ByteUtil.getString((byte[])data, (int)0);
                    break;
                }
                value = new Character((char)data[0]);
                break;
            }
            case INT: {
                value = ByteUtil.toInt((byte[])data);
                break;
            }
            case UNSIGNED_INT: {
                value = ByteUtil.toUnsignedInt((byte[])data, (int)0);
                break;
            }
            case SHORT: {
                value = ByteUtil.toShort((byte[])data, (int)0);
                break;
            }
            case UNSIGNED_SHORT: {
                value = ByteUtil.toUnsignedShort((byte[])data, (int)0);
                break;
            }
            case LONG: {
                if (info.getByteSize() == 4) {
                    value = ByteUtil.toInt((byte[])data);
                    break;
                }
                if (info.getByteSize() != 8) break;
                value = ByteUtil.toLong((byte[])data);
                break;
            }
            case UNSIGNED_LONG: {
                if (info.getByteSize() == 4) {
                    value = ByteUtil.toUnsignedInt((byte[])data, (int)0);
                    break;
                }
                if (info.getByteSize() != 8) break;
                value = InteractiveParser.toUnsignedLong(ByteUtil.toLong((byte[])data));
                break;
            }
            case FLOAT: {
                value = Float.valueOf(ByteUtil.toFloat((byte[])data, (int)0));
                break;
            }
            case DOUBLE: 
            case LONG_DOUBLE: {
                if (info.getByteSize() == 8) {
                    value = ByteUtil.toDouble((byte[])data, (int)0);
                    break;
                }
                Logger.warning((Object)("Long double is not 8bytes : " + info.getByteSize()));
                break;
            }
            default: {
                Logger.warning((Object)"undefined variable type!!");
            }
        }
        uiData.setValue(value);
        return uiData;
    }

    /*
     * Unable to fully structure code
     */
    private static String toUnsignedLong(long x) {
        block3: {
            radix = 10;
            if (x == 0L) {
                return "0";
            }
            buf = new char[64];
            i = buf.length;
            if (x >= 0L) ** GOTO lbl18
            top = x >>> 32;
            bot = (x & 0xFFFFFFFFL) + (top % (long)radix << 32);
            top /= (long)radix;
            while (bot > 0L || top > 0L) {
                buf[--i] = Character.forDigit((int)(bot % (long)radix), radix);
                bot = bot / (long)radix + (top % (long)radix << 32);
                top /= (long)radix;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                buf[--i] = Character.forDigit((int)(x % (long)radix), radix);
                x /= (long)radix;
lbl18:
                // 2 sources

                ** while (x > 0L)
            }
        }
        return new String(buf, i, buf.length - i);
    }

    private static InteractiveUIData parseStruct(InteractiveInfo info, int checkLocation, byte[] data, Map<Long, byte[]> valueMap) {
        InteractiveUIData uiData = new InteractiveUIData(info, checkLocation);
        ArrayList<InteractiveUIData> children = new ArrayList<InteractiveUIData>();
        if (info.getChildren() != null) {
            int i = 0;
            while (i < info.getChildren().size()) {
                InteractiveInfo memberInfo = info.getChildren().get(i);
                int offset = memberInfo.getOffset();
                int byteSize = memberInfo.getByteSize();
                InteractiveUIData memberUiData = null;
                if (!(memberInfo.isStructType() || memberInfo.isPointerType() || memberInfo.isArray())) {
                    memberUiData = InteractiveParser.parseScalar(memberInfo, checkLocation, Arrays.copyOfRange(data, offset, offset + byteSize));
                } else if (memberInfo.isArray() && !memberInfo.isPointerType()) {
                    int lastIndex = offset + memberInfo.getArrayCount() * byteSize;
                    memberUiData = InteractiveParser.parseArray(memberInfo, checkLocation, Arrays.copyOfRange(data, offset, lastIndex), valueMap);
                } else if (memberInfo.isArray() && memberInfo.isPointerType()) {
                    int lastIndex = offset + memberInfo.getArrayCount() * memberInfo.getPointerSize();
                    memberUiData = InteractiveParser.parseArray(memberInfo, checkLocation, Arrays.copyOfRange(data, offset, lastIndex), valueMap);
                } else if (memberInfo.isPointerType()) {
                    memberUiData = new InteractiveUIData(memberInfo, checkLocation);
                    byte[] stream = valueMap.get(memberInfo.getVariableID(checkLocation));
                    if (stream != null) {
                        memberUiData = InteractiveParser.parseValue(memberInfo, checkLocation, valueMap);
                    } else {
                        int pointerSize = memberInfo.getPointerSize();
                        byte[] address = ByteUtil.toBytesN((byte[])data, (int)offset, (int)pointerSize);
                        if (pointerSize == 4) {
                            memberUiData.setValue("0x" + Integer.toHexString(ByteUtil.toInt((byte[])address)));
                        } else if (pointerSize == 8) {
                            memberUiData.setValue("0x" + Long.toHexString(ByteUtil.toLong((byte[])address)));
                        }
                    }
                } else if (memberInfo.isStructType()) {
                    memberUiData = InteractiveParser.parseStruct(memberInfo, checkLocation, Arrays.copyOfRange(data, offset, offset + byteSize), valueMap);
                } else {
                    Logger.warning((Object)"Unhandled case!!");
                }
                children.add(memberUiData);
                ++i;
            }
        }
        uiData.setChildren(children);
        return uiData;
    }

    private static InteractiveUIData parseArray(InteractiveInfo info, int checkLocation, byte[] data, Map<Long, byte[]> valueMap) {
        InteractiveUIData uiData = new InteractiveUIData(info, checkLocation);
        uiData.setArray(true);
        String arrayValue = "[ ";
        ArrayList<InteractiveUIData> children = new ArrayList<InteractiveUIData>();
        int index = 0;
        int byteSize = info.getPointerOrder() > 0 ? info.getPointerSize() : info.getByteSize();
        int i = 0;
        while (i < info.getArrayCount()) {
            InteractiveUIData elementUiData = null;
            if (!info.isStructType() && !info.isPointerType()) {
                elementUiData = InteractiveParser.parseScalar(info, checkLocation, Arrays.copyOfRange(data, index, index + byteSize));
            } else if (info.isPointerType()) {
                int pointerSize = info.getPointerSize();
                byte[] address = ByteUtil.toBytesN((byte[])data, (int)index, (int)pointerSize);
                elementUiData = new InteractiveUIData(info, checkLocation);
                if (pointerSize == 4) {
                    elementUiData.setValue("0x" + Integer.toHexString(ByteUtil.toInt((byte[])address)));
                } else if (pointerSize == 8) {
                    elementUiData.setValue("0x" + Long.toHexString(ByteUtil.toLong((byte[])address)));
                }
            } else if (info.isStructType()) {
                elementUiData = InteractiveParser.parseStruct(info, checkLocation, Arrays.copyOfRange(data, index, index + byteSize), valueMap);
            } else {
                Logger.warning((Object)"Unhandled case!!");
            }
            index += byteSize;
            if (elementUiData != null) {
                children.add(elementUiData);
                arrayValue = String.valueOf(arrayValue) + elementUiData.getValue() + " , ";
            }
            ++i;
        }
        arrayValue = String.valueOf(arrayValue) + " ]";
        uiData.setValue(arrayValue);
        uiData.setChildren(children);
        return uiData;
    }

    public static InteractiveInfo getInteractiveInfo(String binaryPath, String sourcePath, int lineNum, String varStr, int arrayCount, int checkLocation) {
        String[] parsedVar = InteractiveParser.parseVariableString(varStr);
        InteractiveInfo rootInteractiveInfo = InteractiveParser.parseDwarf(binaryPath, sourcePath, lineNum, parsedVar[0]);
        if (rootInteractiveInfo != null) {
            InteractiveInfo targetInteractiveInfo = InteractiveParser.findTargetInteractiveInfo(rootInteractiveInfo, parsedVar);
            targetInteractiveInfo.setVariableName(varStr);
            targetInteractiveInfo.setSourceFileName(sourcePath);
            targetInteractiveInfo.setSourceLineNum(lineNum);
            targetInteractiveInfo.setSourceLineAddress(1, rootInteractiveInfo.getSourceLineAddress(1));
            targetInteractiveInfo.setSourceLineAddress(2, rootInteractiveInfo.getSourceLineAddress(2));
            targetInteractiveInfo.setArrayCount(arrayCount);
            targetInteractiveInfo.setCheckLocation(checkLocation);
            return targetInteractiveInfo;
        }
        return rootInteractiveInfo;
    }

    private static String[] parseVariableString(String varStr) {
        String[] parsed = varStr.split("->|\\.");
        return parsed;
    }

    private static InteractiveInfo findTargetInteractiveInfo(InteractiveInfo rootInfo, String[] parsedVar) {
        int depth = parsedVar.length;
        InteractiveInfo cursorInfo = rootInfo;
        int i = 1;
        while (i < depth) {
            List<InteractiveInfo> children = cursorInfo.getChildren();
            int ii = 0;
            while (ii < children.size()) {
                if (children.get(ii).getVariableName().equals(parsedVar[i])) {
                    cursorInfo = children.get(ii);
                }
                ++ii;
            }
            ++i;
        }
        cursorInfo.setTarget(true);
        cursorInfo.setRegisterID(rootInfo.getRegisterID());
        cursorInfo.setRegisterOffset(rootInfo.getRegisterOffset());
        return cursorInfo;
    }

    private static InteractiveInfo parseDwarf(String binaryPath, String sourcePath, int lineNum, String varName) {
        Path _binaryPath = new Path(binaryPath);
        Path _sourcePath = new Path(sourcePath);
        ElfExecutableSymbolicsReaderFactory fact = new ElfExecutableSymbolicsReaderFactory();
        IExecutableSymbolicsReader exeReader = fact.createExecutableSymbolicsReader((IPath)_binaryPath);
        if (exeReader == null) {
            return null;
        }
        DwarfDebugInfoProvider dip = new DwarfDebugInfoProvider(exeReader);
        DwarfInfoReader dir = new DwarfInfoReader(dip);
        dir.parseInitial();
        dir.parseForAddresses(true);
        List cuList = dip.getModuleScope().getCompileUnitsForFile((IPath)_sourcePath);
        ILineEntry sourceLine = null;
        IFunctionScope funcScope = null;
        int i = 0;
        while (i < cuList.size()) {
            ICompileUnitScope cu = (ICompileUnitScope)cuList.get(i);
            if (cu instanceof DwarfCompileUnit) {
                ArrayList fileList = new ArrayList();
                Collection lines = dir.parseLineTable((IScope)cu, ((DwarfCompileUnit)cu).getAttributeList(), fileList);
                for (ILineEntry line : lines) {
                    if (line.getLineNumber() != lineNum || !line.getFilePath().equals((Object)_sourcePath)) continue;
                    sourceLine = line;
                    Collection cuChildren = cu.getChildren();
                    for (IScope cuChild : cuChildren) {
                        if (!(cuChild instanceof IFunctionScope) || line.getHighAddress().compareTo((Object)cuChild.getHighAddress()) > 0 || line.getLowAddress().compareTo((Object)cuChild.getLowAddress()) < 0) continue;
                        funcScope = (IFunctionScope)cuChild;
                        Collection funcChildren = cuChild.getChildren();
                        Iterator iterFunc = funcChildren.iterator();
                        while (iterFunc.hasNext()) {
                            InteractiveInfo varInfo = InteractiveParser.checkLexicalBlock((IScope)iterFunc.next(), varName, line, funcScope);
                            if (varInfo == null) continue;
                            return varInfo;
                        }
                        Collection params = ((IFunctionScope)cuChild).getParameters();
                        InteractiveInfo varInfo = InteractiveParser.getVariableInfo(params, varName, line, true, funcScope);
                        if (varInfo != null) {
                            return varInfo;
                        }
                        varInfo = InteractiveParser.getVariableInfo(cuChild.getVariables(), varName, line, true, funcScope);
                        if (varInfo == null) continue;
                        return varInfo;
                    }
                }
            }
            ++i;
        }
        if (sourceLine == null) {
            return null;
        }
        Collection variables = dip.getModuleScope().getVariablesByName(varName, true);
        return InteractiveParser.getVariableInfo(variables, varName, sourceLine, false, funcScope);
    }

    private static boolean setVariableLocationInfo(ILocationProvider locationProvider, InteractiveInfo variableInfo, boolean isLocal, IFunctionScope funcScope) {
        if (!(locationProvider instanceof LocationExpression)) {
            return false;
        }
        if (isLocal) {
            Object[] offset;
            int registerID = ((LocationExpression)funcScope.getFrameBaseLocation()).getRegisterID();
            variableInfo.setRegisterID(registerID);
            if (registerID > 0 && ((LocationExpression)locationProvider).getRegisterOffset(offset = new Object[1])) {
                variableInfo.setRegisterOffset((Long)offset[0]);
                return true;
            }
        } else {
            variableInfo.setRegisterID(GLOBAL_VARIABLE_ID);
            Object[] address = new Object[1];
            if (((LocationExpression)locationProvider).getGlobalVariableAddress(address)) {
                variableInfo.setRegisterOffset((Long)address[0]);
                return true;
            }
        }
        return false;
    }

    private static IType findTypeOfArray(IType type) {
        if (!(type instanceof IArrayType || type instanceof ITypedef || type instanceof IConstType)) {
            return type;
        }
        return InteractiveParser.findTypeOfArray(type.getType());
    }

    private static void getTypeInfo(IType type, IFunctionScope funcScope, InteractiveInfo valueInfo) {
        valueInfo.setByteSize(type.getByteSize());
        if (type instanceof IPointerType) {
            valueInfo.increasePointerOrder();
            valueInfo.setPointerSize(type.getByteSize());
            InteractiveParser.getTypeInfo(type.getType(), funcScope, valueInfo);
        } else if (type instanceof ITypedef || type instanceof IConstType) {
            InteractiveParser.getTypeInfo(type.getType(), funcScope, valueInfo);
        } else if (type instanceof IArrayType) {
            InteractiveParser.getTypeInfo(type.getType(), funcScope, valueInfo);
        } else if (type instanceof StructType) {
            valueInfo.setType(VAR_TYPE.STRUCT);
            valueInfo.setTypeName(type.getName());
            if (valueInfo.getParent() != null && valueInfo.getParent().getTypeName().equals(type.getName())) {
                return;
            }
            ArrayList<InteractiveInfo> members = new ArrayList<InteractiveInfo>();
            valueInfo.setChildren(members);
            IField[] fields = ((StructType)type).getFields();
            int i = 0;
            while (i < fields.length) {
                InteractiveInfo memberInfo = new InteractiveInfo();
                memberInfo.setVariableID(1, InteractiveIDGenerator.generateID());
                memberInfo.setVariableID(2, InteractiveIDGenerator.generateID());
                memberInfo.setVariableName(fields[i].getName());
                memberInfo.setOffset((int)fields[i].getFieldOffset());
                memberInfo.setFunctionName(funcScope.getName());
                memberInfo.setParent(valueInfo);
                int arrayCount = 0;
                if (fields[i].getType() instanceof IArrayType) {
                    IType arrayType = InteractiveParser.findTypeOfArray(fields[i].getType());
                    arrayCount = fields.length - 1 == i ? (type.getByteSize() - memberInfo.getOffset()) / arrayType.getByteSize() : ((int)fields[i + 1].getFieldOffset() - memberInfo.getOffset()) / arrayType.getByteSize();
                }
                memberInfo.setArrayCount(arrayCount);
                InteractiveParser.getTypeInfo(fields[i].getType(), funcScope, memberInfo);
                members.add(memberInfo);
                ++i;
            }
        } else if (VAR_TYPE.CHAR.getName().equals(type.getName())) {
            valueInfo.setType(VAR_TYPE.CHAR);
        } else if (VAR_TYPE.UNSIGNED_CHAR.getName().equals(type.getName())) {
            valueInfo.setType(VAR_TYPE.UNSIGNED_CHAR);
        } else if (VAR_TYPE.SIGNED_CHAR.getName().equals(type.getName())) {
            valueInfo.setType(VAR_TYPE.SIGNED_CHAR);
        } else if (VAR_TYPE.INT.getName().equals(type.getName())) {
            valueInfo.setType(VAR_TYPE.INT);
        } else if (VAR_TYPE.UNSIGNED_INT.getName().equals(type.getName())) {
            valueInfo.setType(VAR_TYPE.UNSIGNED_INT);
        } else if (VAR_TYPE.SHORT.getName().equals(type.getName())) {
            valueInfo.setType(VAR_TYPE.SHORT);
        } else if (VAR_TYPE.UNSIGNED_SHORT.getName().equals(type.getName())) {
            valueInfo.setType(VAR_TYPE.UNSIGNED_SHORT);
        } else if (VAR_TYPE.LONG.getName().equals(type.getName())) {
            valueInfo.setType(VAR_TYPE.LONG);
        } else if (VAR_TYPE.UNSIGNED_LONG.getName().equals(type.getName())) {
            valueInfo.setType(VAR_TYPE.UNSIGNED_LONG);
        } else if (VAR_TYPE.FLOAT.getName().equals(type.getName())) {
            valueInfo.setType(VAR_TYPE.FLOAT);
        } else if (VAR_TYPE.DOUBLE.getName().equals(type.getName())) {
            valueInfo.setType(VAR_TYPE.DOUBLE);
        } else if (VAR_TYPE.LONG_DOUBLE.getName().equals(type.getName())) {
            valueInfo.setType(VAR_TYPE.LONG_DOUBLE);
        } else {
            valueInfo.setType(VAR_TYPE.UNDEF);
        }
    }

    private static InteractiveInfo getVariableInfo(Collection<IVariable> variables, String varName, ILineEntry line, boolean isLocal, IFunctionScope funcScope) {
        for (IVariable var : variables) {
            if (!var.getName().equals(varName)) continue;
            InteractiveInfo variableInfo = new InteractiveInfo();
            variableInfo.setVariableID(1, InteractiveIDGenerator.generateID());
            variableInfo.setVariableID(2, InteractiveIDGenerator.generateID());
            variableInfo.setVariableName(var.getName());
            variableInfo.setSourceLineAddress(1, line.getLowAddress().getValue().longValue());
            variableInfo.setSourceLineAddress(2, line.getHighAddress().getValue().longValue());
            variableInfo.setFunctionName(funcScope.getName());
            InteractiveParser.getTypeInfo(var.getType(), funcScope, variableInfo);
            if (InteractiveParser.setVariableLocationInfo(var.getLocationProvider(), variableInfo, isLocal, funcScope)) {
                return variableInfo;
            }
            Logger.warning((Object)"Get Location error!!!");
        }
        return null;
    }

    private static InteractiveInfo checkLexicalBlock(IScope lexicalScope, String varName, ILineEntry line, IFunctionScope funcScope) {
        if (lexicalScope instanceof LexicalBlockScope && line.getLowAddress().compareTo((Object)lexicalScope.getHighAddress()) < 0 && line.getLowAddress().compareTo((Object)lexicalScope.getLowAddress()) >= 0) {
            Collection variables = ((ILexicalBlockScope)lexicalScope).getVariablesInTree();
            return InteractiveParser.getVariableInfo(variables, varName, line, true, funcScope);
        }
        return null;
    }
}

