/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.kernel;

import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.KernelPageLabels;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.common.PopupAnalysisMenuItemClickListener;
import org.tizen.dynamicanalyzer.ui.common.PopupClearMenuItemClickListener;
import org.tizen.dynamicanalyzer.ui.common.PopupEndMenuItemClickListener;
import org.tizen.dynamicanalyzer.ui.common.PopupFromSelectionMenuItemClickListener;
import org.tizen.dynamicanalyzer.ui.common.PopupStartMenuItemClickListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseEventListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseTrackAdapter;
import org.tizen.dynamicanalyzer.ui.kernel.CallFlowChartRenderer;
import org.tizen.dynamicanalyzer.ui.kernel.ContextSwitchingChartSeriesItem;
import org.tizen.dynamicanalyzer.ui.kernel.KernelPage;
import org.tizen.dynamicanalyzer.ui.kernel.data.FunctionDataDBTable;
import org.tizen.dynamicanalyzer.ui.kernel.data.KernelDataMaker;
import org.tizen.dynamicanalyzer.ui.kernel.data.KernelDataManager;
import org.tizen.dynamicanalyzer.ui.kernel.data.KernelDataPerThread;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardHeightChangeableItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItemList;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuListener;

public class CallFlowChart
extends DAChartBoard {
    private KernelDataPerThread selectedData = null;
    private boolean dirty = false;
    private final KernelDataMaker dataMaker = KernelDataManager.getInstance().getDataMaker();
    private HashMap<String, DAChartSeries> seriesMap = null;

    public CallFlowChart(Composite parent, String title) {
        super(parent, title);
    }

    public CallFlowChart(Composite parent, String title, int[] scaleValues) {
        super(parent, title, scaleValues);
    }

    public CallFlowChart(Composite parent, String title, int boardStyle) {
        super(parent, title, boardStyle);
    }

    protected void callBackScaleChanged() {
        this.updateChart();
        super.callBackScaleChanged();
    }

    protected void callBackScrollChanged() {
        this.updateChart();
        super.callBackScrollChanged();
    }

    protected void callBackSizeChanged() {
        this.layout(true, true);
        this.updateChart();
        super.callBackSizeChanged();
    }

    public void itemListClear() {
        DAChartBoardItemList itemList = this.getItemList();
        itemList.clear();
        itemList.setSize(0, 0);
        if (this.selectItem != null) {
            this.selectItem = null;
        }
    }

    public void setSelectedData(KernelDataPerThread data) {
        this.selectedData = data;
        this.dirty = true;
    }

    public void updateChart() {
        if (this.dirty) {
            this.itemListClear();
            if (this.seriesMap != null) {
                this.seriesMap.clear();
                this.seriesMap = null;
            }
        }
        if (this.selectedData == null) {
            this.redraw();
            this.update();
            return;
        }
        if (this.dirty) {
            List<List<Object>> funcnames = this.dataMaker.getFuncnameFromDB(this.selectedData.getTid());
            int fsize = funcnames.size();
            DAChartBoardHeightChangeableItem funcItem = new DAChartBoardHeightChangeableItem((DAChartBoard)this, String.valueOf(KernelPageLabels.CALL_FLOW_BOARD_NAME_TID) + " " + this.selectedData.getTid());
            this.initCallflowChart(funcItem, fsize);
            this.seriesMap = new HashMap(fsize * 2);
            DAChart funcChart = funcItem.getChart();
            int i = 0;
            while (i < fsize) {
                String funcname = (String)funcnames.get(i).get(0);
                DAChartSeries funcseries = new DAChartSeries(funcname, -1, ColorResources.RED, true);
                funcChart.addSeries(funcseries);
                funcseries.setData((Object)new Integer(i));
                this.seriesMap.put(funcname, funcseries);
                ++i;
            }
            this.dirty = false;
        }
        this.drawChart();
    }

    private void drawChart() {
        long endtime;
        if (this.selectedData == null) {
            return;
        }
        long starttime = (long)(this.getVisibleStartTime() * 1000000.0);
        List<List<Object>> functionData = this.dataMaker.getFunctionDataFromDB(starttime, endtime = (long)(this.getVisibleEndTime() * 1000000.0), this.selectedData.getTid());
        if (functionData == null || functionData.isEmpty()) {
            return;
        }
        int fsize = functionData.size();
        ContextSwitchingChartSeriesItem prevItem = null;
        int prevSeriesNum = -1;
        int i = 0;
        while (i < fsize) {
            List<Object> idata = functionData.get(i);
            int funcId = (Integer)idata.get(FunctionDataDBTable.COLUMN.FUNCID.index);
            String funcname = Global.getFunctionName(funcId);
            double funcStart = (double)((Long)idata.get(FunctionDataDBTable.COLUMN.STARTTIME.index)).longValue() / 1000000.0;
            double funcEnd = (double)((Long)idata.get(FunctionDataDBTable.COLUMN.ENDTIME.index)).longValue() / 1000000.0;
            DAChartSeries funcSeries = this.seriesMap.get(funcname);
            if (funcSeries != null) {
                int curSeriesNum = (Integer)funcSeries.getData();
                ContextSwitchingChartSeriesItem curItem = new ContextSwitchingChartSeriesItem(null, funcStart, funcEnd, ColorResources.RED);
                if (prevItem != null && prevSeriesNum != curSeriesNum) {
                    prevItem.setArrow(curSeriesNum - prevSeriesNum);
                }
                funcSeries.addSeriesItem((DAChartSeriesItem)curItem);
                prevItem = curItem;
                prevSeriesNum = curSeriesNum;
            } else {
                Logger.error((Object)"Function series is not exist in call flow chart");
            }
            ++i;
        }
        this.redraw();
        this.update();
    }

    private void initCallflowChart(DAChartBoardHeightChangeableItem chartItem, int itemsize) {
        DAChart chart = chartItem.getChart();
        if (chart == null) {
            return;
        }
        DAChartPlot plot = chart.getPlot();
        if (plot == null) {
            return;
        }
        chartItem.useExpand(false);
        chartItem.setHeightRatio((double)itemsize * 0.3);
        chart.getPlot().setAutoHeightRange(DAChartPlot.AutoRangeType.MANUAL);
        chart.getPlot().setShowAxis(false);
        chart.setChartRenderer((DAChartRenderer)new CallFlowChartRenderer());
        plot.setBackgroundImage(ImageResources.BG_GRADIENT);
        DAChartPlotTooltip tooltip = new DAChartPlotTooltip(-1.0);
        tooltip.setFont(FontResources.CHART_TOOLTIP_FONT);
        plot.setTooltip(tooltip);
        DAPopupMenu popupMenu = new DAPopupMenu((Composite)chart);
        popupMenu.setFont(FontResources.CONTEXT_MENU_ITEM_FONT);
        DAPopupMenuItem startItem = new DAPopupMenuItem(popupMenu, 0);
        startItem.setText(TimelineChartLabels.RANGE_CONTEXT_SET_START);
        startItem.addListener((DAPopupMenuListener)new PopupStartMenuItemClickListener(startItem, this));
        DAPopupMenuItem endItem = new DAPopupMenuItem(popupMenu, 0);
        endItem.setText(TimelineChartLabels.RANGE_CONTEXT_SET_END);
        endItem.addListener((DAPopupMenuListener)new PopupEndMenuItemClickListener(endItem, this));
        DAPopupMenuItem fromSelectionItem = new DAPopupMenuItem(popupMenu, 0);
        fromSelectionItem.setText(TimelineChartLabels.RANGE_CONTEXT_SET_FROM_SELECTION);
        fromSelectionItem.addListener((DAPopupMenuListener)new PopupFromSelectionMenuItemClickListener(fromSelectionItem, this));
        DAPopupMenuItem analysisItem = new DAPopupMenuItem(popupMenu, 0);
        analysisItem.setText(TimelineChartLabels.RANGE_CONTEXT_ANALYSIS);
        analysisItem.addListener((DAPopupMenuListener)new PopupAnalysisMenuItemClickListener());
        DAPopupMenuItem clearItem = new DAPopupMenuItem(popupMenu, 0);
        clearItem.setText(TimelineChartLabels.RANGE_CONTEXT_CLEAR);
        clearItem.addListener((DAPopupMenuListener)new PopupClearMenuItemClickListener());
        TimelineChartMouseEventListener timelineChartMouseEventListener = new TimelineChartMouseEventListener(popupMenu, this.getTimeline(), KernelPage.pageID);
        chart.addMouseListener((MouseListener)timelineChartMouseEventListener);
        chart.addMouseMoveListener((MouseMoveListener)timelineChartMouseEventListener);
        chart.addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(this.getTimeline()));
        plot.setMarkers(this.getMarkers());
    }
}

