/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.chart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.memory.chart.MemoryChart;
import org.tizen.dynamicanalyzer.ui.memory.data.MemAllocDBTable;
import org.tizen.dynamicanalyzer.ui.memory.data.ProcessMemoryDBTable;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class HeapMemoryChart
extends MemoryChart {
    private static final double PERSISTENT_SAMPLING_TIME = 0.5;
    private Map<Integer, Map<Integer, DAChartSeries>> seriesPerProcessMap = new HashMap<Integer, Map<Integer, DAChartSeries>>();
    private List<DAChartBoardItem> childBoardItemList = new ArrayList<DAChartBoardItem>();
    private DAChartBoardItem parentBoardItem;
    private int libId;
    private String libName;
    private double endTime = 0.0;
    private DAChartSeries totalSeries;
    private DAChartSeries appSeries;
    private DAChartSeries totalSeriesPersistent;
    private DAChartSeries appSeriesPersistent;

    public String getLibName() {
        return this.libName;
    }

    public void setLibName(String libName) {
        this.libName = libName;
    }

    public int getLibId() {
        return this.libId;
    }

    public void setLibId(int libId) {
        this.libId = libId;
    }

    public HeapMemoryChart(String pageID, String chartName, int libId, String libName, DAChartBoardItem chartBoardItem, DAChart chart) {
        super(pageID, chartName, chartBoardItem, chart);
        this.libId = libId;
        this.libName = libName;
        this.chartType = -104;
        this.chartIcon = ImageResources.FEATURE_HEAPALLOC_SMALL_NOR;
        this.addIcon = ImageResources.FEATURE_HEAPALLOC_SMALL_NOR;
        if (libId == -10) {
            this.totalSeries = new DAChartSeries(String.format(TimelineChartLabels.HEAP_CHART_SERIES_NAME_PROCESS, TimelineChartLabels.HEAP_CHART_SERIES_NAME_TOTAL_ALLOCATION), 3, ColorResources.CHART_SERIES_YELLOW);
            chart.addSeries(this.totalSeries);
            this.totalSeriesPersistent = new DAChartSeries(String.format(TimelineChartLabels.HEAP_CHART_SERIES_NAME_PROCESS, TimelineChartLabels.HEAP_CHART_SERIES_NAME_PERSISTENT), 3, ColorResources.CHART_SERIES_ORANGE);
        }
        String template = "%s";
        if (libName.equals(MemoryPageLabels.MEMORY_MAIN_EXCUTABLE)) {
            template = String.valueOf(libName) + " %s";
        }
        this.appSeries = new DAChartSeries(String.format(template, TimelineChartLabels.HEAP_CHART_SERIES_NAME_TOTAL_ALLOCATION), 3, ColorResources.CHART_SERIES_YELLOW, 0.5);
        chart.addSeries(this.appSeries);
        this.appSeriesPersistent = new DAChartSeries(String.format(template, TimelineChartLabels.HEAP_CHART_SERIES_NAME_PERSISTENT), 3, ColorResources.CHART_SERIES_ORANGE, 0.5);
    }

    @Override
    public void inputChartSeries(List<Object> dataList) {
        if (this.totalSeries != null) {
            this.totalSeries.clear();
        }
        this.appSeries.clear();
        this.endTime = 0.0;
        if (Global.getProject() == null) {
            return;
        }
        String processName = AnalyzerUtil.getProcessName(this.pid);
        if (processName == null) {
            return;
        }
        Map processDataMap = (Map)dataList.get(1);
        List processData = (List)processDataMap.get(this.pid);
        if (processData == null) {
            return;
        }
        this.appSeries.addSeriesItem(new DAChartSeriesItem(0.0, 0.0, Formatter.toByteFormat(0L)));
        if (this.totalSeries != null) {
            this.totalSeries.addSeriesItem(new DAChartSeriesItem(0.0, 0.0, Formatter.toByteFormat(0L)));
        }
        int i = 0;
        while (i < processData.size()) {
            List row = (List)processData.get(i);
            double time = (double)((Long)row.get(ProcessMemoryDBTable.COLUMN.SAMPLING_TIME.index)).longValue() / 1000000.0;
            long totalAlloc = 0L;
            List libIdList = (List)row.get(ProcessMemoryDBTable.COLUMN.HEAP_ALLOCATION_BINARY_ID.index);
            List libByteList = (List)row.get(ProcessMemoryDBTable.COLUMN.HEAP_ALLOCATION_BYTE.index);
            int index = libIdList.indexOf(this.libId);
            if (index != -1) {
                long targetAlloc = (Long)libByteList.get(index);
                this.appSeries.addSeriesItem(new DAChartSeriesItem(time, (double)targetAlloc, Formatter.toByteFormat(targetAlloc)));
            }
            for (Long libbyte : libByteList) {
                totalAlloc += libbyte.longValue();
            }
            if (this.totalSeries != null) {
                this.totalSeries.addSeriesItem(new DAChartSeriesItem(time, (double)totalAlloc, Formatter.toByteFormat(totalAlloc)));
            }
            this.endTime = this.endTime < time ? time : this.endTime;
            ++i;
        }
    }

    @Override
    public DAChartBoardItem createBoardItem(DAChartBoard board) {
        this.parentBoardItem = super.createBoardItem(board);
        this.chart.getPlot().setAxisUnit("B");
        this.chart.getPlot().setAxisUnitType(DAChartPlot.UnitType.BINARY);
        this.chart.getPlot().setShowAxis(true);
        this.clear();
        return this.parentBoardItem;
    }

    @Override
    public void clear() {
        this.seriesPerProcessMap.clear();
        int i = 0;
        while (i < this.childBoardItemList.size()) {
            this.childBoardItemList.get(i).dispose();
            ++i;
        }
    }

    public void updatePersistentSeries(List<List<Object>> data) {
        this.appSeriesPersistent.clear();
        if (this.totalSeriesPersistent != null) {
            this.totalSeriesPersistent.clear();
        }
        long appSize = 0L;
        long totalSize = 0L;
        double prevTime = -1.0;
        this.addPersistentSeries(0.0, appSize, totalSize);
        for (List<Object> row : data) {
            double time = (double)((Long)row.get(MemAllocDBTable.COLUMN.ALLOCATED_TIME.index)).longValue() / 1000000.0;
            long size = (Long)row.get(MemAllocDBTable.COLUMN.ALLOCATED_MEMORY_SIZE.index);
            int libId = (Integer)row.get(MemAllocDBTable.COLUMN.CALLER_LIBRARY_ID.index);
            int pid = (Integer)row.get(MemAllocDBTable.COLUMN.PID.index);
            String entryName = Global.getLibraryName(libId);
            if (entryName.equals(Global.getProject().getApplicationInfo().getExecPath())) {
                libId = -10;
            }
            if (time >= this.endTime) break;
            if (pid != this.pid || size < 0L) continue;
            totalSize += size;
            if (libId == this.libId) {
                appSize += size;
            }
            if (time - prevTime < 0.5) continue;
            prevTime = time;
            this.addPersistentSeries(time, appSize, totalSize);
        }
        this.addPersistentSeries(this.endTime, appSize, totalSize);
    }

    private void addPersistentSeries(double time, double appSize, double totalSize) {
        this.appSeriesPersistent.addSeriesItem(new DAChartSeriesItem(time, appSize, Formatter.toByteFormat(appSize)));
        if (this.totalSeries != null) {
            this.totalSeriesPersistent.addSeriesItem(new DAChartSeriesItem(time, totalSize, Formatter.toByteFormat(totalSize)));
        }
    }

    public void showPersistentSeries() {
        if (this.isVisiblePersistentSeries()) {
            return;
        }
        if (this.totalSeries != null) {
            this.chart.addSeries(this.totalSeriesPersistent);
        }
        this.chart.addSeries(this.appSeriesPersistent);
    }

    public void hidePersistentSeries() {
        List series = this.chart.getSeriesList();
        series.remove(this.appSeriesPersistent);
        if (this.totalSeries != null) {
            series.remove(this.totalSeriesPersistent);
        }
    }

    public boolean isVisiblePersistentSeries() {
        List series = this.chart.getSeriesList();
        if (series.contains(this.appSeriesPersistent)) {
            if (this.totalSeries == null) {
                return true;
            }
            return series.contains(this.totalSeries);
        }
        return false;
    }
}

