/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class SystemMemoryDBTable
extends DBTable {
    private static final String TABLENAME = "MEMORY_SYSTEM_DATA";

    public SystemMemoryDBTable() {
        this.addColumn(new DBColumn(COLUMN.SAMPLING_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.MEMORY_USAGE_SYSTEM.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.PROCESS_PID_OTHER.name, "", "INTEGER ARRAY"));
        this.addColumn(new DBColumn(COLUMN.PROCESS_LOAD_OTHER.name, "", "DOUBLE ARRAY"));
        this.setIndexColumn(COLUMN.SAMPLING_TIME.ordinal());
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                int index = 1;
                prep.setLong(index++, (Long)rowData.get(COLUMN.SAMPLING_TIME.index));
                prep.setLong(index++, (Long)rowData.get(COLUMN.MEMORY_USAGE_SYSTEM.index));
                this.setArrayToPreparedStatement(COLUMN.PROCESS_PID_OTHER.index, "INTEGER", prep, rowData);
                this.setArrayToPreparedStatement(COLUMN.PROCESS_LOAD_OTHER.index, "FLOAT", prep, rowData);
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(1));
            row.add(rs.getLong(2));
            row.add(this.getArrayFromResultSet(rs, 3, 0));
            row.add(this.getArrayFromResultSet(rs, 4, Float.valueOf(0.0f)));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        SAMPLING_TIME(0, "SAMPLING_TIME"),
        MEMORY_USAGE_SYSTEM(1, "MEMORY_USAGE_SYSTEM"),
        PROCESS_PID_OTHER(2, "PROCESS_PID_OTHER"),
        PROCESS_LOAD_OTHER(3, "PROCESS_LOAD_OTHER");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

