/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.ui.memory.MemoryPage;
import org.tizen.dynamicanalyzer.ui.memory.data.HeapDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.ui.widgets.table.TableColumnSizePackListener;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.timeline.MarkerManager;

public class MemoryPersistentAllocationsTable
extends DATableComposite {
    private int COLUMN_SIZE__SEQ = 60;
    private int COLUMN_SIZE__TIMESTAMP = 105;
    private int COLUMN_SIZE__PID = 40;
    private int COLUMN_SIZE__TID = 40;
    private int COLUMN_SIZE__ALLOCATED_ADDRESS = 90;
    private int COLUMN_SIZE__SIZE = 45;
    private int COLUMN_SIZE__LIBRARY = 205;
    private int COLUMN_SIZE__CALLED = 115;
    private Long StartTime = 0L;
    private Long EndTime = 0L;

    public MemoryPersistentAllocationsTable(Composite parent, int style, int tableStyle) {
        super(parent, style, tableStyle);
        this.setTableName(MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_TITLE);
        this.setComparator(new DefaultTableComparator());
        int[] nArray = new int[10];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[9] = 2;
        this.setSortTypes(nArray);
        this.setColumnAlignment(new int[]{131072, 0x1000000, 131072, 131072, 131072, 131072, 16384, 0x1000000, 16384, 0x1000000});
        this.setColumns(new String[]{MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_SEQ, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_TIMESTAMP, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_PID, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_TID, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_ALLOCATED_ADDRESS, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_SIZE, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_LIBRARY, MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_CALLED_FUNCTION, "", "Streaming is not supported. Please select range or stop Tracing"});
        int[] columnSizes = new int[]{this.COLUMN_SIZE__SEQ, this.COLUMN_SIZE__TIMESTAMP, this.COLUMN_SIZE__PID, this.COLUMN_SIZE__TID, this.COLUMN_SIZE__ALLOCATED_ADDRESS, this.COLUMN_SIZE__SIZE, this.COLUMN_SIZE__LIBRARY, this.COLUMN_SIZE__CALLED, 15, 800};
        this.setColumnSize(columnSizes);
        this.setTableToolTipEnable(false);
        parent.addControlListener((ControlListener)new TableColumnSizePackListener(this, columnSizes));
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = ((Grid)e.widget).getSelection();
                if (items == null || items.length == 0) {
                    return;
                }
                int size = items.length;
                List<Object> startData = ((DATableDataFormat)items[0].getData()).getData();
                List<Object> endData = ((DATableDataFormat)items[size - 1].getData()).getData();
                long startTime = (Long)startData.get(MemoryPersistentAllocationsTableIndex.TIMESTAMP.getIndex());
                long endTime = (Long)endData.get(MemoryPersistentAllocationsTableIndex.TIMESTAMP.getIndex());
                Toolbar.INSTANCE.setChartDragStartTime(startTime);
                Toolbar.INSTANCE.setChartDragEndTime(endTime);
                Toolbar.INSTANCE.setDlogSelection(false);
                DASelectionData data = new DASelectionData(MemoryPage.allocationtraceViewID, startTime, endTime, items, (Control)MemoryPersistentAllocationsTable.this.table);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)data);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                GridItem[] ti = ((Grid)e.widget).getSelection();
                if (ti == null || ti.length == 0) {
                    return;
                }
                List<Object> markerData = ((DATableDataFormat)ti[0].getData()).getData();
                long markerTime = (Long)markerData.get(1);
                MarkerManager.INSTANCE.addMarker(markerTime);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.initFilterPopupMenu();
    }

    public void setSelectionRange(Long start, Long end) {
        this.StartTime = start;
        this.EndTime = end;
    }

    @Override
    protected List<TableInput> makeTableInput() {
        List<TableInput> wholedata;
        List<TableInput> output = new ArrayList<TableInput>();
        if (Global.getProject() == null) {
            return output;
        }
        if (this.isFilter) {
            output = this.filteredTable;
            return output;
        }
        if (!DAState.isRunning() && this.StartTime == 0L && this.EndTime == 0L && Toolbar.INSTANCE.getSelectedPid() <= 0 && (wholedata = HeapDataManager.getInstance().getWholeAllocationTraceTreeInput()).size() != 0) {
            this.tableClone = wholedata;
            return wholedata;
        }
        List<List<Object>> allocDataList = null;
        String pidliststring = this.getTargetPIDString();
        allocDataList = HeapDataManager.getInstance().remainedAllocatedListForRange(this.StartTime, this.EndTime, pidliststring);
        if (allocDataList == null || allocDataList.size() == 0) {
            return output;
        }
        int index = 0;
        int size = allocDataList.size();
        int j = 0;
        while (j < size) {
            List<Object> iAllocData = allocDataList.get(j);
            TableInput alloInput = HeapDataManager.getInstance().makeTreeInputForLeakData(iAllocData, index++);
            if (alloInput != null) {
                ((DATableDataFormat)alloInput.getData()).setType(4099);
                output.add(alloInput);
            }
            ++j;
        }
        this.tableClone = output;
        return output;
    }

    public void removeSelection() {
        this.table.removeAll();
        this.updateTable();
    }

    private String getTargetPIDString() {
        ArrayList<Integer> pidlist = new ArrayList<Integer>();
        int[] pids = Global.getProject().getProcessIDs();
        int targetPID = Toolbar.INSTANCE.getSelectedPid();
        if (targetPID > 0) {
            pidlist.add(targetPID);
        } else {
            int i = 0;
            while (i < pids.length) {
                pidlist.add(pids[i]);
                ++i;
            }
        }
        String pidliststring = "(";
        int i = 0;
        while (i < pidlist.size()) {
            pidliststring = String.valueOf(pidliststring) + Integer.toString((Integer)pidlist.get(i));
            if (i != pidlist.size() - 1) {
                pidliststring = String.valueOf(pidliststring) + ", ";
            }
            ++i;
        }
        pidliststring = String.valueOf(pidliststring) + ")";
        return pidliststring;
    }

    @Override
    public void clear() {
        this.table.removeAll();
        this.getSelectionIndex().clear();
        this.getSelections().clear();
        this.StartTime = 0L;
        this.EndTime = 0L;
    }

    public static enum MemoryPersistentAllocationsTableIndex {
        SEQ(0),
        TIMESTAMP(1),
        PID(2),
        TID(3),
        ALLOCATED_ADDRESS(4),
        SIZE(5),
        LIBRARY(6),
        CALLED(7),
        EMPTY(8),
        RUNTIME_STUB(9);

        private int index;

        private MemoryPersistentAllocationsTableIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

