/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread;

import java.util.Map;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.page.PageInfoRegistry;
import org.tizen.dynamicanalyzer.ui.thread.ThreadAPIListView;
import org.tizen.dynamicanalyzer.ui.thread.ThreadDetailInfoView;
import org.tizen.dynamicanalyzer.ui.thread.chart.ThreadChartView;
import org.tizen.dynamicanalyzer.ui.thread.data.ThreadDataManager;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAPageComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DATabComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;

public class ThreadPage
extends DAPageComposite {
    public static final String pageID = ThreadPage.class.getName();
    public static final String chartViewID = ThreadChartView.class.getName();
    public static final String listViewID = ThreadAPIListView.class.getName();
    public static final String detailViewID = ThreadDetailInfoView.class.getName();
    private DATabComposite threadApiTableView = null;
    private DATabComposite threadDetailTableView = null;
    SashForm baseForm;
    SashForm topForm;
    SashForm bottomForm;
    boolean isDetailMode = true;
    int tableHeight = -1;
    int tableWeight = 65;
    boolean wasSashCreated = false;

    public ThreadPage(Composite parent, int style) {
        super(parent, style);
        this.setTitle(AnalyzerLabels.COOLBAR_AREA_THREAD);
        this.setData("tooltip", ShortCutManager.COOLBAR_AREA_THREAD_TOOLTIP);
        this.setBackground(ColorResources.WHITE);
        this.setLayout((Layout)new FillLayout());
        this.baseForm = new SashForm((Composite)this, 512);
        this.baseForm.setLayout((Layout)new FillLayout());
        this.baseForm.setForeground(ColorResources.WHITE);
        this.baseForm.setBackground(ColorResources.WHITE);
        this.topForm = new SashForm((Composite)this.baseForm, 512);
        ThreadChartView threadChartView = new ThreadChartView((Composite)this.topForm, 0);
        this.addView((DABaseComposite)threadChartView);
        this.bottomForm = new SashForm((Composite)this.baseForm, 256);
        SashForm bottomLeftForm = new SashForm((Composite)this.bottomForm, 0);
        bottomLeftForm.setForeground(ColorResources.TAB_SELECTED_COLOR_START);
        bottomLeftForm.setLayout((Layout)new FillLayout());
        SashForm bottomRightForm = new SashForm((Composite)this.bottomForm, 0);
        bottomRightForm.setForeground(ColorResources.TAB_SELECTED_COLOR_START);
        bottomRightForm.setLayout((Layout)new FillLayout());
        this.threadApiTableView = new DATabComposite((Composite)bottomLeftForm, 0, false, true);
        ThreadAPIListView threadAPIListView = new ThreadAPIListView(this.threadApiTableView.getContentComposite(), 0);
        this.threadApiTableView.addView((DABaseComposite)threadAPIListView);
        this.addView((DABaseComposite)threadAPIListView);
        this.addView((DABaseComposite)this.threadApiTableView);
        this.threadDetailTableView = new DATabComposite((Composite)bottomRightForm, 0, false, true);
        ThreadDetailInfoView threadDetailInfoView = new ThreadDetailInfoView(this.threadDetailTableView.getContentComposite(), 0);
        this.threadDetailTableView.addView((DABaseComposite)threadDetailInfoView);
        this.addView((DABaseComposite)threadDetailInfoView);
        this.addView((DABaseComposite)this.threadDetailTableView);
        this.topForm.setSashWidth(2);
        this.bottomForm.setSashWidth(2);
        bottomLeftForm.setSashWidth(2);
        bottomRightForm.setSashWidth(2);
        this.bottomForm.setWeights(new int[]{this.tableWeight, 100 - this.tableWeight});
        this.addTableWeightListener();
    }

    private void addHeightWeightListener() {
        if (this.baseForm.getChildren().length > 2) {
            ((Sash)this.baseForm.getChildren()[2]).addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    ThreadPage.this.tableHeight = (int)((double)ThreadPage.this.baseForm.getWeights()[0] / (double)ThreadPage.this.baseForm.getWeights()[0] + (double)ThreadPage.this.baseForm.getWeights()[1]) * ThreadPage.this.baseForm.getSize().y * 1 / 1000;
                }
            });
            this.wasSashCreated = true;
        }
    }

    private void addTableWeightListener() {
        ((SashForm)this.bottomForm.getChildren()[0]).addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ThreadPage.this.resizeTableButton();
            }
        });
    }

    public Composite getTopTable() {
        DAViewComposite view = (DAViewComposite)this.threadApiTableView.getTopComposite();
        Composite comp = (Composite)view.getControl();
        Logger.debug((Object)comp.toString());
        return comp;
    }

    public SashForm getBaseForm() {
        return this.baseForm;
    }

    public void setDetailMode(boolean mode) {
        this.isDetailMode = mode;
    }

    protected void onResized(int width, int height) {
        if (!this.wasSashCreated) {
            this.addHeightWeightListener();
        }
        this.resizePageButton();
        this.resizeTableButton();
        if (!this.isDetailMode) {
            int[] nArray = new int[2];
            nArray[0] = 100;
            this.baseForm.setWeights(nArray);
        } else {
            int hrate;
            int n = hrate = this.tableHeight == -1 ? (int)(23500.0 / (double)height) : this.tableHeight * 100 / height;
            if (hrate > 100) {
                return;
            }
            this.baseForm.setWeights(new int[]{100 - hrate, hrate});
        }
    }

    private void resizePageButton() {
        int width = WorkbenchUtil.getWorkbenchWindow().getShell().getBounds().width;
        int pageCount = PageInfoRegistry.getPageNamesByTarget(SettingDataManager.INSTANCE.getConnectedTargetOrSelected().getTargetName()).size();
        int newWidth = width / pageCount > 190 ? 190 : width / pageCount;
        ((BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID)).getMainTab().updateTabButtonsWidth(newWidth);
    }

    private void resizeTableButton() {
        int tabCount;
        double weight = (double)this.bottomForm.getWeights()[0] / 1000.0;
        int width = (int)((double)WorkbenchUtil.getWorkbenchWindow().getShell().getBounds().width * weight);
        int newWidth = width / (tabCount = this.threadApiTableView.getTabButtons().size()) > 190 ? 190 : width / tabCount;
        this.threadApiTableView.updateTabButtonsWidth(newWidth);
    }

    public void clear() {
        super.clear();
        ThreadDataManager.getInstance().clear();
    }

    public void updateView() {
        for (Map.Entry entry : this.childMap.entrySet()) {
            ((DABaseComposite)entry.getValue()).updateView();
        }
        if (!this.isDetailMode) {
            if (this.baseForm.getChildren().length > 2) {
                ((Sash)this.baseForm.getChildren()[2]).setVisible(false);
            }
        } else if (this.baseForm.getChildren().length > 2) {
            ((Sash)this.baseForm.getChildren()[2]).setVisible(true);
        }
    }
}

