/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.calltrace;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.FunctionEntryDBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class FunctionExitDBTable
extends DBTable {
    private static final String TABLENAME = "FUNCTION_EXIT";
    public static final int FUNCTION_RETURN_VALUE_LENGTH = 1024;
    private static final String SELECT_COLUMN = String.valueOf(COLUMN.EXIT_SEQUENCE_NUMBER.name) + "," + FunctionEntryDBTable.COLUMN.PID.name + "," + FunctionEntryDBTable.COLUMN.TID.name + "," + FunctionEntryDBTable.COLUMN.FUNCTION_ID.name + "," + FunctionEntryDBTable.COLUMN.BINARY_ID.name + "," + COLUMN.END_TIME.name + "," + FunctionEntryDBTable.COLUMN.CALLER_PC_ADDRESS.name + "," + FunctionEntryDBTable.COLUMN.START_PC_ADDRESS.name;
    public static final String SELECT_QUERY = "select " + SELECT_COLUMN + " from " + "FUNCTION_EXIT" + "," + "FUNCTION_ENTRY" + " where " + COLUMN.ENTRY_SEQUENCE_NUMBER.name + "=" + FunctionEntryDBTable.COLUMN.SEQUENCE_NUMBER.name + " and " + COLUMN.END_TIME.name + " between %s and %s";
    public static final String USERCALLSTACK_QUERY = "select " + COLUMN.EXIT_SEQUENCE_NUMBER.name + " from " + "FUNCTION_EXIT" + " where " + COLUMN.END_TIME.name + " = (select max( " + COLUMN.END_TIME.name + ") from " + "FUNCTION_EXIT" + " where " + COLUMN.END_TIME.name + " <= %s )";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public FunctionExitDBTable() {
        this.addColumn(new DBColumn(COLUMN.ENTRY_SEQUENCE_NUMBER.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.EXIT_SEQUENCE_NUMBER.name, "PRIMARY KEY", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.END_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.RETURN_VALUE.name, "", "VARCHAR", 1024));
        this.setIndexColumn(COLUMN.END_TIME.index);
    }

    public List<List<Object>> getFunctionExitFromDB() {
        return this.selectAllColumnData(null);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(COLUMN.ENTRY_SEQUENCE_NUMBER.index + 1, (Long)rowData.get(COLUMN.ENTRY_SEQUENCE_NUMBER.index));
                prep.setLong(COLUMN.EXIT_SEQUENCE_NUMBER.index + 1, (Long)rowData.get(COLUMN.EXIT_SEQUENCE_NUMBER.index));
                prep.setLong(COLUMN.END_TIME.index + 1, (Long)rowData.get(COLUMN.END_TIME.index));
                String retStr = this.clipString((String)rowData.get(COLUMN.RETURN_VALUE.index), 1024, rowData.get(COLUMN.EXIT_SEQUENCE_NUMBER.index).toString());
                prep.setString(COLUMN.RETURN_VALUE.index + 1, retStr);
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(1));
            row.add(rs.getLong(2));
            row.add(rs.getLong(3));
            row.add(rs.getString(4));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        ENTRY_SEQUENCE_NUMBER(0, "ENTRY_SEQUENCE_NUMBER"),
        EXIT_SEQUENCE_NUMBER(1, "EXIT_SEQUENCE_NUMBER"),
        END_TIME(2, "END_TIME"),
        RETURN_VALUE(3, "RETURN_VALUE");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

