/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.replayEditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridEditor;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.nl.ReplayEditLabels;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.toolbar.replayEditor.ReplayEditPopupMenu;
import org.tizen.dynamicanalyzer.ui.toolbar.replayEditor.ReplayEditScreenshotDialog;
import org.tizen.dynamicanalyzer.ui.toolbar.replayEditor.ReplayEditTableCellRenderer;
import org.tizen.dynamicanalyzer.ui.toolbar.replayEditor.data.ReplayEditTableData;
import org.tizen.dynamicanalyzer.ui.toolbar.replayEditor.data.ReplayEditTableDataMaker;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableHeaderRenderer;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.da.base.DATextBox;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuListener;

public class ReplayEditTable
extends DATableComposite {
    private String[] columnNames = null;
    protected DAPopupMenu eventTypePopupMenu = null;
    protected DAPopupMenu eventKeyPopupMenu = null;
    private boolean isMouseSelectedTableItem = false;
    private int mouseSelectedItemIndex = -1;
    private int mouseSelectedColumnIndex = -1;
    private int mouseSelectedPreColunmEndX = -1;
    private String savedItemTextForReset = "";
    private List<String> selectedPreKeyContext = new ArrayList<String>();
    private List<String> selectedPreTouchContext = new ArrayList<String>();
    private List<String> copyItemText = new ArrayList<String>();
    private int selectedCutItemIndex = -1;
    private int selectedCopyItemIndex = -1;
    private int nowMousePositionX = 0;
    private int nowMousePositionY = 0;
    DAPopupMenuItem copyItem = null;
    DAPopupMenuItem cutItem = null;
    DAPopupMenuItem insertItem = null;
    DAPopupMenuItem pasteItem = null;
    DAPopupMenuItem deleteItem = null;
    private DATextBox inputValueText = null;
    private boolean enableCoordinateIcon = true;
    private Listener tableMouseListener = new Listener(){

        public void handleEvent(Event event) {
            GridItem item = ReplayEditTable.this.table.getItem(new Point(event.x, event.y));
            if (item == null) {
                return;
            }
            block0 : switch (event.type) {
                case 12: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 5: {
                    ReplayEditTable.this.upadteMouseOverTableItemsStatus(item, event);
                    ReplayEditTable.this.updateMouseOverTableItemsText();
                    if (ReplayEditTable.this.inputValueText == null) break;
                    ReplayEditTable.this.inputValueText.getControl().dispose();
                    ReplayEditTable.this.inputValueText = null;
                    break;
                }
                case 8: {
                    break;
                }
                case 32: {
                    break;
                }
                case 4: {
                    break;
                }
                case 3: {
                    ReplayEditTable.this.updateSelectedItemIndexValue(item, event);
                    switch (event.button) {
                        case 1: {
                            if (!ReplayEditTable.this.selectPopupMenuMouseDownIcon(item, event)) break block0;
                            ReplayEditTable.this.updateKeyboardInputStatus(item, event);
                            break block0;
                        }
                        case 3: {
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
    };

    @Override
    protected List<TableInput> makeTableInput() {
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        List<ReplayEditTableData> replayEditorDataList = ReplayEditTableDataMaker.getInstance().getReplayEditTableData();
        if (replayEditorDataList == null) {
            return input;
        }
        int i = 0;
        while (i < replayEditorDataList.size()) {
            ArrayList<String> text = new ArrayList<String>();
            ReplayEditTableData replayTableType = replayEditorDataList.get(i);
            text.add(Integer.toString(i));
            text.add(replayTableType.getStrEventMouseDownTime());
            text.add(replayTableType.getStrEventMouseUpTime());
            text.add(replayTableType.getStrEventType());
            text.add(replayTableType.getStrEventValue1());
            text.add(replayTableType.getStrEventValue2());
            text.add(replayTableType.getModifiabilityEvent());
            TableInput tableInput = new TableInput();
            tableInput.setText(text);
            input.add(tableInput);
            ++i;
        }
        return input;
    }

    @Override
    public void updateTable() {
        this.table.removeAll();
        List<TableInput> input = this.makeTableInput();
        if (input == null) {
            return;
        }
        int size = input.size();
        int i = 0;
        while (i < size) {
            List<String> text = input.get(i).getText();
            GridItem gridItem = new GridItem(this.table, 0);
            int j = 0;
            while (j < text.size()) {
                gridItem.setText(j, text.get(j));
                ++j;
            }
            ++i;
        }
        this.table.update();
        this.tableRedraw();
    }

    public ReplayEditTable(Composite parent, int style) {
        super(parent, style);
        this.setMenuItemOfSeqColumn();
        this.setMenuItemOfEventType();
        this.setMenuItemOfKey();
        this.table.addListener(12, this.tableMouseListener);
        this.table.addListener(6, this.tableMouseListener);
        this.table.addListener(7, this.tableMouseListener);
        this.table.addListener(5, this.tableMouseListener);
        this.table.addListener(32, this.tableMouseListener);
        this.table.addListener(4, this.tableMouseListener);
        this.table.addListener(3, this.tableMouseListener);
        this.table.addListener(8, this.tableMouseListener);
        this.table.getShell().getDisplay().addFilter(2, new Listener(){

            public void handleEvent(Event event) {
                ReplayEditTable.this.setItemKeyText(event);
            }
        });
    }

    private List<String> getSelectedItemText(int index) {
        ArrayList<String> text = new ArrayList<String>();
        int size = this.table.getColumns().length;
        int j = 0;
        while (j < size + 1) {
            text.add(this.table.getItem(index).getText(j));
            ++j;
        }
        return text;
    }

    private void pasteTableItems(int index, List<String> itemText) {
        ArrayList<List<String>> gridItemTextList = new ArrayList<List<String>>();
        int i = 0;
        while (i < this.table.getItemCount()) {
            ArrayList<String> text = new ArrayList<String>();
            if (i == index) {
                gridItemTextList.add(itemText);
            } else {
                int size = this.table.getColumns().length;
                int j = 0;
                while (j < size + 1) {
                    text.add(this.table.getItem(i).getText(j));
                    ++j;
                }
                gridItemTextList.add(text);
            }
            ++i;
        }
        this.table.removeAll();
        int size = gridItemTextList.size();
        int i2 = 0;
        while (i2 < size) {
            List text = (List)gridItemTextList.get(i2);
            GridItem gridItem = new GridItem(this.table, 0);
            int j = 0;
            while (j < text.size()) {
                gridItem.setText(j, (String)text.get(j));
                ++j;
            }
            ++i2;
        }
        this.table.update();
        this.tableRedraw();
    }

    private void insertTableItems(int index, List<String> itemText) {
        ArrayList<List<Object>> gridItemTextList = new ArrayList<List<Object>>();
        int i = 0;
        while (i < this.table.getItemCount()) {
            ArrayList<String> text = new ArrayList<String>();
            int size = this.table.getColumns().length;
            int j = 0;
            while (j < size + 1) {
                text.add(this.table.getItem(i).getText(j));
                ++j;
            }
            gridItemTextList.add(text);
            if (i == index) {
                gridItemTextList.add(itemText);
            }
            ++i;
        }
        this.table.removeAll();
        int size = gridItemTextList.size();
        int i2 = 0;
        while (i2 < size) {
            List text = (List)gridItemTextList.get(i2);
            GridItem gridItem = new GridItem(this.table, 0);
            int j = 0;
            while (j < text.size()) {
                gridItem.setText(j, (String)text.get(j));
                ++j;
            }
            ++i2;
        }
        this.table.update();
        this.tableRedraw();
    }

    private void updateTableSequenceNumber() {
        int size = this.table.getItemCount();
        int i = 0;
        while (i < size) {
            this.table.getItem(i).setText(0, Integer.toString(i));
            ++i;
        }
        this.tableRedraw();
    }

    private String getMouseSelectedItemOptionText() {
        return this.table.getItem(this.getMouseSelectedTableItemIndex()).getText(6);
    }

    private void setMouseSelectedItemOptionText(String text) {
        this.table.getItem(this.getMouseSelectedTableItemIndex()).setText(6, text);
    }

    private void addMouseSelectedItemOptionText(String text) {
        String optionText = this.table.getItem(this.getMouseSelectedTableItemIndex()).getText(6);
        if (!optionText.contains(text)) {
            optionText = String.valueOf(optionText) + text;
            this.table.getItem(this.getMouseSelectedTableItemIndex()).setText(6, optionText);
        }
    }

    private void removeMouseSelectedItemOptionText(String text) {
        String optionText = this.table.getItem(this.getMouseSelectedTableItemIndex()).getText(6);
        if (optionText.contains(text)) {
            optionText = optionText.replace(text, "");
            this.table.getItem(this.getMouseSelectedTableItemIndex()).setText(6, optionText);
        }
    }

    private int getMouseSelectedTableItemIndex() {
        return this.mouseSelectedItemIndex;
    }

    private int getMouseSelectedTableColumnIndex() {
        return this.mouseSelectedColumnIndex;
    }

    private String getMouseSelectedTableItemText() {
        return this.table.getItem(this.getMouseSelectedTableItemIndex()).getText(this.getMouseSelectedTableColumnIndex());
    }

    private void setMouseSelectedTableItemText(String text) {
        this.table.getItem(this.getMouseSelectedTableItemIndex()).setText(this.getMouseSelectedTableColumnIndex(), text);
    }

    private void setMenuItemOfSeqColumn() {
        this.popupMenu = new ReplayEditPopupMenu((Composite)this.table);
        this.popupMenu.setMouseListener();
        this.popupMenu.setFont(FontResources.CONTEXT_MENU_ITEM_FONT);
        this.cutItem = new DAPopupMenuItem(this.popupMenu);
        this.cutItem.setText(ReplayEditLabels.CONTEXT_CUT);
        this.cutItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                ReplayEditTable.this.copyItemText = ReplayEditTable.this.getSelectedItemText(ReplayEditTable.this.getMouseSelectedTableItemIndex());
                if (((String)ReplayEditTable.this.copyItemText.get(6)).contains("SELECTED_ITEM_COPY ")) {
                    ReplayEditTable.this.copyItemText.set(6, ReplayEditTable.this.getReplaceString((String)ReplayEditTable.this.copyItemText.get(6), "SELECTED_ITEM_COPY ", ""));
                }
                if (ReplayEditTable.this.selectedCopyItemIndex >= 0) {
                    ReplayEditTable.this.disableCopyItem(ReplayEditTable.this.selectedCopyItemIndex);
                    ReplayEditTable.this.selectedCopyItemIndex = -1;
                } else {
                    ReplayEditTable.this.disableCopyItem(ReplayEditTable.this.selectedCutItemIndex);
                }
                ReplayEditTable.this.selectedCutItemIndex = ReplayEditTable.this.getMouseSelectedTableItemIndex();
                ReplayEditTable.this.enableCopyItem();
            }
        });
        this.copyItem = new DAPopupMenuItem(this.popupMenu);
        this.copyItem.setText(ReplayEditLabels.CONTEXT_COPY);
        this.copyItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                ReplayEditTable.this.copyItemText = ReplayEditTable.this.getSelectedItemText(ReplayEditTable.this.getMouseSelectedTableItemIndex());
                if (((String)ReplayEditTable.this.copyItemText.get(6)).contains("SELECTED_ITEM_COPY ")) {
                    ReplayEditTable.this.copyItemText.set(6, ReplayEditTable.this.getReplaceString((String)ReplayEditTable.this.copyItemText.get(6), "SELECTED_ITEM_COPY ", ""));
                }
                if (ReplayEditTable.this.selectedCutItemIndex >= 0) {
                    ReplayEditTable.this.disableCopyItem(ReplayEditTable.this.selectedCutItemIndex);
                    ReplayEditTable.this.selectedCutItemIndex = -1;
                } else {
                    ReplayEditTable.this.disableCopyItem(ReplayEditTable.this.selectedCopyItemIndex);
                }
                ReplayEditTable.this.selectedCopyItemIndex = ReplayEditTable.this.getMouseSelectedTableItemIndex();
                ReplayEditTable.this.enableCopyItem();
            }
        });
        this.pasteItem = new DAPopupMenuItem(this.popupMenu);
        this.pasteItem.setText(ReplayEditLabels.CONTEXT_PASTE);
        this.pasteItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                if (ReplayEditTable.this.selectedCopyItemIndex >= 0) {
                    ReplayEditTable.this.pasteTableItems(ReplayEditTable.this.getMouseSelectedTableItemIndex(), ReplayEditTable.this.copyItemText);
                    ReplayEditTable.this.updateTableSequenceNumber();
                    ReplayEditTable.this.disableCopyItem(ReplayEditTable.this.getMouseSelectedTableItemIndex());
                } else if (ReplayEditTable.this.selectedCutItemIndex >= 0) {
                    ReplayEditTable.this.pasteTableItems(ReplayEditTable.this.getMouseSelectedTableItemIndex(), ReplayEditTable.this.copyItemText);
                    ReplayEditTable.this.table.remove(ReplayEditTable.this.selectedCutItemIndex);
                    ReplayEditTable.this.updateTableSequenceNumber();
                    ReplayEditTable.this.selectedCutItemIndex = -1;
                }
                ReplayEditTable.this.updateVaildState();
                ReplayEditTable.this.tableRedraw();
            }
        });
        this.insertItem = new DAPopupMenuItem(this.popupMenu);
        this.insertItem.setText(ReplayEditLabels.CONTEXT_INSERT);
        this.insertItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                if (ReplayEditTable.this.getCopyItemIndex() > -1) {
                    if (ReplayEditTable.this.selectedCopyItemIndex >= 0) {
                        ReplayEditTable.this.insertTableItems(ReplayEditTable.this.getMouseSelectedTableItemIndex(), ReplayEditTable.this.copyItemText);
                    } else if (ReplayEditTable.this.selectedCutItemIndex >= 0) {
                        ReplayEditTable.this.disableCopyItem(ReplayEditTable.this.selectedCutItemIndex + 1);
                        ReplayEditTable.this.insertTableItems(ReplayEditTable.this.getMouseSelectedTableItemIndex(), ReplayEditTable.this.copyItemText);
                        ReplayEditTable.this.table.remove(ReplayEditTable.this.selectedCutItemIndex - 1);
                        ReplayEditTable.this.updateTableSequenceNumber();
                        ReplayEditTable.this.selectedCutItemIndex = -1;
                    }
                } else {
                    ReplayEditTable.this.insertTableItems(ReplayEditTable.this.getMouseSelectedTableItemIndex(), ReplayEditTable.this.getSelectedItemText(ReplayEditTable.this.getMouseSelectedTableItemIndex()));
                }
                ReplayEditTable.this.updateTableSequenceNumber();
                ReplayEditTable.this.updateVaildState();
                ReplayEditTable.this.tableRedraw();
            }
        });
        this.deleteItem = new DAPopupMenuItem(this.popupMenu);
        this.deleteItem.setText(ReplayEditLabels.CONTEXT_DELETE);
        this.deleteItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                ReplayEditTable.this.table.remove(ReplayEditTable.this.getMouseSelectedTableItemIndex());
                ReplayEditTable.this.updateTableSequenceNumber();
                ReplayEditTable.this.updateVaildState();
                ReplayEditTable.this.tableRedraw();
            }
        });
    }

    private void enableCopyItem() {
        String itemOption = this.getMouseSelectedItemOptionText();
        if (!itemOption.contains("SELECTED_ITEM_COPY ")) {
            this.setMouseSelectedItemOptionText(String.valueOf(itemOption) + "SELECTED_ITEM_COPY ");
        }
    }

    private void disableCopyItem(int index) {
        if (index < 0) {
            return;
        }
        String itemOption = this.getMouseSelectedItemOptionText();
        if (itemOption.contains("SELECTED_ITEM_COPY ")) {
            itemOption = itemOption.replace("SELECTED_ITEM_COPY ", "");
        }
        this.table.getItem(index).setText(6, itemOption);
    }

    private void setMenuItemOfEventType() {
        this.eventTypePopupMenu = new ReplayEditPopupMenu((Composite)this.table);
        this.eventTypePopupMenu.setMouseListener();
        this.eventTypePopupMenu.setFont(FontResources.CONTEXT_MENU_ITEM_FONT);
        DAPopupMenuItem cutItem = new DAPopupMenuItem(this.eventTypePopupMenu);
        cutItem.setText(ReplayEditLabels.CONTEXT_TOUCH);
        cutItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                ReplayEditTable.this.updateSelectPopupMenu(ReplayEditLabels.CONTEXT_TOUCH);
            }
        });
        DAPopupMenuItem copyItem = new DAPopupMenuItem(this.eventTypePopupMenu);
        copyItem.setText(ReplayEditLabels.CONTEXT_KEY);
        copyItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                ReplayEditTable.this.updateSelectPopupMenu(ReplayEditLabels.CONTEXT_KEY);
            }
        });
    }

    private void setMenuItemOfKey() {
        this.eventKeyPopupMenu = new ReplayEditPopupMenu((Composite)this.table);
        this.eventKeyPopupMenu.setMouseListener();
        this.eventKeyPopupMenu.setFont(FontResources.CONTEXT_MENU_ITEM_FONT);
        DAPopupMenuItem menuItem = new DAPopupMenuItem(this.eventKeyPopupMenu);
        menuItem.setText(ReplayEditLabels.CONTEXT_KEY_MENU);
        menuItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                ReplayEditTable.this.updateSelectPopupMenu(ReplayEditLabels.CONTEXT_KEY_MENU);
            }
        });
        DAPopupMenuItem homeItem = new DAPopupMenuItem(this.eventKeyPopupMenu);
        homeItem.setText(ReplayEditLabels.CONTEXT_KEY_HOME);
        homeItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                ReplayEditTable.this.updateSelectPopupMenu(ReplayEditLabels.CONTEXT_KEY_HOME);
            }
        });
        DAPopupMenuItem backItem = new DAPopupMenuItem(this.eventKeyPopupMenu);
        backItem.setText(ReplayEditLabels.CONTEXT_KEY_BACK);
        backItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                ReplayEditTable.this.updateSelectPopupMenu(ReplayEditLabels.CONTEXT_KEY_BACK);
            }
        });
        DAPopupMenuItem powerItem = new DAPopupMenuItem(this.eventKeyPopupMenu);
        powerItem.setText(ReplayEditLabels.CONTEXT_KEY_POWER);
        powerItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                ReplayEditTable.this.updateSelectPopupMenu(ReplayEditLabels.CONTEXT_KEY_POWER);
            }
        });
        DAPopupMenuItem volumeUpItem = new DAPopupMenuItem(this.eventKeyPopupMenu);
        volumeUpItem.setText(ReplayEditLabels.CONTEXT_KEY_VOLUME_UP);
        volumeUpItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                ReplayEditTable.this.updateSelectPopupMenu(ReplayEditLabels.CONTEXT_KEY_VOLUME_UP);
            }
        });
        DAPopupMenuItem volumeDownItem = new DAPopupMenuItem(this.eventKeyPopupMenu);
        volumeDownItem.setText(ReplayEditLabels.CONTEXT_KEY_VOLUME_DOWN);
        volumeDownItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                ReplayEditTable.this.updateSelectPopupMenu(ReplayEditLabels.CONTEXT_KEY_VOLUME_DOWN);
            }
        });
    }

    private void setItemKeyText(Event event) {
        if (this.isMouseSelectedTableItem) {
            if (this.isTimeColumnIndex()) {
                this.updateTextOfTimeColumnIndex(event);
            } else if (this.isValueColumnIndex()) {
                this.updateTextOfValueColumnIndex(event);
            }
            this.updateVaildState();
        }
    }

    private boolean isTimeColumnIndex() {
        return this.getColumnName(this.getMouseSelectedTableColumnIndex()).equals(ReplayEditLabels.TABLE_COLUMN_MOUSE_DOWN_TIME) || this.getColumnName(this.getMouseSelectedTableColumnIndex()).equals(ReplayEditLabels.TABLE_COLUMN_MOUSE_UP_TIME);
    }

    private boolean isValueColumnIndex() {
        return this.getColumnName(this.getMouseSelectedTableColumnIndex()).equals(ReplayEditLabels.TABLE_COLUMN_VALUE1) || this.getColumnName(this.getMouseSelectedTableColumnIndex()).equals(ReplayEditLabels.TABLE_COLUMN_VALUE2);
    }

    private void updateTextOfTimeColumnIndex(Event event) {
        String[] lines;
        boolean iskeyInput = false;
        if ('0' <= event.character && event.character <= '9') {
            iskeyInput = true;
        }
        if ('.' == event.character) {
            iskeyInput = true;
        }
        if (!iskeyInput) {
            this.removeInputValue();
            return;
        }
        String savedString = this.inputValueText.getText();
        if (!savedString.contains(ReplayEditLabels.CONTEXT_VALUE_S)) {
            savedString = String.valueOf(savedString) + ReplayEditLabels.CONTEXT_VALUE_S;
        }
        if (savedString.length() > 10) {
            this.removeInputValue();
            return;
        }
        if (savedString.contains(".") && (lines = savedString.split("\\.")).length > 0 && lines[1].trim().length() > 2) {
            this.removeInputValue();
            return;
        }
        this.setMouseSelectedTableItemText(savedString);
        this.tableRedraw();
    }

    private void updateTextOfValueColumnIndex(Event event) {
        boolean iskeyInput = false;
        if ('0' <= event.character && event.character <= '9') {
            iskeyInput = true;
        }
        if (!iskeyInput) {
            this.removeInputValue();
            return;
        }
        String savedString = this.inputValueText.getText();
        StringBuffer inputString = new StringBuffer(savedString);
        if (this.getColumnName(this.getMouseSelectedTableColumnIndex()).equals(ReplayEditLabels.TABLE_COLUMN_VALUE1)) {
            if (!savedString.contains(ReplayEditLabels.CONTEXT_VALUE_X)) {
                inputString.insert(0, ReplayEditLabels.CONTEXT_VALUE_X);
            }
        } else if (!savedString.contains(ReplayEditLabels.CONTEXT_VALUE_Y)) {
            inputString.insert(0, ReplayEditLabels.CONTEXT_VALUE_Y);
        }
        this.setMouseSelectedTableItemText(inputString.toString());
        this.tableRedraw();
    }

    private void addTextWidget(GridItem gridItem) {
        GridEditor editor = new GridEditor(this.table);
        editor.minimumWidth = 10;
        editor.horizontalAlignment = 0x1000000;
        editor.grabHorizontal = true;
        this.inputValueText = new DATextBox((Composite)this.table, 0x1000000);
        this.inputValueText.getControl().setText(this.getMouseSelectedTableItemText());
        this.inputValueText.getControl().selectAll();
        this.inputValueText.getControl().setFocus();
        editor.setEditor((Control)this.inputValueText.getControl(), gridItem, this.getMouseSelectedTableColumnIndex());
    }

    private void removeInputValue() {
        if (this.inputValueText == null || this.inputValueText.getText().length() <= 0) {
            return;
        }
        StringBuffer textBuffer = new StringBuffer(this.inputValueText.getText());
        textBuffer.deleteCharAt(textBuffer.length() - 1);
        this.inputValueText.setText(textBuffer.toString());
        this.inputValueText.getControl().setSelection(textBuffer.length());
    }

    private void updateSelectPopupMenu(String text) {
        if (!this.getColumnName(this.getMouseSelectedTableColumnIndex()).equals(ReplayEditLabels.TABLE_COLUMN_TYPE)) {
            this.setMouseSelectedTableItemText(text);
            this.tableRedraw();
            return;
        }
        if (text.contains(ReplayEditLabels.CONTEXT_KEY)) {
            if (this.selectedPreKeyContext.size() > 3 && this.selectedPreKeyContext.get(0).equals(Integer.toString(this.getMouseSelectedTableItemIndex()))) {
                this.setPreSelectedContext(text);
            } else {
                this.table.getItem(this.getMouseSelectedTableItemIndex()).setText(this.getMouseSelectedTableColumnIndex(), text);
                this.table.getItem(this.getMouseSelectedTableItemIndex()).setText(this.getMouseSelectedTableColumnIndex() + 1, ReplayEditLabels.CONTEXT_KEY_MENU);
                this.table.getItem(this.getMouseSelectedTableItemIndex()).setText(this.getMouseSelectedTableColumnIndex() + 2, "-");
            }
        } else if (text.contains(ReplayEditLabels.CONTEXT_TOUCH)) {
            if (this.selectedPreTouchContext.size() > 3 && this.selectedPreTouchContext.get(0).equals(Integer.toString(this.getMouseSelectedTableItemIndex()))) {
                this.setPreSelectedContext(text);
            } else {
                this.table.getItem(this.getMouseSelectedTableItemIndex()).setText(this.getMouseSelectedTableColumnIndex(), text);
                this.table.getItem(this.getMouseSelectedTableItemIndex()).setText(this.getMouseSelectedTableColumnIndex() + 1, String.valueOf(ReplayEditLabels.CONTEXT_VALUE_X) + "0");
                this.table.getItem(this.getMouseSelectedTableItemIndex()).setText(this.getMouseSelectedTableColumnIndex() + 2, String.valueOf(ReplayEditLabels.CONTEXT_VALUE_Y) + "0");
            }
        }
        this.tableRedraw();
    }

    private void savedSelectedContext(String text) {
        if (text.equals(ReplayEditLabels.CONTEXT_KEY)) {
            this.selectedPreKeyContext.clear();
            this.selectedPreKeyContext.add(Integer.toString(this.getMouseSelectedTableItemIndex()));
            this.selectedPreKeyContext.add(this.table.getItem(this.getMouseSelectedTableItemIndex()).getText(this.getMouseSelectedTableColumnIndex()));
            this.selectedPreKeyContext.add(this.table.getItem(this.getMouseSelectedTableItemIndex()).getText(this.getMouseSelectedTableColumnIndex() + 1));
            this.selectedPreKeyContext.add(this.table.getItem(this.getMouseSelectedTableItemIndex()).getText(this.getMouseSelectedTableColumnIndex() + 2));
        } else if (text.equals(ReplayEditLabels.CONTEXT_TOUCH)) {
            this.selectedPreTouchContext.clear();
            this.selectedPreTouchContext.add(Integer.toString(this.getMouseSelectedTableItemIndex()));
            this.selectedPreTouchContext.add(this.table.getItem(this.getMouseSelectedTableItemIndex()).getText(this.getMouseSelectedTableColumnIndex()));
            this.selectedPreTouchContext.add(this.table.getItem(this.getMouseSelectedTableItemIndex()).getText(this.getMouseSelectedTableColumnIndex() + 1));
            this.selectedPreTouchContext.add(this.table.getItem(this.getMouseSelectedTableItemIndex()).getText(this.getMouseSelectedTableColumnIndex() + 2));
        }
    }

    private void setPreSelectedContext(String text) {
        if (text.equals(ReplayEditLabels.CONTEXT_KEY)) {
            this.table.getItem(this.getMouseSelectedTableItemIndex()).setText(this.getMouseSelectedTableColumnIndex(), this.selectedPreKeyContext.get(1));
            this.table.getItem(this.getMouseSelectedTableItemIndex()).setText(this.getMouseSelectedTableColumnIndex() + 1, this.selectedPreKeyContext.get(2));
            this.table.getItem(this.getMouseSelectedTableItemIndex()).setText(this.getMouseSelectedTableColumnIndex() + 2, this.selectedPreKeyContext.get(3));
        } else if (text.equals(ReplayEditLabels.CONTEXT_TOUCH)) {
            this.table.getItem(this.getMouseSelectedTableItemIndex()).setText(this.getMouseSelectedTableColumnIndex(), this.selectedPreTouchContext.get(1));
            this.table.getItem(this.getMouseSelectedTableItemIndex()).setText(this.getMouseSelectedTableColumnIndex() + 1, this.selectedPreTouchContext.get(2));
            this.table.getItem(this.getMouseSelectedTableItemIndex()).setText(this.getMouseSelectedTableColumnIndex() + 2, this.selectedPreTouchContext.get(3));
        }
    }

    private void upadteMouseOverTableItemsStatus(GridItem item, Event event) {
        int i = 0;
        while (i < this.table.getItemCount()) {
            int j = 0;
            while (j < this.table.getColumns().length) {
                this.table.getItem(i).setChecked(j, false);
                ++j;
            }
            ++i;
        }
        int selectedColumnIndex = this.getMouseColumnIndex(item, event);
        String selectedText = item.getText(selectedColumnIndex);
        if (selectedText.equals("-")) {
            return;
        }
        String selectedOptionText = item.getText(6);
        if (!selectedOptionText.contains("MODIFIABILITY_TRUE ")) {
            return;
        }
        if (selectedText.contains(ReplayEditLabels.CONTEXT_VALUE_S) || selectedText.length() == 0) {
            item.setImage(null);
        } else if (selectedText.contains(ReplayEditLabels.CONTEXT_VALUE_X) || selectedText.contains(ReplayEditLabels.CONTEXT_VALUE_Y)) {
            if (this.enableCoordinateIcon) {
                item.setImage(ImageResources.REPLAY_EDIT_SNAPSHOT_DOWN);
            } else {
                item.setImage(null);
            }
        } else {
            item.setImage(ImageResources.REPLAY_EDIT_DROPDOWN_DOWN);
        }
        item.setChecked(selectedColumnIndex, true);
        this.tableRedraw();
    }

    private void updateMouseOverTableItemsText() {
        if (!this.isMouseSelectedTableItem) {
            return;
        }
        this.removeMouseSelectedItemOptionText("SELECTED_ITEM_KEY_INPUT ");
        this.updateRollbackText();
        this.updateNextItemsSavedTime();
        this.updateVaildState();
        this.isMouseSelectedTableItem = false;
        this.tableRedraw();
    }

    private boolean updateVaildItems() {
        int nSize = this.table.getItemCount();
        long preEventTime = 0L;
        boolean isVaild = true;
        int i = 0;
        while (i < nSize) {
            String itemOption;
            long mouseDowntime = this.getLongTableTime(this.table.getItem(i).getText(1));
            String upTime = this.table.getItem(i).getText(2);
            long mouseUptime = 0L;
            mouseUptime = !upTime.equals("") ? this.getLongTableTime(upTime) : mouseDowntime;
            if (mouseUptime < mouseDowntime) {
                isVaild = false;
            } else if (mouseDowntime < preEventTime) {
                isVaild = false;
            } else {
                itemOption = this.table.getItem(i).getText(6);
                if (itemOption.contains("ITEM_TIME_VAILD_FALSE ")) {
                    String removeItemOption = itemOption.replace("ITEM_TIME_VAILD_FALSE ", "");
                    this.table.getItem(i).setText(6, removeItemOption);
                }
            }
            preEventTime = mouseUptime;
            if (!isVaild && !(itemOption = this.table.getItem(i).getText(6)).contains("ITEM_TIME_VAILD_FALSE ")) {
                this.table.getItem(i).setText(6, String.valueOf(itemOption) + "ITEM_TIME_VAILD_FALSE ");
            }
            ++i;
        }
        return isVaild;
    }

    private long getLongTableTime(String time) {
        String strTime = time;
        if (strTime.contains(ReplayEditLabels.CONTEXT_VALUE_S)) {
            strTime = time.replace(ReplayEditLabels.CONTEXT_VALUE_S, "");
        }
        if (strTime.contains(".")) {
            strTime = strTime.replace(".", "");
        }
        if (strTime.length() == 1) {
            strTime = String.valueOf(strTime) + 0;
        }
        if (strTime.equals("")) {
            return 0L;
        }
        return Long.parseLong(strTime);
    }

    private String getStrTableTime(Long time) {
        return String.format("%d.%ds", time / 10L, time % 10L);
    }

    private void addTableTime(boolean isMouseDown) {
        int startItem;
        String eventTime = this.updateDotChartAtTime();
        long preTime = this.getLongTableTime(this.savedItemTextForReset);
        long nowTime = this.getLongTableTime(eventTime);
        long addTime = nowTime - preTime;
        int nSize = this.table.getItemCount();
        int i = startItem = this.getMouseSelectedTableItemIndex();
        while (i < nSize) {
            if (this.table.getItem(i).getText(6).contains("MODIFIABILITY_TRUE ")) {
                long mouseDowntime = this.getLongTableTime(this.table.getItem(i).getText(1));
                mouseDowntime += addTime;
                String upTime = this.table.getItem(i).getText(2);
                long mouseUptime = 0L;
                if (!upTime.equals("")) {
                    mouseUptime = this.getLongTableTime(upTime);
                }
                mouseUptime += addTime;
                if (i == startItem) {
                    if (isMouseDown && !upTime.equals("")) {
                        this.table.getItem(i).setText(2, this.getStrTableTime(mouseUptime));
                    }
                } else {
                    this.table.getItem(i).setText(1, this.getStrTableTime(mouseDowntime));
                    if (!upTime.equals("")) {
                        this.table.getItem(i).setText(2, this.getStrTableTime(mouseUptime));
                    }
                }
            }
            ++i;
        }
    }

    private void updateNextItemsSavedTime() {
        if (!this.isMouseSelectedTableItem) {
            return;
        }
        String savedString = this.getMouseSelectedTableItemText();
        if (savedString.length() <= 0) {
            return;
        }
        if (this.getColumnName(this.getMouseSelectedTableColumnIndex()).equals(ReplayEditLabels.TABLE_COLUMN_MOUSE_DOWN_TIME)) {
            this.addTableTime(true);
        } else if (this.getColumnName(this.getMouseSelectedTableColumnIndex()).equals(ReplayEditLabels.TABLE_COLUMN_MOUSE_UP_TIME)) {
            this.addTableTime(false);
        }
    }

    private boolean updateRollbackText() {
        if (!this.isMouseSelectedTableItem) {
            return false;
        }
        String savedString = this.getMouseSelectedTableItemText();
        boolean isResetText = false;
        if (savedString.length() == 0) {
            isResetText = true;
        }
        if (!isResetText) {
            return false;
        }
        this.setMouseSelectedTableItemText(this.savedItemTextForReset);
        return true;
    }

    private String updateDotChartAtTime() {
        String chagneString = "";
        String savedString = this.getMouseSelectedTableItemText();
        if (!savedString.contains(".")) {
            String strPoint = ".0";
            chagneString = new StringBuffer(savedString).insert(savedString.length() - 1, strPoint).toString();
            this.setMouseSelectedTableItemText(chagneString);
        } else {
            chagneString = savedString;
        }
        return chagneString;
    }

    private void updateSelectedItemIndexValue(GridItem item, Event event) {
        GridColumn[] columns = this.table.getColumns();
        this.mouseSelectedItemIndex = -1;
        this.mouseSelectedColumnIndex = -1;
        this.mouseSelectedPreColunmEndX = -1;
        int tableItemSize = this.table.getItemCount();
        boolean isFindSelectedItem = false;
        int i = 0;
        while (i < tableItemSize) {
            if (isFindSelectedItem) break;
            this.mouseSelectedPreColunmEndX = -1;
            int j = 0;
            while (j < columns.length) {
                if (this.table.getItem(i).getChecked(j)) {
                    this.mouseSelectedItemIndex = i;
                    this.mouseSelectedColumnIndex = j;
                    isFindSelectedItem = true;
                    break;
                }
                this.mouseSelectedPreColunmEndX += columns[j].getWidth();
                ++j;
            }
            ++i;
        }
    }

    private void updateKeyboardInputStatus(GridItem item, Event event) {
        if (!item.getText(6).contains("MODIFIABILITY_TRUE ")) {
            this.deleteItem.setEnabled(false);
            return;
        }
        String selectedText = this.getMouseSelectedTableItemText();
        if (selectedText.contains(ReplayEditLabels.CONTEXT_VALUE_X) || selectedText.contains(ReplayEditLabels.CONTEXT_VALUE_Y) || selectedText.contains(ReplayEditLabels.CONTEXT_VALUE_S) || selectedText.equals("")) {
            this.isMouseSelectedTableItem = true;
            this.savedItemTextForReset = this.getMouseSelectedTableItemText();
            this.addTextWidget(item);
            this.addMouseSelectedItemOptionText("SELECTED_ITEM_KEY_INPUT ");
        }
    }

    private boolean selectPopupMenuMouseDownIcon(GridItem item, Event event) {
        if (this.mouseSelectedPreColunmEndX > event.x || event.x > this.mouseSelectedPreColunmEndX + 20 || this.getMouseSelectedTableItemIndex() == -1) {
            return true;
        }
        Point tablePt = new Point(this.table.getShell().getBounds().x, this.table.getShell().getBounds().y);
        Point MousePt = new Point(0, 0);
        MousePt.x = tablePt.x + this.mouseSelectedPreColunmEndX + 8;
        int selectedIndexPosition = this.table.getSelectionIndex() - this.table.getVerticalBar().getSelection();
        MousePt.y = tablePt.y + this.table.getItemHeight() * selectedIndexPosition + 135;
        String selectedText = item.getText(this.getMouseSelectedTableColumnIndex());
        if (selectedText.contains(ReplayEditLabels.CONTEXT_TOUCH) || selectedText.contains(ReplayEditLabels.CONTEXT_KEY)) {
            this.eventTypePopupMenu.open(this.eventTypePopupMenu.getTopShell(), MousePt.x, MousePt.y);
            this.savedSelectedContext(selectedText);
        } else if (selectedText.contains(ReplayEditLabels.CONTEXT_KEY_MENU) || selectedText.contains(ReplayEditLabels.CONTEXT_KEY_HOME) || selectedText.contains(ReplayEditLabels.CONTEXT_KEY_BACK) || selectedText.contains(ReplayEditLabels.CONTEXT_KEY_POWER) || selectedText.contains(ReplayEditLabels.CONTEXT_KEY_VOLUME_UP) || selectedText.contains(ReplayEditLabels.CONTEXT_KEY_VOLUME_DOWN)) {
            this.eventKeyPopupMenu.open(this.eventKeyPopupMenu.getTopShell(), MousePt.x, MousePt.y);
        } else {
            if (selectedText.contains(ReplayEditLabels.CONTEXT_VALUE_X) || selectedText.contains(ReplayEditLabels.CONTEXT_VALUE_Y)) {
                if (this.enableCoordinateIcon) {
                    ReplayEditScreenshotDialog dialog = new ReplayEditScreenshotDialog(this.table.getShell(), item);
                    dialog.open();
                }
                return false;
            }
            this.openPoppupMenuMouseDownSequenceColumn(item, event);
        }
        return true;
    }

    private void openPoppupMenuMouseDownSequenceColumn(GridItem item, Event event) {
        if (!item.getText(6).contains("MODIFIABILITY_TRUE ")) {
            if (this.selectedCutItemIndex > 0 || this.selectedCopyItemIndex > 0) {
                this.insertItem.setEnabled(true);
            } else {
                this.insertItem.setEnabled(false);
            }
            this.copyItem.setEnabled(false);
            this.cutItem.setEnabled(false);
            this.pasteItem.setEnabled(false);
            this.deleteItem.setEnabled(false);
        } else if (this.getCopyItemIndex() > -1) {
            this.copyItem.setEnabled(true);
            this.cutItem.setEnabled(true);
            this.insertItem.setEnabled(true);
            this.pasteItem.setEnabled(true);
            this.deleteItem.setEnabled(true);
        } else {
            this.copyItem.setEnabled(true);
            this.cutItem.setEnabled(true);
            this.insertItem.setEnabled(true);
            this.pasteItem.setEnabled(false);
            this.deleteItem.setEnabled(true);
        }
        GridColumn[] columns = this.table.getColumns();
        if (event.x <= columns[0].getWidth()) {
            Point pt = Display.getCurrent().getCursorLocation();
            this.popupMenu.open(this.popupMenu.getTopShell(), pt.x - 5, pt.y - 5);
        } else {
            this.popupMenu.closeChild();
        }
    }

    private int getCopyItemIndex() {
        int nSize = this.table.getItemCount();
        int index = -1;
        int i = 0;
        while (i < nSize) {
            if (this.table.getItem(i).getText(6).contains("SELECTED_ITEM_COPY ")) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private int getMouseColumnIndex(GridItem item, Event event) {
        this.nowMousePositionX = event.x;
        this.nowMousePositionY = event.y;
        GridColumn[] columns = this.table.getColumns();
        int size = columns.length;
        int preColunmStartX = 0;
        int preColunmEndX = 0;
        int i = 0;
        while (i < size) {
            if (preColunmStartX <= event.x && event.x <= (preColunmEndX += columns[i].getWidth())) {
                return i;
            }
            preColunmStartX += columns[i].getWidth();
            ++i;
        }
        return -1;
    }

    private void tableRedraw() {
        this.table.redraw(this.nowMousePositionX - 100, this.nowMousePositionY - 100, 100, 100, false);
    }

    private void updateVaildState() {
        if (this.updateVaildItems()) {
            this.enableSaveButton();
        } else {
            this.disableSaveButton();
        }
        this.table.redraw();
    }

    private void enableSaveButton() {
        if (ReplayEditTableDataMaker.getInstance().getOkButton() != null) {
            ReplayEditTableDataMaker.getInstance().getOkButton().setButtonEnabled(true);
        }
        if (ReplayEditTableDataMaker.getInstance().getSaveButton() != null) {
            ReplayEditTableDataMaker.getInstance().getSaveButton().setButtonEnabled(true);
        }
    }

    private void disableSaveButton() {
        if (ReplayEditTableDataMaker.getInstance().getOkButton() != null) {
            ReplayEditTableDataMaker.getInstance().getOkButton().setButtonEnabled(false);
        }
        if (ReplayEditTableDataMaker.getInstance().getSaveButton() != null) {
            ReplayEditTableDataMaker.getInstance().getSaveButton().setButtonEnabled(false);
        }
    }

    @Override
    public void setColumns(String[] columnNames) {
        this.columnNames = columnNames;
        int size = columnNames.length;
        int i = 0;
        while (i < size) {
            GridColumn column = new GridColumn(this.table, 0);
            column.setText(columnNames[i]);
            column.setCellRenderer((GridCellRenderer)new ReplayEditTableCellRenderer());
            column.setHeaderRenderer((GridHeaderRenderer)new DATableHeaderRenderer());
            column.pack();
            ++i;
        }
    }

    public String getColumnName(int index) {
        if (this.columnNames.length > index) {
            return this.columnNames[index];
        }
        Logger.error((Object)"[ERR] input column index is wrong !!");
        return "";
    }

    private String getReplaceString(String target, String oldString, String newString) {
        return target.replace(oldString, newString);
    }
}

