/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.userinterface.control;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.common.SymbolManager;
import org.tizen.dynamicanalyzer.swap.model.data.ControlData;
import org.tizen.dynamicanalyzer.ui.userinterface.UIDataManager;
import org.tizen.dynamicanalyzer.ui.userinterface.control.UIControlListData;
import org.tizen.dynamicanalyzer.ui.userinterface.profiling.UIFunctionProfilingData;
import org.tizen.dynamicanalyzer.util.Logger;

public class UIControlListDataChecker {
    private List<UIControlListData> controlList = null;
    private List<String> removeCallControlList = null;
    private long preSeq = -1L;

    public void parserLog(ControlData input) {
        String stClassName = this.getClassName(input.getApiName()).trim();
        if (stClassName.contains("AddFrame") || stClassName.contains("AddControl")) {
            if (this.isExistData(input.getParentClassName(), input.getChildClassName())) {
                return;
            }
            if (this.preSeq == input.getSeq()) {
                return;
            }
            this.addSortData(this.makeUIControlListData(input));
            this.setUIControlListTimeData();
            this.preSeq = input.getSeq();
        } else if (stClassName.trim().contains("RemoveControl")) {
            this.getRemoveCallControlList().add(input.getChildClassName());
        } else {
            if (stClassName.trim().contains("SetName") || stClassName.contains("RemoveFrame") || stClassName.contains("RemoveAllControl")) {
                return;
            }
            Logger.debug((Object)("wrong type log : " + stClassName.trim()));
        }
    }

    private UIControlListData makeUIControlListData(ControlData input) {
        UIControlListData controlData = new UIControlListData(input);
        controlData.setSequence(input.getSeq());
        controlData.setTime(input.getTime());
        controlData.setAPIName(this.getClassName(input.getApiName()).trim());
        controlData.setInitializeTime("-");
        controlData.setTerminateTime("-");
        controlData.setParentName(input.getParentName());
        controlData.setParentClassName(input.getParentClassName());
        controlData.setParentPointer(input.getParentPointer());
        controlData.setChildName(input.getChildName());
        controlData.setPID(input.getPid());
        StringBuilder childClassNameDemangling = new StringBuilder(input.getChildClassName());
        childClassNameDemangling.insert(0, "_Z");
        String childClassName = SymbolManager.demanglingFunctionName(childClassNameDemangling.toString());
        controlData.setChildClassName(childClassName);
        controlData.setChildPointer(input.getChildPointer());
        controlData.setControlType(input.getChildName());
        controlData.setCalssKeyName(this.getClassName(input));
        return controlData;
    }

    private boolean isExistData(String parentClassNam, String childClassName) {
        if (this.getRemoveCallControlList() == null) {
            return false;
        }
        int nSize = this.getRemoveCallControlList().size();
        int i = 0;
        while (i < nSize) {
            if (this.getRemoveCallControlList().get(i).equals(parentClassNam) || this.getRemoveCallControlList().get(i).equals(childClassName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void addSortData(UIControlListData data) {
        int nSize = this.getDataList().size();
        int i = 0;
        while (i < nSize) {
            if (data.getParentPointer() == 0L) {
                this.getDataList().add(0, data);
                return;
            }
            if (this.getDataList().get(i).getChildPointer() == data.getParentPointer()) {
                this.getDataList().add(i + 1, data);
                return;
            }
            if (this.getDataList().get(i).getParentPointer() == data.getChildPointer()) {
                int insertIndex = 0;
                insertIndex = i - 1 < 0 ? 0 : i - 1;
                this.getDataList().add(insertIndex, data);
                return;
            }
            ++i;
        }
        this.getDataList().add(data);
    }

    private String getClassName(String apiName) {
        String[] splitApiNameList = apiName.split("::");
        String strApiName = "";
        if (splitApiNameList.length == 1) {
            strApiName = splitApiNameList[0].trim();
        } else {
            String clasName = splitApiNameList[1].trim();
            if (clasName.contains("(")) {
                String[] splitClassNameList = clasName.split("\\(");
                strApiName = splitClassNameList[0];
            }
        }
        return strApiName;
    }

    public void notificationFromUserInterfaceFunctionProfilingDataChecker() {
        if (this.controlList != null) {
            this.setUIControlListTimeData();
        }
    }

    private void setUIControlListTimeData() {
        UIDataManager uiManager = UIDataManager.getInstance();
        List<UIFunctionProfilingData> controlList = uiManager.getfunctionProfilingDataChecker().getDataList();
        int i = 0;
        while (i < controlList.size()) {
            String[] splitProfilingList = controlList.get(i).getAPIName().split("::");
            String strProfilingClassName = new String(splitProfilingList[0].trim());
            String strProfilingAPIName = new String(splitProfilingList[splitProfilingList.length - 1].trim());
            int j = 0;
            while (j < this.getDataList().size()) {
                if (this.getDataList().get(j).getChildClassName().trim().contains(strProfilingClassName) && i < controlList.size()) {
                    if (strProfilingAPIName.trim().contains("OnInitializing")) {
                        this.getDataList().get(j).setInitializeTime(controlList.get(i).getExclElapsedTime());
                    } else if (strProfilingAPIName.trim().contains("OnTerminating")) {
                        this.getDataList().get(j).setTerminateTime(controlList.get(i).getExclElapsedTime());
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private String getDemanglingName(String uiClassName) {
        String demangleName = "";
        StringBuilder childClassNameDemangling = new StringBuilder(uiClassName);
        if (childClassNameDemangling.indexOf("_Z") != 0) {
            childClassNameDemangling.insert(0, "_Z");
            demangleName = SymbolManager.demanglingFunctionName(childClassNameDemangling.toString());
        }
        return demangleName;
    }

    public String getClassName(ControlData dataFormat) {
        String apiName = dataFormat.getApiName();
        if (apiName.contains("AddFrame")) {
            String className = dataFormat.getChildClassName();
            return this.getDemanglingName(className);
        }
        String controlTyp = dataFormat.getChildName();
        String className = "";
        className = controlTyp.contains("Panel") || controlTyp.contains("Form") ? dataFormat.getChildClassName() : dataFormat.getParentClassName();
        return this.getDemanglingName(className);
    }

    public List<UIControlListData> getDataList() {
        if (this.controlList == null) {
            this.controlList = new ArrayList<UIControlListData>();
        }
        return this.controlList;
    }

    public List<String> getRemoveCallControlList() {
        if (this.removeCallControlList == null) {
            this.removeCallControlList = new ArrayList<String>();
        }
        return this.removeCallControlList;
    }
}

