/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.userinterface.scene;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.common.SymbolManager;
import org.tizen.dynamicanalyzer.swap.model.data.SceneData;
import org.tizen.dynamicanalyzer.ui.userinterface.UIDataManager;
import org.tizen.dynamicanalyzer.ui.userinterface.scene.UISceneData;
import org.tizen.dynamicanalyzer.utils.Formatter;

public class UISceneDataChecker {
    List<UISceneData> transfomSceneList;

    public void parserLog(SceneData input) {
        UISceneData sceneData = new UISceneData(input);
        sceneData.setSequence(input.getSeq());
        sceneData.setTime(input.getTime());
        sceneData.setPID(input.getPid());
        sceneData.setSceneName(input.getSceneName());
        sceneData.setFormName(input.getFormName());
        sceneData.setPanelName(input.getPanelName());
        sceneData.setCalssKeyName(this.getClassName(input));
        sceneData.setTransformTime(this.getTransitionTime(input.getTransitionTime()));
        this.getDataList().add(sceneData);
        UIDataManager.getInstance().getFindScreenshotViewHashMap().put(this.getClassName(input), input.getTime());
    }

    public List<UISceneData> getDataList() {
        if (this.transfomSceneList == null) {
            this.transfomSceneList = new ArrayList<UISceneData>();
        }
        return this.transfomSceneList;
    }

    private String getTransitionTime(long time) {
        if (time == -1L || time == 0L) {
            return "00:00.000";
        }
        String strTime = Long.toString(time);
        strTime = String.valueOf(strTime) + "00";
        return Formatter.toTimeFormat(strTime);
    }

    public String getClassName(SceneData dataFormat) {
        String className = "";
        String panelName = dataFormat.getPanelName();
        className = panelName.trim().equals("") ? dataFormat.getFormName() : panelName;
        StringBuilder childClassNameDemangling = new StringBuilder(className);
        childClassNameDemangling.insert(0, "_Z");
        className = SymbolManager.demanglingFunctionName(childClassNameDemangling.toString());
        return className;
    }
}

