/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.userinterface.scene;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.project.ImageInfo;
import org.tizen.dynamicanalyzer.swap.model.data.SceneData;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.userinterface.UIDataManager;
import org.tizen.dynamicanalyzer.ui.userinterface.UIPage;
import org.tizen.dynamicanalyzer.ui.userinterface.scene.UISceneData;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class UISceneListTable
extends DATableComposite {
    public UISceneListTable(Composite parent, int style, int tableStyle) {
        super(parent, style, tableStyle);
        this.setContextMenu(1);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = UISceneListTable.this.table.getSelection();
                if (items.length <= 0) {
                    return;
                }
                DATableDataFormat dataFormat = (DATableDataFormat)items[0].getData();
                SceneData data = (SceneData)dataFormat.getLogData();
                String className = UIDataManager.getInstance().getSceneTransformDataChecker().getClassName(data);
                UIDataManager.getInstance().setTableSeleteClassName(className);
                long time = UISceneListTable.this.getScreensotForScene(data.getTime());
                DASelectionData selData = new DASelectionData(UIPage.sceneListViewID, time, 0L, items, (Control)UISceneListTable.this.table);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
                UISceneListTable.this.updateTable();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private long getScreensotForScene(long strTime) {
        ImageInfo lastimg = Global.getLeastImageInfoByTime(strTime);
        if (lastimg == null) {
            return strTime;
        }
        return lastimg.getTime();
    }

    @Override
    protected List<TableInput> makeTableInput() {
        List<UISceneData> transfomSceneList = UIDataManager.getInstance().getSceneTransformDataChecker().getDataList();
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        int size = transfomSceneList.size();
        int i = 0;
        while (i < size) {
            int selectedPid = Toolbar.INSTANCE.getSelectedPid();
            if (selectedPid == 0 || transfomSceneList.get(i).getPID().equals(Integer.toString(selectedPid))) {
                ArrayList<String> text = new ArrayList<String>();
                UISceneData sceneTransformsData = transfomSceneList.get(i);
                SceneData inputData = (SceneData)sceneTransformsData.getData();
                DATableDataFormat tableData = new DATableDataFormat(sceneTransformsData.getSequence());
                tableData.setLogData(inputData);
                text.add(sceneTransformsData.getTime());
                text.add(sceneTransformsData.getPID());
                text.add(sceneTransformsData.getSceneName());
                text.add(sceneTransformsData.getFormName());
                text.add(sceneTransformsData.getPanelName());
                text.add(sceneTransformsData.getTransformTime());
                TableInput tableInput = new TableInput();
                tableInput.setText(text);
                tableInput.setData(tableData);
                input.add(tableInput);
                String strSelectedClassname = UIDataManager.getInstance().getTableSeleteClassName();
                if (strSelectedClassname.equals(sceneTransformsData.getCalssKeyName())) {
                    tableInput.setSecondSelection(true);
                }
                if (RangeDataManager.getInstance().isBeingAnalyzed()) {
                    long time = tableData.getLogData().getTime();
                    long analysisStartTime = RangeDataManager.getInstance().getAnalysisStartTime();
                    long analysisEndTime = RangeDataManager.getInstance().getAnalysisEndTime();
                    if (time >= analysisStartTime && time <= analysisEndTime) {
                        tableInput.setInRange(true);
                    }
                }
            }
            ++i;
        }
        return input;
    }
}

