/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.widgets;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.dynamicanalyzer.model.FindProperty;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATreeComposite;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;

public class SearchDialog
extends DAMessageBox {
    private static final int ENTER_KEY_CODE = 13;
    private static final int WIDTH = 430;
    private static final int HEIGHT = 223;
    private static final int HORIZONTAL_SPACING = 15;
    private static final int WIDTH_MARGIN = 26;
    private static final int BUTTON_HEIGHT = 30;
    private static final int CONTENT_COMP_HEIGHT = 138;
    private Text textBox = null;
    private Button cancelButton = null;
    private Button backButton = null;
    private Button nextButton = null;
    private Button caseButton = null;
    private Button wholeWordButton = null;
    private FindProperty findProperty = null;
    private Grid table = null;
    private String viewName = null;
    private Composite composite = null;
    private KeyListener keyListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            if (SearchDialog.this.textBox.getText() != null && !SearchDialog.this.textBox.getText().isEmpty()) {
                SearchDialog.this.nextButton.setEnabled(true);
                if (e.keyCode == 13) {
                    if ((e.stateMask & 0x20000) != 0) {
                        SearchDialog.this.findProperty.setBackward(true);
                        SearchDialog.this.findProperty.setLastSearch(SearchDialog.this.textBox.getText());
                        SearchDialog.this.executeFindCommand();
                        SearchDialog.this.findProperty.setBackward(false);
                    } else {
                        SearchDialog.this.findProperty.setLastSearch(SearchDialog.this.textBox.getText());
                        SearchDialog.this.executeFindCommand();
                    }
                }
            } else {
                SearchDialog.this.nextButton.setEnabled(false);
            }
        }

        public void keyPressed(KeyEvent e) {
        }
    };

    public SearchDialog(Shell parentShell, Composite comp) {
        super(parentShell);
        if (comp instanceof DATableComposite) {
            this.table = ((DATableComposite)comp).getTable();
            this.viewName = ((DATableComposite)comp).getTableName();
        } else if (comp instanceof DATreeComposite) {
            this.table = ((DATreeComposite)comp).getTable();
            this.viewName = ((DATreeComposite)comp).getTableName();
        } else {
            this.table = null;
            return;
        }
        this.composite = comp;
        this.findProperty = DATableComposite.getFindProferty();
        this.findProperty.setIndex(this.table.getSelectionIndex());
    }

    protected boolean run() {
        if (this.table == null) {
            return false;
        }
        int dialogLocationX = this.shell.getParent().getLocation().x + (this.shell.getParent().getSize().x - 430) / 2;
        int dialogLocationY = this.shell.getParent().getLocation().y + (this.shell.getParent().getSize().y - 223) / 2;
        this.shell.setLocation(dialogLocationX, dialogLocationY);
        this.shell.setSize(430, 223);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(AnalyzerLabels.SEARCH_DLG_TITLE);
        this.shell.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.shell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(ColorResources.DIALOG_TOP_LINE_COLOR);
                e.gc.drawLine(0, 0, 430, 0);
                e.gc.setForeground(ColorResources.DIALOG_BUTTON_LINE_COLOR);
                e.gc.drawLine(0, 139, 430, 139);
            }
        });
        Composite contentComp = new Composite((Composite)this.shell, 0);
        FormLayout contentLayout = new FormLayout();
        contentComp.setLayout((Layout)contentLayout);
        contentComp.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 1);
        data.left = new FormAttachment(0, 0);
        data.width = 430;
        data.height = 138;
        contentComp.setLayoutData((Object)data);
        Label descriptionLabel = new Label(contentComp, 0x40000000);
        data = new FormData();
        data.top = new FormAttachment(25, -descriptionLabel.computeSize((int)-1, (int)-1).y / 2);
        data.left = new FormAttachment(0, 26);
        descriptionLabel.setLayoutData((Object)data);
        descriptionLabel.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        descriptionLabel.setForeground(ColorResources.DIALOG_TEXT_FONT_COLOR);
        descriptionLabel.setText(String.valueOf(AnalyzerLabels.SEARCH_DLG_DESC_PREFIX) + " " + this.viewName + " " + AnalyzerLabels.SEARCH_DLG_DESC_POSTFIX);
        this.textBox = new Text(contentComp, 2052);
        data = new FormData();
        data.top = new FormAttachment(50, -this.textBox.computeSize((int)-1, (int)-1).y / 2);
        data.left = new FormAttachment(0, 26);
        data.right = new FormAttachment(100, -26);
        this.textBox.setLayoutData((Object)data);
        this.textBox.setFont(new Font((Device)this.textBox.getDisplay(), "Arial", 10, 0));
        this.textBox.addKeyListener(this.keyListener);
        FormAttachment top = new FormAttachment(75, -descriptionLabel.computeSize((int)-1, (int)-1).y / 2);
        Label optionLabel = new Label(contentComp, 0x40000000);
        data = new FormData();
        data.top = top;
        data.left = new FormAttachment(0, 26);
        optionLabel.setLayoutData((Object)data);
        optionLabel.setBackground(ColorResources.DIALOG_CONTENT_BACKGROUND);
        optionLabel.setForeground(ColorResources.DIALOG_TEXT_FONT_COLOR);
        optionLabel.setText(AnalyzerLabels.SEARCH_DLG_OPTION);
        this.wholeWordButton = new Button(contentComp, 524320);
        data = new FormData();
        data.top = top;
        data.right = new FormAttachment(100, -26);
        this.wholeWordButton.setLayoutData((Object)data);
        this.wholeWordButton.setText(AnalyzerLabels.SEARCH_DLG_WHOLE_WORD);
        this.wholeWordButton.setSelection(this.findProperty.isWholeWord());
        this.wholeWordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDialog.this.findProperty.setWholeWord(SearchDialog.this.wholeWordButton.getSelection());
            }
        });
        this.caseButton = new Button(contentComp, 524320);
        data = new FormData();
        data.top = top;
        data.right = new FormAttachment((Control)this.wholeWordButton, -15);
        this.caseButton.setLayoutData((Object)data);
        this.caseButton.setText(AnalyzerLabels.SEARCH_DLG_CASE_SENSITIVE);
        this.caseButton.setSelection(this.findProperty.isCaseSensitive());
        this.caseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDialog.this.findProperty.setCaseSensitive(SearchDialog.this.caseButton.getSelection());
            }
        });
        Composite buttonComp = new Composite((Composite)this.shell, 0);
        FormLayout buttonLayout = new FormLayout();
        buttonComp.setLayout((Layout)buttonLayout);
        buttonComp.setBackground(ColorResources.DIALOG_BUTTON_BACKGROUND);
        data = new FormData();
        data.top = new FormAttachment((Control)contentComp, 2);
        data.left = new FormAttachment(0, 0);
        data.width = 430;
        data.height = this.shell.getClientArea().height - 138 - 1;
        buttonComp.setLayoutData((Object)data);
        top = new FormAttachment(0, (data.height - 30) / 2);
        this.nextButton = new Button(buttonComp, 0);
        data = new FormData(86, 30);
        data.top = top;
        data.right = new FormAttachment(100, -26);
        this.nextButton.setLayoutData((Object)data);
        this.nextButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        this.nextButton.setText(AnalyzerLabels.SEARCH_DLG_NEXT_BUTTON);
        this.nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDialog.this.search(false);
            }
        });
        int buttonSpacing = -7;
        this.backButton = new Button(buttonComp, 0);
        data = new FormData(86, 30);
        data.top = top;
        data.right = new FormAttachment((Control)this.nextButton, buttonSpacing);
        this.backButton.setLayoutData((Object)data);
        this.backButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        this.backButton.setText(AnalyzerLabels.SEARCH_DLG_BACK_BUTTON);
        this.backButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDialog.this.search(true);
            }
        });
        this.cancelButton = new Button(buttonComp, 0);
        data = new FormData(86, 30);
        data.top = top;
        data.right = new FormAttachment((Control)this.backButton, buttonSpacing);
        this.cancelButton.setLayoutData((Object)data);
        this.cancelButton.setFont(FontResources.DIALOG_BUTTON_FONT);
        this.cancelButton.setText(AnalyzerLabels.SEARCH_DLG_CANCEL_BUTTON);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDialog.this.shell.close();
            }
        });
        this.textBox.setFocus();
        return true;
    }

    private void search(boolean backward) {
        this.findProperty.setBackward(backward);
        this.findProperty.setLastSearch(this.textBox.getText());
        this.executeFindCommand();
    }

    private boolean executeFindCommand() {
        int index = this.findProperty.getIndex();
        GridItem[] items = this.table.getItems();
        int itemCount = items.length;
        if (itemCount != 0) {
            index = this.findProperty.isBackward() ? (index - 1 < 0 ? itemCount - 1 : index - 1) : (index + 1 > itemCount - 1 ? 0 : index + 1);
            int findIndex = -1;
            this.findProperty.setIndex(index);
            if (this.composite instanceof DATableComposite) {
                findIndex = ((DATableComposite)this.composite).searchString(this.findProperty);
            } else if (this.composite instanceof DATreeComposite) {
                findIndex = ((DATreeComposite)this.composite).searchString(this.findProperty);
            } else {
                return false;
            }
            this.findProperty.setIndex(findIndex);
            return true;
        }
        return false;
    }
}

