/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.da.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;

public class DATabButton
extends DACustomButton {
    private List<Image> closeImages = null;
    private boolean closable = false;
    private boolean isAnimating = false;
    private int closeButtonState = 0;
    private Rectangle closeButtonRect = null;
    private DACustomButtonClickEventListener closeButtonListener = null;
    private Listener tbMouseEventListener = new Listener(){

        public void handleEvent(Event event) {
            DATabButton button = (DATabButton)event.widget;
            if (!button.isClosable()) {
                return;
            }
            int type = event.type;
            if (DATabButton.this.closeButtonRect == null) {
                Rectangle imgRect = button.getCloseButtonImage().getBounds();
                Rectangle rect = button.getBounds();
                DATabButton.this.closeButtonRect = new Rectangle(rect.width - imgRect.width - 6, rect.y + 1, imgRect.width, imgRect.height);
            }
            if (type == 5) {
                if (DATabButton.this.state == 3) {
                    if (DATabButton.this.closeButtonRect.contains(event.x, event.y)) {
                        button.setCloseButtonState(2);
                    } else {
                        button.setCloseButtonState(0);
                    }
                } else if (DATabButton.this.state == 0) {
                    button.setCloseButtonState(3);
                } else if (DATabButton.this.state == 2) {
                    if (DATabButton.this.closeButtonRect.contains(event.x, event.y)) {
                        button.setCloseButtonState(2);
                    } else {
                        button.setCloseButtonState(3);
                    }
                }
            } else if (type == 3) {
                if (DATabButton.this.state == 3 && DATabButton.this.closeButtonRect.contains(event.x, event.y)) {
                    button.setCloseButtonState(1);
                }
            } else if (type == 4) {
                if (DATabButton.this.closeButtonRect.contains(event.x, event.y)) {
                    button.setCloseButtonState(2);
                    if (DATabButton.this.closeButtonListener != null && !DATabButton.this.isAnimating) {
                        DATabButton.this.closeButtonListener.handleClickEvent((DACustomButton)button);
                    }
                } else {
                    button.setCloseButtonState(0);
                }
            }
        }
    };

    public DATabButton(Composite parent, int style, boolean isImageTab) {
        super(parent, ImageResources.TAB_NORMAL, ImageResources.TAB_PUSH, ImageResources.TAB_HOVER, ImageResources.TAB_SELECTED);
        this.addListener(5, this.tbMouseEventListener);
        this.addListener(3, this.tbMouseEventListener);
        this.addListener(4, this.tbMouseEventListener);
    }

    private List<Image> getCloseImages() {
        if (this.closeImages == null) {
            this.closeImages = new ArrayList<Image>();
            this.closeImages.add(ImageResources.CLOSE_BOX_NORMAL);
            this.closeImages.add(ImageResources.CLOSE_BOX_PUSH);
            this.closeImages.add(ImageResources.CLOSE_BOX_HOVER);
            this.closeImages.add(ImageResources.CLOSE_BOX_DISABLE);
        }
        return this.closeImages;
    }

    private void setCloseButtonState(int state) {
        this.closeButtonState = state;
        this.redraw();
    }

    public Image getCloseButtonImage() {
        return this.getCloseImages().get(this.closeButtonState);
    }

    public void setClosable(boolean enabled) {
        this.closable = enabled;
    }

    public boolean isClosable() {
        return this.closable;
    }

    public void changeButtonState(int state) {
        this.state = state;
        this.closeButtonState = state == 0 || state == 2 ? 3 : 0;
        this.redraw();
    }

    public void addCloseButtonListener(DACustomButtonClickEventListener listener) {
        this.closeButtonListener = listener;
    }

    public void setAnimating(boolean animating) {
        this.isAnimating = animating;
    }
}

