/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.da.view;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonAttribute;
import org.tizen.dynamicanalyzer.widgets.button.IDACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.da.view.DATabButton;

public class TabButtonRenderer
implements IDACustomButtonRenderer {
    public int computeFontSize(Rectangle rect) {
        if (rect.height > 20) {
            return 10;
        }
        return 8;
    }

    protected void drawImageButton(GC gc, Rectangle rect, int state, DACustomButtonAttribute attr, DATabButton button) {
        Image image = attr.getImage(state);
        if (image == null) {
            return;
        }
        gc.drawImage(image, rect.x, rect.y);
        this.drawButtonText(gc, rect, state, attr);
        if (button.isClosable()) {
            Image img = button.getCloseButtonImage();
            Rectangle imgRect = img.getBounds();
            gc.drawImage(img, rect.width - imgRect.width - 6, rect.y + 1);
        }
    }

    protected void drawButton(GC gc, Rectangle rect, int state, DACustomButtonAttribute attr, DATabButton button) {
        if (attr.getDrawType() == 1) {
            gc.setBackground(attr.getColor(state));
            gc.fillRectangle(rect);
        } else {
            int index = state * 2;
            gc.setForeground(attr.getColor(index));
            gc.setBackground(attr.getColor(index + 1));
            gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, true);
        }
        Rectangle r = new Rectangle(0, 0, rect.width - 1, rect.height - 1);
        if (attr.getButtonImage(state) == null) {
            this.drawButtonText(gc, r, state, attr);
        }
        Color c = gc.getForeground();
        Color outline = attr.getOutlineColor(state);
        gc.setForeground(outline == null ? c : outline);
        gc.drawRectangle(r);
        gc.setForeground(c);
        if (button.isClosable()) {
            Image img = button.getCloseButtonImage();
            Rectangle imgRect = img.getBounds();
            gc.drawImage(img, rect.width - imgRect.width - 2, rect.y + 2);
        }
    }

    protected void drawButtonImage(GC gc, Rectangle rect, DACustomButtonAttribute attr, int state) {
        if (attr != null) {
            Image img = attr.getButtonImage(state);
            if (img != null) {
                Rectangle imgRect = img.getBounds();
                int width = rect.width - imgRect.width;
                int height = rect.height - imgRect.height;
                int x = 0;
                int y = 0;
                if (width > 0) {
                    x = width / 2;
                }
                if (height > 0) {
                    y = height / 2;
                }
                gc.drawImage(img, x, y);
            } else {
                Logger.error((Object)"Image can not be null to draw button image!");
            }
        } else {
            Logger.error((Object)"ButtonAttribute can not be null to draw button image!");
        }
    }

    protected void drawButtonText(GC gc, Rectangle rect, int state, DACustomButtonAttribute attr) {
        String s = null;
        Font f = null;
        Point p = null;
        Rectangle textRect = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        if (attr.getIcon() != null) {
            Rectangle iconRect = attr.getIcon().getBounds();
            textRect.x += iconRect.width;
            textRect.width -= iconRect.width;
        }
        if ((s = attr.getText()) != null) {
            f = attr.getFont();
            if (f == null) {
                f = new Font((Device)Display.getCurrent(), "Arial", this.computeFontSize(rect), 1);
                attr.setFont(f);
            }
            if (state == 3) {
                String normalFontName = f.getFontData()[0].getName();
                int normalFontSize = f.getFontData()[0].getHeight();
                f = new Font((Device)Display.getCurrent(), normalFontName, normalFontSize, 1);
            }
            gc.setFont(f);
            int x = 0;
            int y = 0;
            int offset = 0;
            p = attr.getFontPoint();
            if (p == null) {
                p = gc.textExtent(s, 8);
                if (attr.getAlign() == 0x1000000) {
                    x = (textRect.width - p.x) / 2 + textRect.x;
                    x = x < 0 ? 0 : x;
                    offset = -2;
                } else {
                    x = textRect.x;
                    offset = 5;
                }
                y = (textRect.height - p.y) / 2;
            } else {
                x = p.x;
                y = p.y;
            }
            Color fontColor = attr.getFontColor(state);
            if (fontColor == null) {
                fontColor = ColorResources.WHITE;
            }
            gc.setForeground(fontColor);
            if (state == 1) {
                ++x;
                ++y;
            }
            gc.drawString(s, x + offset, y + 1, true);
        }
    }

    public void draw(GC gc, Canvas canvas, int state, DACustomButtonAttribute attr) {
        Rectangle rect = canvas.getClientArea();
        DATabButton tab = null;
        if (canvas instanceof DATabButton) {
            tab = (DATabButton)canvas;
            if (attr.getDrawType() == 0) {
                this.drawImageButton(gc, rect, state, attr, tab);
            } else if (attr.getDrawType() == 1 || attr.getDrawType() == 2) {
                this.drawButton(gc, rect, state, attr, tab);
            }
            this.drawIcon(gc, rect, attr);
        }
    }

    protected void drawIcon(GC gc, Rectangle parentRect, DACustomButtonAttribute attr) {
        Image icon = attr.getIcon();
        if (icon == null) {
            return;
        }
        gc.drawImage(icon, parentRect.x + 2, (parentRect.height - icon.getBounds().height) / 2);
    }
}

