/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import org.tizen.dynamicanalyzer.util.Logger;

public class CommonUtil {
    private static final String OS = CommonUtil.getOS();
    private static final String OS_KEY = "os.name";
    private static final String LINUX = "linux";
    private static final String MAC = "mac";
    private static final String WIN = "win";
    private static final String USER_HOME = "user.home";
    public static final String UNIX_CLASSPATH_SEPARATOR = ":";
    public static final String WINDOWS_CLASSPATH_SEPARATOR = ";";
    public static final String CLASSPATH_SEPARATOR = CommonUtil.getClasspathSeparator();
    private static String pid = null;

    public static boolean executeCommand(String[] cmd, List<String> stdoutput, List<String> stderror) {
        boolean bret = false;
        Process process = null;
        if (cmd != null && cmd.length > 0) {
            try {
                try {
                    process = Runtime.getRuntime().exec(cmd);
                    if (process != null) {
                        StreamReader inputReader = new StreamReader(process.getInputStream(), stdoutput);
                        StreamReader errorReader = new StreamReader(process.getErrorStream(), stderror);
                        inputReader.start();
                        errorReader.start();
                        process.waitFor();
                        inputReader.join();
                        errorReader.join();
                        bret = true;
                    }
                }
                catch (IOException e) {
                    Logger.exception(e);
                    if (process != null) {
                        process.destroy();
                    }
                }
                catch (InterruptedException e) {
                    Logger.exception(e);
                    if (process != null) {
                        process.destroy();
                    }
                }
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
            }
        }
        return bret;
    }

    public static boolean executeCommand(String[] cmds) {
        return CommonUtil.executeCommand(cmds, null, null);
    }

    public static void tryClose(Object ... closeables) {
        if (closeables == null) {
            return;
        }
        Object[] objectArray = closeables;
        int n = closeables.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj != null) {
                try {
                    if (obj instanceof Closeable) {
                        ((Closeable)obj).close();
                    } else if (obj instanceof ResultSet) {
                        ((ResultSet)obj).close();
                    } else if (obj instanceof Statement) {
                        ((Statement)obj).close();
                    } else if (obj instanceof Connection) {
                        ((Connection)obj).close();
                    } else {
                        Logger.error("Object is not closable");
                    }
                }
                catch (IOException e) {
                    Logger.exception(e);
                }
                catch (Exception e) {
                    Logger.exception(e);
                }
            }
            ++n2;
        }
    }

    public static boolean isLinux() {
        return OS.indexOf(LINUX) >= 0;
    }

    public static boolean isMac() {
        return OS.indexOf(MAC) >= 0;
    }

    public static boolean isWin() {
        return OS.indexOf(WIN) >= 0;
    }

    private static String getOS() {
        return System.getProperty(OS_KEY).toLowerCase();
    }

    private static String getClasspathSeparator() {
        return CommonUtil.isWin() ? WINDOWS_CLASSPATH_SEPARATOR : UNIX_CLASSPATH_SEPARATOR;
    }

    public static String getHomeDirectory() {
        return System.getProperty(USER_HOME);
    }

    public static String getCurrentPid() {
        if (pid == null) {
            ManagementFactory.getRuntimeMXBean();
            RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
            String Processid = rt.getName();
            pid = Processid.substring(0, Processid.indexOf("@"));
        }
        return pid;
    }

    public static String getNormalizedFilename(String original) {
        String result = original.replace('/', '_');
        result = result.replace('\\', '_');
        result = result.replace('?', '_');
        result = result.replace('*', '_');
        result = result.replace(':', '_');
        result = result.replace('|', '_');
        result = result.replace('\"', '_');
        result = result.replace('<', '_');
        result = result.replace('>', '_');
        return result;
    }

    public static boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }

    private static class StreamReader
    extends Thread {
        private InputStream is = null;
        private List<String> outputArray = null;

        protected StreamReader(InputStream is, List<String> outputArray) {
            this.is = is;
            this.outputArray = outputArray;
        }

        @Override
        public void run() {
            block6: {
                BufferedReader reader = null;
                try {
                    try {
                        reader = new BufferedReader(new InputStreamReader(this.is));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            if (this.outputArray == null) continue;
                            this.outputArray.add(line);
                        }
                    }
                    catch (IOException e) {
                        Logger.exception(e);
                        CommonUtil.tryClose(reader);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    CommonUtil.tryClose(reader);
                    throw throwable;
                }
                CommonUtil.tryClose(reader);
            }
        }
    }
}

