/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.commands;

import java.rmi.ConnectException;
import org.tizen.dynamicanalyzer.cli.CliInternals;
import org.tizen.dynamicanalyzer.cli.commands.Command;
import org.tizen.dynamicanalyzer.cli.commands.ExitCode;
import org.tizen.dynamicanalyzer.cli.manager.TracingProcessContext;
import org.tizen.dynamicanalyzer.cli.utils.HumanReadableTimeFormat;
import org.tizen.dynamicanalyzer.common.DAResult;

public class StopCommand
extends Command {
    public StopCommand() {
        super("stop", 1, "stop currently running tracing process on specified device", "<ip:port|serial>");
    }

    private ExitCode processCommandInternal(String[] args) throws ConnectException {
        String device = args[0];
        TracingProcessContext ctx = CliInternals.getContext(device);
        if (ctx == null) {
            System.out.println("Unknown device or no tracing process was started recently.");
            return ExitCode.EX_OPERATION_FAILED;
        }
        if (ctx.isFinished()) {
            DAResult.ErrorCode code = DAResult.ErrorCode.getErrorCode((int)ctx.getErrCode());
            if (code != null) {
                System.out.println("Tracing on device failed due to:\n" + code.getErrorMessage());
            } else {
                System.out.println("Tracing on device failed due to unknown reason.");
            }
            return ExitCode.EX_OPERATION_FAILED;
        }
        if (!ctx.isFinished()) {
            DAResult result = CliInternals.stopTracingProcess(device);
            if (!result.isSuccess()) {
                System.out.println("Can't stop tracing. " + result.getMessage());
                return ExitCode.EX_OPERATION_FAILED;
            }
            ctx = CliInternals.getContext(device);
            if (ctx == null) {
                throw new AssertionError((Object)"Got null TracingContext after successful tracing stop.");
            }
        }
        HumanReadableTimeFormat duration = new HumanReadableTimeFormat(ctx.getStartTime(), ctx.getFinishTime());
        HumanReadableTimeFormat tracingTime = null;
        try {
            tracingTime = CliInternals.getTracingTime(ctx.getArgs().getDevice());
        }
        catch (Exception e) {
            System.err.println("Can't get time from TracingProcessManager");
            return ExitCode.EX_OPERATION_FAILED;
        }
        System.out.format("DA tracing finished.%nTotal time:   %s%nTracing time: %s%nOutput:       %s%n", duration, tracingTime, ctx.getArgs().getOutput());
        return ExitCode.EX_SUCCESS;
    }

    @Override
    public ExitCode processCommand(String[] args) {
        try {
            return this.processCommandInternal(args);
        }
        catch (ConnectException e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return ExitCode.EX_CONNECTION_ERROR;
        }
    }
}

