/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.tracing;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.tizen.dynamicanalyzer.cli.tracing.TracingArguments;
import org.tizen.dynamicanalyzer.cli.tracing.TracingFeatureArgument;
import org.tizen.dynamicanalyzer.util.Logger;

public class TracingArgumentsParser {
    private static CommandLineParser parser = new DefaultParser();
    private static Option application = Option.builder((String)"a").hasArg().argName("application").required().desc("application to trace").build();
    private static Option duration = Option.builder((String)"i").hasArg().argName("sec").desc("tracing duration in seconds").build();
    private static Option output = Option.builder((String)"o").hasArg().argName("output filename").desc("redirect tracing output to file").build();
    private static Option screenshotPeriod = Option.builder((String)"S").hasArg().argName("period").desc("Enable screenshots capturing periodically").build();
    private static Option screenshotTransition = Option.builder((String)"s").desc("Enable screenshots capturing on scene transition").build();
    private static Options opts = new Options();

    public static Options getOpts() {
        return opts;
    }

    public static TracingArguments parse(String[] args) throws ParseException {
        String period;
        if (args == null || args.length == 0) {
            throw new ParseException("No arguments to parse");
        }
        TracingArguments result = new TracingArguments();
        result.setDevice(args[0]);
        String[] commandArgs = Arrays.copyOfRange(args, 1, args.length);
        CommandLine cmdline = parser.parse(opts, commandArgs);
        result.setApplication(cmdline.getOptionValue(application.getOpt()));
        if (cmdline.hasOption(duration.getOpt())) {
            Logger.error((Object)"Duration option is not supported");
            String durString = cmdline.getOptionValue(duration.getOpt());
            result.setDuration(Long.parseLong(durString));
        }
        if (cmdline.hasOption(output.getOpt())) {
            String outString = cmdline.getOptionValue(output.getOpt());
            result.setOutput(outString);
        }
        if (cmdline.hasOption(screenshotPeriod.getOpt()) && (period = cmdline.getOptionValue(screenshotPeriod.getOpt())) != null) {
            try {
                int periodInt = Integer.parseInt(period);
                if (periodInt < 0) {
                    throw new NumberFormatException();
                }
                result.setScreenshotPeriod(periodInt);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(" * Screenshot period is not numeric%n");
            }
        }
        if (cmdline.hasOption(screenshotTransition.getOpt())) {
            result.setScreenshotOnSceneTransition(true);
        }
        TracingFeatureArgument.parseFeatureOptions(result, cmdline);
        if (cmdline.getArgList() != null && !cmdline.getArgList().isEmpty()) {
            throw new ParseException("Too many arguments");
        }
        if (!result.isValid()) {
            throw new ParseException(result.getErrorMessage());
        }
        return result;
    }

    public static String[] toStringArray(TracingArguments args) {
        int period;
        String out;
        if (args == null || !args.isValid()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        String device = args.getDevice();
        result.add(device);
        String app = args.getApplication();
        result.add('-' + application.getOpt());
        result.add(app);
        long dur = args.getDuration();
        if (dur > 0L) {
            Logger.error((Object)"Duration option is not supported");
            result.add('-' + duration.getOpt());
            result.add(Long.toString(dur));
        }
        if ((out = args.getOutput()) != null) {
            result.add('-' + output.getOpt());
            result.add(out);
        }
        if (args.getScreenshotOnSceneTransition()) {
            result.add('-' + screenshotTransition.getOpt());
        }
        if ((period = args.getScreenshotPeriod()) > 0) {
            result.add('-' + screenshotPeriod.getOpt());
            result.add(Integer.toString(period));
        }
        result.addAll(TracingFeatureArgument.toStringArrayList(args));
        return result.toArray(new String[0]);
    }

    static {
        opts.addOption(application).addOption(output);
        for (TracingFeatureArgument featureOpt : TracingFeatureArgument.values()) {
            opts.addOption(featureOpt.getOption());
        }
        opts.addOption(screenshotPeriod);
        opts.addOption(screenshotTransition);
    }
}

