/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.tracing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.tizen.dynamicanalyzer.cli.tracing.TracingArguments;
import org.tizen.dynamicanalyzer.setting.PrimitiveFeature;

public enum TracingFeatureArgument {
    CPU("C", "cpu-usage"),
    MEMORY("M", "memory"),
    FILE("F", "file"),
    GRAPHICS("G", "graphics"),
    NETWORK("N", "network"),
    THREAD("T", PrimitiveFeature.THREAD_ANALYSIS),
    UIEVENT("U", PrimitiveFeature.UI_EVENT),
    PERIPHERAL("P", PrimitiveFeature.PERIPHERAL_STATUS),
    POWER("E", PrimitiveFeature.POWER_ESTIMATION);

    private final Option option;
    private Map<String, PrimitiveFeature> availFeatures = new HashMap<String, PrimitiveFeature>();
    private List<PrimitiveFeature> defFeatures = new ArrayList<PrimitiveFeature>();
    private final String ALL_NAME = "all";

    private TracingFeatureArgument(String name, String longName) {
        String desc = "select " + longName.replace("-", " ") + " tracing\n" + "Possible arguments: ";
        this.option = Option.builder((String)name).longOpt(longName).hasArgs().valueSeparator(',').optionalArg(true).desc(desc).build();
    }

    private void addDefaulFeaturestDescription() {
        String desc = this.option.getDescription();
        String defDesc = "If no arguments provided - '";
        if (this.defFeatures.size() == this.availFeatures.size()) {
            defDesc = defDesc + "all";
        } else {
            StringBuffer defArgsString = new StringBuffer();
            for (Map.Entry<String, PrimitiveFeature> feature : this.availFeatures.entrySet()) {
                if (!this.defFeatures.contains(feature.getValue())) continue;
                defArgsString.append(feature.getKey() + ",");
            }
            defDesc = defDesc + defArgsString.toString();
            defDesc = defDesc.substring(0, defDesc.length() - 1);
        }
        this.option.setDescription(desc + "\n" + defDesc + "' is selected");
    }

    private TracingFeatureArgument(String name, PrimitiveFeature feature) {
        this.option = Option.builder((String)name).longOpt(feature.getName().toLowerCase().replace(' ', '-')).desc("Select " + feature.getName().toLowerCase() + " tracing").build();
        this.defFeatures.add(feature);
    }

    private void addDefaultFeatureValue(String name, PrimitiveFeature feature) {
        this.addFeatureValue(name, feature);
        this.defFeatures.add(feature);
    }

    private void addFeatureValue(String name, PrimitiveFeature feature) {
        this.availFeatures.put(name, feature);
        this.updateArgsDescription(name);
    }

    private void updateArgsDescription(String name) {
        String desc = this.option.getDescription();
        desc = desc.replace("all", "");
        this.option.setDescription(desc + name + ", " + "all");
    }

    private void selectFeatures(TracingArguments result, String[] values) throws ParseException {
        for (String val : values) {
            if (val.equals("all")) {
                this.selectAllFeatures(result);
                continue;
            }
            if (this.availFeatures.containsKey(val)) {
                result.addFeature(this.availFeatures.get(val));
                continue;
            }
            throw new ParseException("Unsupported feature for " + this.getOption().getLongOpt() + " tracing: " + val);
        }
    }

    private void selectAllFeatures(TracingArguments result) {
        for (PrimitiveFeature feature : this.availFeatures.values()) {
            result.addFeature(feature);
        }
    }

    private void selectDefaultFeatures(TracingArguments result) {
        for (PrimitiveFeature feature : this.defFeatures) {
            result.addFeature(feature);
        }
    }

    public Option getOption() {
        return this.option;
    }

    public String getOptionName() {
        return this.option.getOpt();
    }

    public void parseFeatureOption(TracingArguments result, CommandLine cmdline) throws ParseException {
        String optName = this.getOptionName();
        if (cmdline.hasOption(optName)) {
            String[] optValues = cmdline.getOptionValues(optName);
            if (optValues == null || optValues.length == 0) {
                this.selectDefaultFeatures(result);
            } else {
                this.selectFeatures(result, optValues);
            }
        }
    }

    public static void parseFeatureOptions(TracingArguments result, CommandLine cmdline) throws ParseException {
        for (TracingFeatureArgument opt : TracingFeatureArgument.values()) {
            opt.parseFeatureOption(result, cmdline);
        }
        if (result.getFeatures().isEmpty()) {
            throw new ParseException("No tracing features seleted: at least one feature is required.");
        }
    }

    public static ArrayList<String> toStringArrayList(TracingArguments args) {
        ArrayList<String> result = new ArrayList<String>();
        Set<PrimitiveFeature> features = args.getFeatures();
        if (features.isEmpty()) {
            return result;
        }
        for (TracingFeatureArgument arg : TracingFeatureArgument.values()) {
            if (!arg.getOption().hasArgs() && features.containsAll(arg.defFeatures)) {
                result.add('-' + arg.getOptionName());
                continue;
            }
            ArrayList<String> argValues = new ArrayList<String>();
            for (Map.Entry<String, PrimitiveFeature> availFeature : arg.availFeatures.entrySet()) {
                if (!features.contains(availFeature.getValue())) continue;
                argValues.add(availFeature.getKey());
            }
            if (argValues.isEmpty()) continue;
            result.add('-' + arg.getOptionName());
            result.addAll(argValues);
        }
        return result;
    }

    static {
        CPU.addDefaultFeatureValue("usage", PrimitiveFeature.CPU_USAGE);
        CPU.addDefaultFeatureValue("core", PrimitiveFeature.CPU_USAGE_PER_CORE);
        CPU.addDefaultFeatureValue("frequency", PrimitiveFeature.CPU_FREQ_PER_CORE);
        MEMORY.addDefaultFeatureValue("system", PrimitiveFeature.SYSTEM_MEMORY);
        MEMORY.addDefaultFeatureValue("process", PrimitiveFeature.PROCESS_MEMORY);
        MEMORY.addFeatureValue("heap", PrimitiveFeature.MEMORY_ALLOC);
        FILE.addDefaultFeatureValue("io", PrimitiveFeature.DISK_IO);
        FILE.addDefaultFeatureValue("analysis", PrimitiveFeature.FILE_ANALYSIS);
        GRAPHICS.addDefaultFeatureValue("opengl", PrimitiveFeature.OPENGLES_ANALYSIS);
        NETWORK.addDefaultFeatureValue("io", PrimitiveFeature.NETWORK_IO);
        NETWORK.addDefaultFeatureValue("analysis", PrimitiveFeature.NETWORK_ANALYSIS);
        for (TracingFeatureArgument featureArg : TracingFeatureArgument.values()) {
            if (!featureArg.getOption().hasArgs()) continue;
            featureArg.addDefaulFeaturestDescription();
        }
    }
}

