/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.Semaphore;
import org.tizen.dynamicanalyzer.cli.manager.TracingProcessContext;
import org.tizen.dynamicanalyzer.cli.utils.Communicator;
import org.tizen.dynamicanalyzer.cli.utils.Message;
import org.tizen.dynamicanalyzer.util.Logger;

public class ManagerCommunicationProcessor
implements Runnable {
    private Communicator comm;
    private TracingProcessContext ctx;
    HashMap<Long, Semaphore> requestsPool = new HashMap();
    HashMap<Long, Message> responsePool = new HashMap();

    public ManagerCommunicationProcessor(Communicator comm, TracingProcessContext ctx) {
        this.comm = comm;
        this.ctx = ctx;
    }

    @Override
    public void run() {
        block4: while (true) {
            Message message;
            if ((message = this.comm.getMessage()) == null) break;
            switch (message.getMessageType()) {
                case REQUEST__STOP_TRACING: 
                case REQUEST__TRACING_TIME: {
                    Logger.error((Object)"Wrong message for Manager");
                    continue block4;
                }
                case SIGNAL__ERROR_OCCURED: {
                    this.reportError(message);
                    continue block4;
                }
            }
            this.responsePool.put(message.getTid(), message);
            this.requestsPool.remove(message.getTid()).release();
        }
        Logger.debug((Object)"Communication stopped");
    }

    private void reportError(Message message) {
        this.ctx.finishContext(Integer.parseInt(message.getArgs()[0]));
        this.comm.stop();
    }

    private Message getResponse(long threadIndex, Message messageToSend) {
        Semaphore semaphore = new Semaphore(1);
        semaphore.acquireUninterruptibly();
        try {
            this.requestsPool.put(threadIndex, semaphore);
            this.comm.sendMessage(messageToSend);
            semaphore.acquireUninterruptibly();
            semaphore.release();
            return this.responsePool.remove(threadIndex);
        }
        catch (IOException e) {
            Logger.error((Object)e);
            semaphore.release();
            return null;
        }
    }

    public long getTracingTime() {
        long threadIndex = Thread.currentThread().getId();
        Message mes = this.getResponse(threadIndex, new Message(threadIndex, Message.MessageType.REQUEST__TRACING_TIME, new String[0]));
        if (mes != null && mes.getMessageType() == Message.MessageType.RESPONSE__TRACING_TIME) {
            return Long.parseLong(mes.getArgs()[0]);
        }
        return 0L;
    }

    public Message stopTracing() {
        long threadIndex = Thread.currentThread().getId();
        return this.getResponse(threadIndex, new Message(threadIndex, Message.MessageType.REQUEST__STOP_TRACING, new String[0]));
    }

    public void closeConnection() {
        this.comm.stop();
    }
}

