/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.project;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.project.LibraryObject;
import org.tizen.dynamicanalyzer.project.data.MemoryMapDBTable;

public class ProcessMemoryMap {
    private static final String WHERE_PID_TIME = "where " + MemoryMapDBTable.COLUMN.PID.name + "=%d and " + MemoryMapDBTable.COLUMN.CAPTIME.name + "=%d";
    private int pid;
    private long capturedTime = -1L;
    protected LibraryObject mainBinary = null;
    protected NavigableMap<Long, LibraryObject> binaryByAddress = new TreeMap<Long, LibraryObject>();
    protected Map<Integer, LibraryObject> binaryByBinaryID = new HashMap<Integer, LibraryObject>();

    public ProcessMemoryMap(int pid, long time) {
        this.pid = pid;
        this.capturedTime = time;
    }

    public long getCapturedTime() {
        return this.capturedTime;
    }

    public void setCapturedTime(long time) {
        this.capturedTime = time;
    }

    public void setMainBinary(LibraryObject libobj) {
        this.mainBinary = libobj;
        this.addLibraryMap(libobj);
    }

    public LibraryObject getMainbinary() {
        return this.mainBinary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLibraryMap(LibraryObject libobj) {
        long lowaddr = libobj.getLowestAddress();
        int binid = libobj.getBinaryID();
        LibraryObject objByID = null;
        Map<Integer, LibraryObject> map = this.binaryByBinaryID;
        synchronized (map) {
            objByID = this.binaryByBinaryID.put(binid, libobj);
        }
        map = this.binaryByAddress;
        synchronized (map) {
            if (objByID != null) {
                this.binaryByAddress.remove(objByID.getLowestAddress());
            }
            this.binaryByAddress.put(lowaddr, libobj);
        }
        return objByID == null;
    }

    public LibraryObject getLibraryByAddress(long address) {
        Map.Entry<Long, LibraryObject> entry = this.binaryByAddress.floorEntry(address);
        if (entry == null) {
            return null;
        }
        LibraryObject libobj = entry.getValue();
        if (libobj != null && address <= libobj.getHighestAddress()) {
            return libobj;
        }
        return null;
    }

    public LibraryObject getLibraryByBinaryID(int binaryID) {
        return this.binaryByBinaryID.get(binaryID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLibrary(long lowaddr, long highaddr) {
        LibraryObject libobj = this.binaryByAddress.floorEntry(lowaddr).getValue();
        if (libobj != null && highaddr <= libobj.getHighestAddress()) {
            Map<Number, LibraryObject> map = this.binaryByAddress;
            synchronized (map) {
                this.binaryByAddress.remove(libobj.getLowestAddress());
            }
            map = this.binaryByBinaryID;
            synchronized (map) {
                this.binaryByBinaryID.remove(libobj.getBinaryID());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(ProcessMemoryMap srcMap) {
        this.mainBinary = srcMap.mainBinary;
        Map<Number, LibraryObject> map = this.binaryByAddress;
        synchronized (map) {
            this.binaryByAddress.putAll(srcMap.binaryByAddress);
        }
        map = this.binaryByBinaryID;
        synchronized (map) {
            this.binaryByBinaryID.putAll(srcMap.binaryByBinaryID);
        }
    }

    public void saveMemoryMap(DBTable table) {
        ArrayList<List<Object>> datas = new ArrayList<List<Object>>();
        for (Map.Entry entry : this.binaryByAddress.entrySet()) {
            ArrayList<Serializable> data = new ArrayList<Serializable>();
            LibraryObject lib = (LibraryObject)entry.getValue();
            data.add(Integer.valueOf(this.pid));
            data.add(Long.valueOf(this.capturedTime));
            data.add(Long.valueOf(lib.getLowestAddress()));
            data.add(Long.valueOf(lib.getHighestAddress()));
            data.add(Integer.valueOf(lib.getBinaryID()));
            if (lib == this.mainBinary) {
                data.add(Boolean.valueOf(true));
            } else {
                data.add(Boolean.valueOf(false));
            }
            datas.add(data);
        }
        table.insertData(datas);
    }

    public void openMemoryMap(DBTable table) {
        this.binaryByAddress.clear();
        this.binaryByBinaryID.clear();
        String where = String.format(WHERE_PID_TIME, this.pid, this.capturedTime);
        List<List<Object>> memdatas = table.selectAllColumnData(where);
        if (memdatas != null) {
            int rsize = memdatas.size();
            int i = 0;
            while (i < rsize) {
                List<Object> memdata = memdatas.get(i);
                long lowaddr = (Long)memdata.get(2);
                long highaddr = (Long)memdata.get(3);
                int binaryID = (Integer)memdata.get(4);
                boolean mainornot = (Boolean)memdata.get(5);
                LibraryObject obj = new LibraryObject(binaryID, lowaddr, highaddr);
                if (mainornot) {
                    this.setMainBinary(obj);
                } else {
                    this.addLibraryMap(obj);
                }
                ++i;
            }
        }
    }

    public Map<Integer, LibraryObject> getAllLibraryID() {
        return this.binaryByBinaryID;
    }
}

