/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.protocol.p40;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.AckMessage;
import org.tizen.dynamicanalyzer.communicator.BaseCommunicator;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.communicator.ISerializable;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.communicator.ProtocolSerializer;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.control.ApplistManager;
import org.tizen.dynamicanalyzer.control.IProgress;
import org.tizen.dynamicanalyzer.model.AddrSymbolPair;
import org.tizen.dynamicanalyzer.nl.UserErrorWarningLabels;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.project.PackageInfo;
import org.tizen.dynamicanalyzer.protocol.p30.Communicator30;
import org.tizen.dynamicanalyzer.protocol.p30.ProtocolFilter30;
import org.tizen.dynamicanalyzer.protocol.p40.ApplicationInst40;
import org.tizen.dynamicanalyzer.protocol.p40.FunctionBodyInstrument40;
import org.tizen.dynamicanalyzer.protocol.p40.FunctionBodyInstrumentStep40;
import org.tizen.dynamicanalyzer.protocol.p40.FunctionBodyInstrumentVariable40;
import org.tizen.dynamicanalyzer.protocol.p40.FunctionInst40;
import org.tizen.dynamicanalyzer.protocol.p40.ProtocolConfig40;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.swap.communicator.SwapErrorCode;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveDataManager;
import org.tizen.dynamicanalyzer.ui.interactive.model.InteractiveInfo;
import org.tizen.dynamicanalyzer.ui.interactive.model.VAR_TYPE;
import org.tizen.dynamicanalyzer.util.Logger;

public class Communicator40
extends Communicator30 {
    public Communicator40(BaseCommunicator parent) {
        super(parent);
    }

    @Override
    public DAResult connect() {
        int localPort = this.parent.getLocalPort();
        DAResult result = this.createDataSocket(localPort);
        if (!result.isSuccess()) {
            Logger.warning((Object)result.toString());
            return new DAResult(DAResult.ErrorCode.ERR_DATA_SOCKET_CREATION_FAIL);
        }
        result = this.sendTargetInfoMessage(null);
        if (!result.isSuccess()) {
            Logger.warning((Object)result.toString());
            return result;
        }
        try {
            result = this.sendProbeMapMessage(null);
            if (!result.isSuccess()) {
                Logger.warning((Object)result.toString());
                return result;
            }
        }
        catch (UnsupportedProtocolException unsupportedProtocolException) {
            this.parent.getDevice().getDeviceStatusInfo().setApiNameMap(this.getApiMap());
        }
        result = this.sendConfigurationMessage(null);
        if (result.isSuccess()) {
            this.parent.getDevice().setConfigSuccess(true);
        } else {
            Logger.warning((Object)result.toString());
        }
        return result;
    }

    @Override
    public DAResult sendConfigurationMessage(IProgress progress) {
        ProtocolSerializer ps = new ProtocolSerializer();
        ps.setMessageID(4);
        Set<FlatFeature> selectedFeatures = SettingDataManager.INSTANCE.getSelectedFlatFeatureSet();
        Set<FlatPreferences> selectedPreferences = SettingDataManager.INSTANCE.getSelectedPreferenceSet();
        byte[] featureFlag = ProtocolConfig40.getFlatFeatureFlagValue(selectedFeatures, selectedPreferences);
        ps.putByteArray(featureFlag);
        int systemPeriod = SettingDataManager.INSTANCE.getOptionsPreferencesValue(FlatPreferences.SYSTEM_SAMPLING_RATE);
        int samplingPeriod = SettingDataManager.INSTANCE.getOptionsPreferencesValue(FlatPreferences.FUNCTION_SAMPLING_RATE);
        ps.putInt(systemPeriod);
        ps.putInt(samplingPeriod);
        byte[] msg = ps.toByteArray();
        AckMessage result = this.parent.handleControlMessage(msg);
        if (result != null && result.isSuccess() && result.isCorrectID(4100)) {
            return new DAResult(DAResult.ErrorCode.SUCCESS);
        }
        return new DAResult(DAResult.ErrorCode.ERR_CONFIG_FAILED);
    }

    @Override
    public DAResult sendKeepAliveMessage(IProgress progress) {
        ProtocolSerializer ps = new ProtocolSerializer();
        ps.setMessageID(15);
        byte[] msg = ps.toByteArray();
        AckMessage result = this.parent.handleControlMessage(msg);
        if (result != null && result.isCorrectID(4111) && result.isSuccess()) {
            return new DAResult(DAResult.ErrorCode.SUCCESS);
        }
        return new DAResult(DAResult.ErrorCode.ERR_KEEP_ALIVE);
    }

    @Override
    public DAResult sendScreenshotMessage(IProgress progress) {
        ProtocolSerializer ps = new ProtocolSerializer();
        ps.setMessageID(16);
        byte[] msg = ps.toByteArray();
        AckMessage result = this.parent.handleControlMessage(msg, 0);
        if (result != null && result.isSuccess() && result.isCorrectID(4112)) {
            return new DAResult(DAResult.ErrorCode.SUCCESS);
        }
        return new DAResult(DAResult.ErrorCode.ERR_SCREENSHOT_GET_FAIL);
    }

    @Override
    public DAResult sendProbeMapMessage(IProgress progress) throws UnsupportedProtocolException {
        ProtocolSerializer ps = new ProtocolSerializer();
        ps.setMessageID(10);
        byte[] msg = ps.toByteArray();
        AckMessage result = this.parent.handleControlMessage(msg, 0);
        if (result != null && result.isSuccess() && result.isCorrectID(4106)) {
            byte[] payload = result.getPayload();
            if (payload != null) {
                ProtocolParser parser = new ProtocolParser(payload);
                parser.getInt();
                int countOfApi = parser.getInt();
                if (countOfApi > 0) {
                    TreeMap<Integer, String> apiNameMap = new TreeMap<Integer, String>();
                    apiNameMap.put(0, "Unknown API");
                    int i = 0;
                    while (i < countOfApi) {
                        int index = parser.getInt();
                        String apiName = parser.getString();
                        apiNameMap.put(index, apiName);
                        ++i;
                    }
                    this.parent.getDevice().getDeviceStatusInfo().setApiNameMap(Collections.unmodifiableMap(apiNameMap));
                }
            }
            return new DAResult(DAResult.ErrorCode.SUCCESS);
        }
        return new DAResult(DAResult.ErrorCode.ERR_MSG_SEND_FAIL);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean serializeApplicationInst(ProtocolSerializer ps) {
        DeviceInfo dev = this.parent.getDevice();
        String pkgID = Global.getCurrentApplication().getPackageId();
        PackageInfo pkgInfo = dev.getPkgInfoByPkgID(pkgID);
        List<AppInfo> apps = pkgInfo.getAppInfos();
        ArrayList<ApplicationInst40> appInstList = new ArrayList<ApplicationInst40>();
        if (pkgInfo.getPackageId().equals("_Running process_")) {
            Map<Integer, String> map = apps.get(0).getRunningProcesses();
            if (map != null && map.size() > 0) {
                for (Map.Entry<Integer, String> entry : map.entrySet()) {
                    BinaryInfo binInfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(entry.getValue());
                    String temppath = binInfo.getTempBinaryPath();
                    if (temppath == null) continue;
                    ApplicationInst40 appInst = new ApplicationInst40();
                    appInst.setApplicationType(2);
                    appInst.setApplicationID(entry.getKey().toString());
                    appInst.setExecutablePath(entry.getValue());
                    List<AddrSymbolPair> symbols = apps.get(0).getSymbols(temppath);
                    appInst.setFunctionInstList(this.getFunctionInstList(symbols));
                    appInstList.add(appInst);
                }
            }
        } else if (pkgInfo.getPackageId().equals("_Without executable_")) {
            ApplicationInst40 applicationInst40 = new ApplicationInst40();
            applicationInst40.setApplicationType(2);
            applicationInst40.setApplicationID("");
            applicationInst40.setExecutablePath("");
            appInstList.add(applicationInst40);
        } else {
            void var7_10;
            boolean bl = false;
            while (var7_10 < apps.size()) {
                BinaryInfo binInfo;
                String temppath;
                AppInfo app = apps.get((int)var7_10);
                if (!ApplistManager.isInBlackList(app) && (temppath = (binInfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(app.getExecBinaryPath())).getTempBinaryPath()) != null) {
                    ApplicationInst40 appInst = new ApplicationInst40();
                    List<AddrSymbolPair> symbols = app.getSymbols(temppath);
                    List<ISerializable> functionInstList = this.getFunctionInstList(symbols, appInst);
                    if (!functionInstList.isEmpty()) {
                        if (Global.isGUIMode()) {
                            this.addCheckpointsToInstList(functionInstList);
                        }
                        if (var7_10 == false) {
                            String appType = app.getInfo(AppInfo.PROPERTY.APPTYPE.index);
                            if (appType.contains("c++")) {
                                appInst.setApplicationType(1);
                                appInst.setApplicationID(app.getAppID());
                            } else if (appType.contains("webapp")) {
                                appInst.setApplicationType(4);
                                appInst.setApplicationID(app.getAppID());
                            } else if (appType.contains("capp")) {
                                appInst.setApplicationType(1);
                                appInst.setApplicationID(app.getAppID());
                            } else {
                                appInst.setApplicationType(3);
                                appInst.setApplicationID("");
                            }
                        } else {
                            appInst.setApplicationType(2);
                            appInst.setApplicationID("");
                        }
                        appInst.setExecutablePath(app.getExecPath());
                        appInst.setFunctionInstList(functionInstList);
                        appInstList.add(appInst);
                    }
                }
                ++var7_10;
            }
        }
        ps.putInt(appInstList.size());
        for (ISerializable iSerializable : appInstList) {
            iSerializable.serialize(ps);
        }
        return appInstList.size() != 0;
    }

    private void addCheckpointsToInstList(List<ISerializable> functionInstList) {
        List<FunctionBodyInstrument40> fbiList = this.getFBIList(InteractiveDataManager.getInstance().getVariableInfoList());
        Logger.debug((Object)("fbiList.size() : " + fbiList.size()));
        int i = 0;
        while (i < fbiList.size()) {
            FunctionInst40 functionInst = new FunctionInst40();
            functionInst.setAddr(fbiList.get(i).getAddress());
            functionInst.setType((byte)1);
            functionInst.setFBI(fbiList.get(i));
            functionInstList.add(functionInst);
            ++i;
        }
    }

    @Override
    protected List<ISerializable> getFunctionInstList(List<AddrSymbolPair> symbols) {
        ArrayList<ISerializable> functionInstList = new ArrayList<ISerializable>();
        int size = symbols == null ? 0 : symbols.size();
        int i = 0;
        while (i < size) {
            AddrSymbolPair addrSymbol = symbols.get(i);
            String symbol = addrSymbol.getSymbol();
            if (!ProtocolFilter30.isInBlacklistFunctionInst(symbol)) {
                FunctionInst40 functionInst = new FunctionInst40();
                functionInst.setAddr(addrSymbol.getAddr());
                functionInst.setArgs(this.getFunctionArgs(symbol));
                functionInst.setType((byte)0);
                functionInstList.add(functionInst);
            }
            ++i;
        }
        return functionInstList;
    }

    protected List<ISerializable> getFunctionInstList(List<AddrSymbolPair> symbols, ApplicationInst40 appInst) {
        boolean bFoundMain = false;
        ArrayList<ISerializable> functionInstList = new ArrayList<ISerializable>();
        int size = symbols == null ? 0 : symbols.size();
        int i = 0;
        while (i < size) {
            AddrSymbolPair addrSymbol = symbols.get(i);
            String symbol = addrSymbol.getSymbol();
            if (!bFoundMain && symbol.equals("main")) {
                appInst.setMainAddress(addrSymbol.getAddr());
                bFoundMain = true;
            }
            if (!ProtocolFilter30.isInBlacklistFunctionInst(symbol)) {
                FunctionInst40 functionInst = new FunctionInst40();
                functionInst.setAddr(addrSymbol.getAddr());
                functionInst.setArgs(this.getFunctionArgs(symbol));
                functionInst.setType((byte)0);
                functionInstList.add(functionInst);
            }
            ++i;
        }
        return functionInstList;
    }

    protected List<FunctionBodyInstrument40> getFBIList(List<InteractiveInfo> iInfos) {
        LinkedHashMap<Long, FunctionBodyInstrument40> fbiMap = new LinkedHashMap<Long, FunctionBodyInstrument40>();
        for (InteractiveInfo info : iInfos) {
            switch (info.getCheckLocation()) {
                case 1: 
                case 2: {
                    FunctionBodyInstrument40 fbi = this.getFunctionBodyInstrument(fbiMap, info.getSourceLineAddress(info.getCheckLocation()));
                    this.makeFBIVariables(info, info.getCheckLocation(), fbi);
                    break;
                }
                case 3: {
                    FunctionBodyInstrument40 beforeFBI = this.getFunctionBodyInstrument(fbiMap, info.getSourceLineAddress(1));
                    FunctionBodyInstrument40 afterFBI = this.getFunctionBodyInstrument(fbiMap, info.getSourceLineAddress(2));
                    this.makeFBIVariables(info, 1, beforeFBI);
                    this.makeFBIVariables(info, 2, afterFBI);
                    break;
                }
                default: {
                    Logger.error((Object)"Impossible case!!");
                }
            }
        }
        ArrayList<FunctionBodyInstrument40> fbiList = new ArrayList<FunctionBodyInstrument40>();
        fbiList.addAll(fbiMap.values());
        return fbiList;
    }

    protected FunctionBodyInstrument40 getFunctionBodyInstrument(Map<Long, FunctionBodyInstrument40> map, long address) {
        FunctionBodyInstrument40 fbi = map.get(address);
        if (fbi == null) {
            fbi = new FunctionBodyInstrument40(address);
            map.put(address, fbi);
        }
        return fbi;
    }

    protected void makeFBIVariables(InteractiveInfo info, int checkLocation, FunctionBodyInstrument40 fbi) {
        long registerOffset = info.getRegisterOffset();
        byte registerNum = (byte)info.getRegisterID();
        int dataSize = info.getByteSize();
        if (info.isPointerArray()) {
            dataSize = info.getPointerSize() * info.getArrayCount();
        } else if (info.isArray()) {
            dataSize *= info.getArrayCount();
        } else if (info.isString()) {
            dataSize = 0;
        }
        FunctionBodyInstrumentVariable40 targetVariable = new FunctionBodyInstrumentVariable40(info.getVariableID(checkLocation), registerOffset, registerNum, dataSize);
        this.makeFBISteps(info, targetVariable);
        fbi.addVariable(targetVariable);
        if (info.getType() == VAR_TYPE.STRUCT) {
            List<InteractiveInfo> children = info.getChildren();
            int i = 0;
            while (i < children.size()) {
                InteractiveInfo child = children.get(i);
                if (child.isString()) {
                    FunctionBodyInstrumentVariable40 childVariable = new FunctionBodyInstrumentVariable40(child.getVariableID(checkLocation), registerOffset, registerNum, 0);
                    this.makeFBISteps(child, childVariable);
                    fbi.addVariable(childVariable);
                }
                ++i;
            }
        }
    }

    protected void makeFBISteps(InteractiveInfo info, FunctionBodyInstrumentVariable40 variable) {
        InteractiveInfo cursorInfo = info;
        while (cursorInfo != null) {
            InteractiveInfo parentInfo;
            int pointerOrder = cursorInfo.getPointerOrder();
            if (info.isPointerArray()) {
                pointerOrder = 0;
            }
            if (cursorInfo == info) {
                FunctionBodyInstrumentStep40 step = new FunctionBodyInstrumentStep40((byte)pointerOrder, 0L);
                variable.addStep(step);
            }
            if ((parentInfo = cursorInfo.getParent()) != null) {
                FunctionBodyInstrumentStep40 step = new FunctionBodyInstrumentStep40((byte)parentInfo.getPointerOrder(), cursorInfo.getOffset());
                variable.addStep(step);
            }
            cursorInfo = parentInfo;
        }
    }

    @Override
    public DAResult sendBinaryInfoMessage(IProgress progress, List<String> binPaths) {
        ProtocolSerializer ps = new ProtocolSerializer();
        ps.setMessageID(5);
        int binCount = binPaths.size();
        ps.putInt(binCount);
        int i = 0;
        while (i < binCount) {
            String targetPath = binPaths.get(i);
            ps.putString(targetPath);
            ++i;
        }
        byte[] msg = ps.toByteArray();
        AckMessage result = this.parent.handleControlMessage(msg);
        if (result != null && result.isCorrectID(4101) && (result.isSuccess() || result.getReturnCode() == SwapErrorCode.ERR_WRONG_MESSAGE_DATA.getErrorNumber() && result.getPayloadLength() > 4)) {
            return this.parseBinaryInfo(result.getPayload());
        }
        return new DAResult(DAResult.ErrorCode.ERR_BIN_INFO_GET_FAIL);
    }

    protected DAResult parseBinaryInfo(byte[] payload) {
        DAResult ret = new DAResult(DAResult.ErrorCode.SUCCESS);
        StringBuffer detailErrorMsg = new StringBuffer();
        ProtocolParser parser = new ProtocolParser(payload);
        parser.getInt();
        DeviceInfo curDevice = this.parent.getDevice();
        int count = parser.getInt();
        int i = 0;
        while (i < count) {
            String targetPath = parser.getString();
            BinaryInfo binInfo = curDevice.getDeviceStatusInfo().getBinaryInfo(targetPath);
            int binaryType = parser.getInt();
            String localBinaryPath = parser.getString().trim();
            String md5sum = parser.getString();
            binInfo.setType(binaryType);
            binInfo.setMd5sumValue(md5sum);
            binInfo.setTempBinaryPath(null);
            if (binaryType < 0) {
                if (detailErrorMsg.length() != 0) {
                    detailErrorMsg.append("\n");
                }
                if (binaryType == -1) {
                    detailErrorMsg.append(String.valueOf(UserErrorWarningLabels.ERROR_NONEXIST_BINARY) + "(" + targetPath + ")");
                } else if (binaryType == -2) {
                    detailErrorMsg.append(String.valueOf(UserErrorWarningLabels.ERROR_NONELF_BINARY) + "(" + targetPath + ")");
                }
                ret = new DAResult(DAResult.ErrorCode.ERR_BIN_INFO_GET_FAIL);
            } else {
                DAResult result = this.checkDirtyOfBinary(binInfo, localBinaryPath);
                if (!result.isSuccess()) {
                    ret = result;
                }
            }
            ++i;
        }
        if (ret.equals((Object)DAResult.ErrorCode.ERR_BIN_INFO_GET_FAIL)) {
            ret.setDetailMessage(detailErrorMsg.toString());
        }
        return ret;
    }

    @Override
    public DAResult sendRealPathMessage(IProgress progress, String path) throws InterruptedException, UnsupportedProtocolException {
        ProtocolSerializer ps = new ProtocolSerializer();
        ps.setMessageID(32);
        ps.putString(path);
        byte[] msg = ps.toByteArray();
        AckMessage result = this.parent.handleControlMessage(msg, 0);
        if (result != null && result.isSuccess() && result.isCorrectID(4128)) {
            byte[] payload = result.getPayload();
            if (payload != null) {
                ProtocolParser parser = new ProtocolParser(payload);
                parser.getInt();
                BinaryInfo binInfo = this.parent.getDevice().getDeviceStatusInfo().getBinaryInfo(path);
                binInfo.setRealPath(parser.getString());
                return new DAResult(DAResult.ErrorCode.SUCCESS);
            }
            Logger.error((Object)"wrong format ACK for real path message");
            return new DAResult(DAResult.ErrorCode.ERR_WRONG_MESSAGE_FORMAT);
        }
        return new DAResult(DAResult.ErrorCode.ERR_MSG_SEND_FAIL);
    }
}

