/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.setting;

import java.util.HashMap;
import java.util.Map;
import org.tizen.dynamicanalyzer.nl.ConfigureLabels;
import org.tizen.dynamicanalyzer.setting.FeatureData;

public enum Feature {
    SYSTEM(1, ConfigureLabels.FEATURE_NAME_SYSTEM),
    SYSTEM_CPU(2, ConfigureLabels.FEATURE_NAME_SYSTEM_CPU),
    SYSTEM_PROCESS(3, ConfigureLabels.FEATURE_NAME_SYSTEM_PROCESS),
    SYSTEM_MEMORY(4, ConfigureLabels.FEATURE_NAME_SYSTEM_MEMORY),
    SYSTEM_ALL_PROCESSES(5, ConfigureLabels.FEATURE_NAME_SYSTEM_PROCESSES),
    SYSTEM_DISK(6, ConfigureLabels.FEATURE_NAME_SYSTEM_DISK),
    SYSTEM_NETWORK(7, ConfigureLabels.FEATURE_NAME_SYSTEM_NETWORK),
    SYSTEM_DEVICE(8, ConfigureLabels.FEATURE_NAME_SYSTEM_DEVICE),
    SYSTEM_ENERGY(9, ConfigureLabels.FEATURE_NAME_SYSTEM_ENERGY),
    FUNCTION_PROFILING(100, ConfigureLabels.FEATURE_NAME_FUNCTION_PROFILING),
    FUNCTION_SAMPLING(101, ConfigureLabels.FEATURE_NAME_FUNCTION_SAMPLING),
    MEMORY_ALLOCATION(102, ConfigureLabels.FEATURE_NAME_MEMORY_ALLOCATION),
    APPLICATION_STARTUP(103, ConfigureLabels.FEATURE_NAME_APPLICATION_STARTUP),
    FILE_ANALYSIS(200, ConfigureLabels.FEATURE_NAME_FILE),
    THREAD_ANALYSIS(201, ConfigureLabels.FEATURE_NAME_THREAD),
    NETWORK_ANALYSIS(202, ConfigureLabels.FEATURE_NAME_NETWORK),
    OPENGL_ANALYSIS(203, ConfigureLabels.FEATURE_NAME_OPENGLES),
    UI_EVENT_ANALYSIS(204, ConfigureLabels.FEATURE_NAME_UI_EVENT),
    CONTEXT_SWITCH_ANALYSIS(205, ConfigureLabels.FEATURE_NAME_CONTEXT_SWITCH),
    UI_HIERARCHY_ANALYSIS(206, ConfigureLabels.FEATURE_NAME_UI_HIERARCHY),
    INTERNAL_PROBE(300, ConfigureLabels.FEATURE_NAME_INSIDE_THE_PLATFORM),
    INTERNAL_PROBE_MEMORY(301, ConfigureLabels.FEATURE_NAME_MEMORY_ALLOCATION),
    INTERNAL_PROBE_FILE(302, ConfigureLabels.FEATURE_NAME_INSIDE_THE_PLATFORM_FILE),
    INTERNAL_PROBE_THREAD(303, ConfigureLabels.FEATURE_NAME_INSIDE_THE_PLATFORM_THREAD),
    INTERNAL_PROBE_NETWORK(304, ConfigureLabels.FEATURE_NAME_INSIDE_THE_PLATFORM_NETWORK),
    INTERNAL_PROBE_OPENGL(305, ConfigureLabels.FEATURE_NAME_INSIDE_THE_PLATFORM_OPENGL),
    SYSCALL(500, ConfigureLabels.FEATURE_NAME_SYSTEM_CALL),
    SYSCALL_FILE(501, ConfigureLabels.FEATURE_NAME_SYSTEM_CALL_FILE),
    SYSCALL_IPC(502, ConfigureLabels.FEATURE_NAME_SYSTEM_CALL_IPC),
    SYSCALL_PROCESS(503, ConfigureLabels.FEATURE_NAME_SYSTEM_CALL_PROCESS),
    SYSCALL_SIGNAL(504, ConfigureLabels.FEATURE_NAME_SYSTEM_CALL_SIGNAL),
    SYSCALL_NETWORK(505, ConfigureLabels.FEATURE_NAME_SYSTEM_CALL_NETWORK),
    SYSCALL_DESC(506, ConfigureLabels.FEATURE_NAME_SYSTEM_CALL_DESC),
    SYSTEM_SAMPLING_RATE(1000, ConfigureLabels.FEATURE_DETAIL_VALUE_SYSTEM_SAMPLING_RATE),
    FUNCTION_SAMPLING_RATE(1001, ConfigureLabels.FEATURE_DETAIL_VALUE_FUNCTION_SAMPLING_RATE),
    SCREENSHOT_ON_SCENE_TRANSITION(5000, ConfigureLabels.FEATURE_DETAIL_VALUE_SCREENSHOT_ON_SCENE_TRANSITION),
    SCREENSHOT_PERIODICALLY(5001, ConfigureLabels.FEATURE_DETAIL_VALUE_SCREENSHOT_PERIODICALLY),
    RECORDING(5002, ConfigureLabels.FEATURE_NAME_RECORDING),
    AUTO_STOP(5003, ConfigureLabels.SETTING_OPTION_AUTO_STOP);

    private static final Map<Integer, Feature> featureByIndex;
    private static final Map<String, Feature> featureByName;
    private int index = 0;
    private String name = null;
    private FeatureData data = null;

    static {
        featureByIndex = new HashMap<Integer, Feature>();
        featureByName = new HashMap<String, Feature>();
        Feature[] featureArray = Feature.values();
        int n = featureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Feature feature = featureArray[n2];
            int index = feature.getIndex();
            String name = feature.getName();
            featureByIndex.put(index, feature);
            featureByName.put(name, feature);
            ++n2;
        }
    }

    private Feature(int index, String name) {
        this.index = index;
        this.name = name;
        this.data = new FeatureData(this);
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public FeatureData getData() {
        return this.data;
    }

    public static Feature getFeature(String name) {
        return featureByName.get(name);
    }

    public static Feature getFeature(int featureIndex) {
        return featureByIndex.get(featureIndex);
    }
}

