/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.communicator;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DALimit;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.control.DataThread;
import org.tizen.dynamicanalyzer.control.SideWorker;
import org.tizen.dynamicanalyzer.handlers.CommandAction;
import org.tizen.dynamicanalyzer.model.DATime;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.logparser.MessageParser;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.LogDataFactory;
import org.tizen.dynamicanalyzer.util.Logger;

public class DataChannelThread
extends DataThread<Object> {
    private static final DataChannelThread instance = new DataChannelThread();
    private static final int RECEIVE_BUF_SIZE = 0x200000;
    private static final int LOCAL_BUF_SIZE = 1024;
    private final Object waitObject = new Object();
    private boolean dropMode = false;
    private Socket dataSocket = null;
    private Protocol protocolVersion = Protocol.VERSION_UNKNOWN;
    private int socketTimeout = -1;
    private STATE state = STATE.INITIALIZED;

    public static DataChannelThread getInstance() {
        return instance;
    }

    @Override
    protected String getThreadName() {
        return "Data channel recv thread";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean workAfterStart() {
        Object object = this.waitObject;
        synchronized (object) {
            try {
                while (this.state == STATE.INITIALIZED) {
                    this.waitObject.wait();
                }
            }
            catch (InterruptedException e) {
                Logger.exception((Throwable)e);
            }
        }
        return this.state == STATE.ACTIVATED;
    }

    @Override
    protected boolean workAfterStopNormal() {
        return true;
    }

    @Override
    protected boolean workAfterStopForced() {
        return true;
    }

    @Override
    protected void resetBeforeStart() {
        this.state = STATE.INITIALIZED;
        this.dropMode = false;
        this.dataSocket = Global.getCurrentDeviceInfo().getCommunicator().getSubCommunicator().getDataSocket(0);
        this.protocolVersion = Protocol.getVersion(Global.getCurrentDeviceInfo().getCommunicator().getProtocolVersion());
        this.clearSocketReceiveBuffer();
    }

    @Override
    protected void clearAfterStop() {
        this.clearSocketReceiveBuffer();
        this.dataSocket = null;
    }

    private void changeToDropMode() {
        this.socketTimeout = 3000;
        this.dropMode = true;
    }

    private void clearSocketReceiveBuffer() {
        try {
            int readSize;
            if (this.dataSocket == null) {
                return;
            }
            this.dataSocket.setSoTimeout(10);
            InputStream inputStream = this.dataSocket.getInputStream();
            byte[] buffer = new byte[1024];
            while ((readSize = inputStream.read(buffer, 0, 1024)) != -1) {
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            Logger.debug((Object)"data socket cleared");
        }
        catch (SocketException e) {
            Logger.exception((Throwable)e);
        }
        catch (IOException e) {
            Logger.exception((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block37: {
            if (this.dataSocket != null && this.protocolVersion != Protocol.VERSION_UNKNOWN) break block37;
            this.pushEOQ();
            if (AnalyzerManager.isDataSocketClosed()) {
                this.notifyStopWork(new DAResult(DAResult.ErrorCode.ERR_DATA_SOCKET_CLOSED), false);
            } else {
                this.notifyStopWork(new DAResult(DAResult.ErrorCode.SUCCESS), true);
            }
            var12_1 = this.waitObject;
            synchronized (var12_1) {
                this.state = STATE.TERMINATED;
                this.waitObject.notifyAll();
            }
            return;
        }
        try {
            inputStream = null;
            header = new byte[20];
            buffer = new byte[1024];
            prevSeq = -1L;
            curThread = Thread.currentThread();
            try {
                this.socketTimeout = 30000;
                this.dataSocket.setSoTimeout(1000);
                this.dataSocket.setReceiveBufferSize(0x200000);
                inputStream = new BufferedInputStream(this.dataSocket.getInputStream());
                var9_9 = this.waitObject;
                synchronized (var9_9) {
                    this.state = STATE.ACTIVATED;
                    this.waitObject.notifyAll();
                    // MONITOREXIT @DISABLED, blocks:[2, 3, 4, 10] lbl36 : MonitorExitStatement: MONITOREXIT : var9_9
                    if (true) ** GOTO lbl69
                }
                do {
                    if (!this.dropMode) {
                        if (this.readByte(inputStream, header, 20) < 0) {
                            AnalyzerManager.setDataSocketClosed(true);
                        } else {
                            log = LogDataFactory.createInstance(header);
                            log.setProtocolVersion(this.protocolVersion);
                            curSeq = log.getSeq();
                            if (prevSeq > curSeq) {
                                Global.getProject().incSeqRotation();
                            }
                            prevSeq = curSeq;
                            log.adjustSeq(Global.getProject().getSeqRotation());
                            payloadsize = log.getPayloadSize();
                            if (payloadsize < 0 || payloadsize > DALimit.MAX_PAYLOAD_SIZE) {
                                this.notifyStopWork(new DAResult(DAResult.ErrorCode.ERR_WRONG_MESSAGE_FORMAT), false);
                                this.changeToDropMode();
                                this.pushEOQ();
                                continue;
                            }
                            if (this.readByte(inputStream, log.getPayload(), payloadsize) < 0) {
                                AnalyzerManager.setDataSocketClosed(true);
                            } else if (!MessageParser.getInstance().pushData(log)) {
                                Logger.error((Object)"failed to insert log to message parser");
                            } else if (!this.preProcessMessage(log)) continue;
                        }
                    } else {
                        if (this.readByte(inputStream, buffer, 1024) >= 0) continue;
                        AnalyzerManager.setDataSocketClosed(true);
                    }
                    break;
lbl69:
                    // 4 sources

                } while (this.testThread(curThread));
            }
            catch (EndOfTraceException v2) {
                Logger.debug((Object)"there is no more data to read");
            }
            catch (SocketTimeoutException e) {
                this.notifyStopWork(new DAResult(DAResult.ErrorCode.ERR_DISCONNECTED), false);
                Logger.exception((Throwable)e);
            }
            catch (InterruptedIOException e) {
                Logger.exception((Throwable)e);
            }
            catch (IOException e) {
                AnalyzerManager.setDataSocketClosed(true);
                Logger.exception((Throwable)e);
            }
        }
        catch (Throwable var11_15) {
            this.pushEOQ();
            if (AnalyzerManager.isDataSocketClosed()) {
                this.notifyStopWork(new DAResult(DAResult.ErrorCode.ERR_DATA_SOCKET_CLOSED), false);
            } else {
                this.notifyStopWork(new DAResult(DAResult.ErrorCode.SUCCESS), true);
            }
            var12_2 = this.waitObject;
            synchronized (var12_2) {
                this.state = STATE.TERMINATED;
                this.waitObject.notifyAll();
            }
            throw var11_15;
        }
        this.pushEOQ();
        if (AnalyzerManager.isDataSocketClosed()) {
            this.notifyStopWork(new DAResult(DAResult.ErrorCode.ERR_DATA_SOCKET_CLOSED), false);
        } else {
            this.notifyStopWork(new DAResult(DAResult.ErrorCode.SUCCESS), true);
        }
        var12_3 = this.waitObject;
        synchronized (var12_3) {
            this.state = STATE.TERMINATED;
            this.waitObject.notifyAll();
        }
    }

    private int readByte(InputStream input, byte[] buffer, int length) throws IOException, EndOfTraceException {
        int toRead = length;
        int readSize = 0;
        int timeoutValue = 0;
        boolean stopControlChannel = false;
        while (toRead > 0) {
            try {
                readSize = input.read(buffer, length - toRead, toRead);
                toRead -= readSize;
                if (readSize == -1) break;
                timeoutValue = 0;
            }
            catch (SocketTimeoutException e) {
                timeoutValue += 1000;
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedIOException();
                }
                if (AnalyzerManager.isStopAckArrived()) {
                    if (stopControlChannel) {
                        throw new EndOfTraceException();
                    }
                    stopControlChannel = true;
                }
                if (timeoutValue < this.socketTimeout) continue;
                throw e;
            }
        }
        if (readSize < 0) {
            return readSize;
        }
        return length - toRead;
    }

    private boolean checkContinuity(long prevSeq, long curSeq) {
        if (curSeq != prevSeq + 1L) {
            Logger.error((String)"Contunuity failed (%d) (%d)", (Object[])new Object[]{prevSeq, curSeq});
            return false;
        }
        return true;
    }

    private boolean pushEOQ() {
        return MessageParser.getInstance().pushData(LogData.END_OF_QUEUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean preProcessMessage(LogData log) {
        int msgID = log.getMsgID();
        if (msgID == 1) {
            Object object = AnalyzerManager.waitStartAck;
            synchronized (object) {
                Global.getProject().checkAndSetProfilingStartTime(new DATime(log.getSec(), log.getNano()));
                AnalyzerManager.waitStartAck.notifyAll();
            }
            Global.getProject().incActiveProcessCount();
        } else if (msgID == 2) {
            Global.getProject().decActiveProcessCount();
            if (Global.getProject().getActiveProcessCount() == 0) {
                AnalyzerManager.setTerminateMsgArrived(true);
            }
        }
        return AnalyzerManager.isTerminateMsgArrived() && AnalyzerManager.isStopAckArrived();
    }

    private void notifyStopWork(final DAResult result, final boolean stopFromTarget) {
        SideWorker.INSTANCE.offerWork(new Runnable(){

            @Override
            public void run() {
                if (DAState.getCurrentState() == DAState.PREPARE_START) {
                    while (!DAState.isRunning()) {
                        if (DAState.isStartable()) {
                            return;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            Logger.exception((Throwable)e);
                            break;
                        }
                    }
                }
                CommandAction.stopTrace(result, stopFromTarget);
            }
        });
    }

    private static class EndOfTraceException
    extends Exception {
        private static final long serialVersionUID = -1012165582483739981L;

        private EndOfTraceException() {
        }
    }

    private static enum STATE {
        INITIALIZED,
        ACTIVATED,
        TERMINATED;

    }
}

