/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.common.explorer;

import java.util.HashMap;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.ui.common.explorer.DAFileTreeExplorerRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.DAGrid;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableEmptyCellRenderer;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableHeaderRenderer;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.sdblib.service.FileEntryType;

public class DAFileTreeExplorer
extends Composite {
    protected Grid table;
    private HashMap<String, Boolean> checkedChild = new HashMap();

    public DAFileTreeExplorer(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.table = new DAGrid(this, 2820);
        this.table.setLinesVisible(false);
        this.table.setBackground(ColorResources.TABLE_CONTENTS_NORMAL);
        this.table.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
        this.table.setFont(FontResources.TABLE_CELL_FONT);
        this.setColumns();
        this.table.setEmptyCellRenderer((GridCellRenderer)new DATableEmptyCellRenderer());
        this.table.setItemHeight(18);
        this.table.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                GridItem item = (GridItem)event.item;
                FileEntry entry = (FileEntry)item.getData();
                if (entry == null) {
                    return;
                }
                String path = entry.getFullPath();
                if (DAFileTreeExplorer.this.checkedChild.get(path) == null) {
                    FileEntry[] children = entry.getChildren();
                    if (children.length > 0) {
                        int i = 0;
                        while (i < children.length) {
                            FileEntry child = children[i];
                            if (child.getType() != FileEntryType.Link && child.getType() != FileEntryType.DirectoryLink) {
                                GridItem childItem = new GridItem(item, 0);
                                childItem.setText(child.getName());
                                childItem.setData((Object)child);
                            }
                            ++i;
                        }
                    }
                    DAFileTreeExplorer.this.checkedChild.put(path, true);
                }
            }
        });
        this.table.addListener(18, new Listener(){

            public void handleEvent(Event event) {
                GridItem item = (GridItem)event.item;
                item.hasChildren();
            }
        });
    }

    public void setColumns() {
        GridColumn column = new GridColumn(this.table, 0);
        column.setCellRenderer((GridCellRenderer)new DAFileTreeExplorerRenderer());
        column.setHeaderRenderer((GridHeaderRenderer)new DATableHeaderRenderer());
        column.setText("Node");
        column.setWidth(500);
        column.setTree(true);
    }

    public void makeTree() {
        DeviceInfo selectedDevice = Global.getCurrentDeviceInfo();
        if (selectedDevice == null) {
            return;
        }
        IDevice device = Global.getCurrentDeviceInfo().getIDevice();
        FileEntry root = device.getRoot();
        GridItem item = new GridItem(this.table, 0);
        String name = DAFileTreeExplorer.getDeviceSerialWithName(root);
        item.setText(name);
        item.setData((Object)root);
        this.table.update();
    }

    public static String getDeviceSerialWithName(FileEntry entry) {
        return DAFileTreeExplorer.combineSerialWithName(entry.getDevice().getSerialNumber(), entry.getDevice().getDeviceName());
    }

    private static String combineSerialWithName(String serial, String name) {
        return String.format("%s (%s)", serial, name);
    }

    public FileEntry getSelection() {
        GridItem[] selections = this.table.getSelection();
        if (selections.length > 0) {
            GridItem selection = selections[0];
            FileEntry entry = (FileEntry)selection.getData();
            if (!entry.isDirectory() && !entry.isRoot()) {
                return entry;
            }
            return null;
        }
        return null;
    }

    public Grid getTree() {
        return this.table;
    }
}

