/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.file;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.nl.FilePageLabels;
import org.tizen.dynamicanalyzer.project.ProcessInformation;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.ui.file.FileChartBoard;
import org.tizen.dynamicanalyzer.ui.file.FilePage;
import org.tizen.dynamicanalyzer.ui.file.manager.FileDataManager;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.logparser.LifecycleLogParser;
import org.tizen.dynamicanalyzer.ui.toolbar.DAToolBarCustomCombo;
import org.tizen.dynamicanalyzer.ui.toolbar.ToolBarComboListener;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.button.IDACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotMarker;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardSelectionListener;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.scale.DAScaleSelectionListener;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;

public class FileChartView
extends DAViewComposite {
    public static final int FILE_CHART_HEIGHT = 40;
    private final Composite contents;
    private FileChartBoard fileChartBoard;
    private final StackLayout stackLayout;
    private DAChartBoardItem lastSelectedItemForSummary = null;
    private DAToolBarCustomCombo processCombo;
    private final RangeDataManager rangeDataManager = RangeDataManager.getInstance();
    private FileDataManager chartManager = FileDataManager.getInstance();

    public FileChartView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        AnalyzerUtil.setLatestTraceMode(FilePage.pageID, true);
        this.setTitle(FilePageLabels.FILE_CHART_FILE);
        this.contents = this.getContentArea();
        this.contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        this.stackLayout = new StackLayout();
        this.contents.setLayout((Layout)this.stackLayout);
        this.fileChartBoard = new FileChartBoard(this.contents, FilePageLabels.FILE_CHART_FILE);
        this.fileChartBoard.setNameFont(FontResources.CHART_NAME_FONT);
        this.fileChartBoard.addSelectionListener(new DAChartBoardSelectionListener(){

            public void handleSelectionEvent(DAChartBoardItem item) {
                FileChartView.this.callUpdatePage(item);
            }
        });
        ScrollBar hScrollBar = this.fileChartBoard.getHScrollBar();
        hScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FileChartView.this.fileChartBoard.isMaximumScrolled()) {
                    AnalyzerUtil.setLatestTraceMode(FilePage.pageID, true);
                } else {
                    AnalyzerUtil.setLatestTraceMode(FilePage.pageID, false);
                }
            }
        });
        this.initIntervalMarkers(this.fileChartBoard);
        this.stackLayout.topControl = this.fileChartBoard;
        DATimeline timeline = this.fileChartBoard.getTimeline();
        timeline.setTimeTickFont(FontResources.TIMELINE_TICK_FONT);
        timeline.setTimeBalloonFont(FontResources.TIMELINE_BALLOON_FONT);
        LifecycleLogParser.getInstance().registerLifecycleBar(this.fileChartBoard.getLifecycleBar());
        LifecycleLogParser.getInstance().registerTimeline(timeline);
        this.processCombo = this.makeDACustomCombo(this.fileChartBoard.getTitleComp());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.width = 190;
        data.height = 20;
        this.processCombo.setLayoutData(data);
        this.initProcessCombo();
        this.updateScale();
        this.fileChartBoard.getScale().addSelectionListener(new DAScaleSelectionListener(){

            public void widgetSelected() {
                Toolbar.INSTANCE.setScaleSelection(FileChartView.this.fileChartBoard.getScale().getSelection());
                FileChartView.this.updateScale();
            }
        });
        this.fileChartBoard.getListComposite().addListener(37, new Listener(){

            public void handleEvent(Event event) {
                Toolbar.INSTANCE.setScaleSelection(FileChartView.this.fileChartBoard.getScale().getSelection());
            }
        });
    }

    public void callUpdatePage(DAChartBoardItem selectedItem) {
        this.lastSelectedItemForSummary = selectedItem;
        DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)this.fileChartBoard.getMarkers().get(0);
        long selectedStartTime = (long)(intervalMarker.getStartVal() * 1000000.0);
        long selectedEndTime = (long)(intervalMarker.getEndVal() * 1000000.0);
        AnalyzerManager.getCurrentPage().updateView((DAViewData)new DASelectionData(FilePage.chartViewID, selectedStartTime, selectedEndTime, selectedItem.getData(), null));
    }

    private void updateScale() {
        int scaleSelection = Toolbar.INSTANCE.getScaleSelection();
        this.fileChartBoard.getBoardManager().scaleChanged(scaleSelection);
        this.fileChartBoard.setScaleVal(scaleSelection);
    }

    private DAToolBarCustomCombo makeDACustomCombo(Composite parent) {
        int PROCESS_COMBO = 2;
        DAToolBarCustomCombo returnCombo = new DAToolBarCustomCombo(parent, 0);
        returnCombo.setComboGradation(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setOutlineColors(ColorResources.GRAY_170, ColorResources.GRAY_170, ColorResources.GRAY_170, ColorResources.GRAY_170);
        returnCombo.setComboImages(ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_SEL, ImageResources.DROP_ARROW_DOWN_HOVER, ImageResources.DROP_ARROW_DOWN_DIM);
        returnCombo.setComboImagePoint(new Point(160, 9));
        returnCombo.setComboButtonColor(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setArrowOutlineColors(ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220);
        returnCombo.setButtonImages(ImageResources.COMBO_DROPDOWN_UP, ImageResources.COMBO_DROPDOWN_DOWN);
        returnCombo.setFontPoint(new Point(5, 5));
        returnCombo.setEnabled(true);
        returnCombo.setComboFont(FontResources.COMBO);
        returnCombo.setItemFont(FontResources.DROPDOWN);
        returnCombo.setFontColors(ColorResources.BLACK, ColorResources.BLACK, ColorResources.BLACK, ColorResources.GRAY_170);
        returnCombo.setButtonRenderer((IDACustomButtonRenderer)new DACustomButtonRenderer());
        returnCombo.setDeviceCombo(PROCESS_COMBO);
        return returnCombo;
    }

    public void initProcessCombo() {
        this.processCombo.initCombo();
        this.processCombo.add("All Processes");
        this.processCombo.select(0);
        this.processCombo.addSelectionListener(new ToolBarComboListener(){

            @Override
            public void selectionEvent(DAToolBarCustomCombo combo) {
                int i = 0;
                while (i < Toolbar.INSTANCE.getProcessCombo().getItems().size()) {
                    if (combo.getText().equals(Toolbar.INSTANCE.getProcessCombo().getItem(i))) {
                        Toolbar.INSTANCE.getProcessCombo().select(i);
                    }
                    ++i;
                }
                BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
                baseView.getTopComposite().updateView();
            }
        });
        this.processCombo.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Project project = Global.getProject();
                if (project == null) {
                    return;
                }
                FileChartView.this.processCombo.initCombo();
                FileChartView.this.processCombo.add("All Processes");
                Toolbar.INSTANCE.getProcessCombo().initCombo();
                Toolbar.INSTANCE.getProcessCombo().add("All Processes");
                int[] pids = project.getProcessIDs();
                int pcount = pids.length;
                int i = 0;
                while (i < pcount) {
                    ProcessMemoryMap map;
                    ProcessInformation process = project.getProcessInformation(pids[i]);
                    String binName = process.getProcessName();
                    if ((binName == null || binName.isEmpty()) && (map = process.getLastProcessMemoryMap()) != null) {
                        int bid = map.getMainbinary().getBinaryID();
                        String binPath = project.getDeviceStatusInfo().getBinaryInfo(bid).getTargetBinaryPath();
                        if (binPath != null && !binPath.isEmpty()) {
                            int index = binPath.lastIndexOf("/");
                            binName = binPath.substring(index + 1, binPath.length());
                        }
                    }
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(process.getPid()).append(" : ");
                    buffer.append(binName);
                    FileChartView.this.processCombo.add(buffer.toString());
                    Toolbar.INSTANCE.getProcessCombo().add(buffer.toString());
                    ++i;
                }
            }
        });
    }

    private void updateProcessCombo() {
        int index = Toolbar.INSTANCE.getProcessCombo().getSelectionIndex();
        if (index + 1 > this.processCombo.getItems().size()) {
            this.addProcessListToProcessCombo();
        }
        this.processCombo.select(index);
    }

    private void addProcessListToProcessCombo() {
        Project project = Global.getProject();
        if (project == null) {
            return;
        }
        int[] pids = project.getProcessIDs();
        int pcount = pids.length;
        int i = 0;
        while (i < pcount) {
            ProcessMemoryMap map;
            ProcessInformation process = project.getProcessInformation(pids[i]);
            String binName = process.getProcessName();
            if ((binName == null || binName.isEmpty()) && (map = process.getLastProcessMemoryMap()) != null) {
                int bid = map.getMainbinary().getBinaryID();
                String binPath = project.getDeviceStatusInfo().getBinaryInfo(bid).getTargetBinaryPath();
                if (binPath != null && !binPath.isEmpty()) {
                    int index = binPath.lastIndexOf("/");
                    binName = binPath.substring(index + 1, binPath.length());
                }
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(process.getPid()).append(" : ");
            buffer.append(binName);
            this.processCombo.add(buffer.toString());
            Toolbar.INSTANCE.getProcessCombo().add(buffer.toString());
            ++i;
        }
    }

    public void updateView() {
        this.updateScale();
        this.updateProcessCombo();
        this.fileChartBoard.updateChart();
        if (AnalyzerUtil.isLatestTraceMode(FilePage.pageID)) {
            this.fileChartBoard.updateVisibleStartTime();
            this.fileChartBoard.setTotalEndTime(Toolbar.INSTANCE.getTime(), true);
        } else {
            this.fileChartBoard.setTotalEndTime(Toolbar.INSTANCE.getTime(), false);
        }
        if (RangeDataManager.getInstance().isBeingAnalyzed()) {
            ((DAChartPlotIntervalMarker)this.fileChartBoard.getMarkers().get(1)).setInterval((double)this.rangeDataManager.getAnalysisStartTime() / 1000000.0, (double)this.rangeDataManager.getAnalysisEndTime() / 1000000.0);
        } else {
            ((DAChartPlotIntervalMarker)this.fileChartBoard.getMarkers().get(1)).setInterval(-1.0, -1.0);
        }
        ((DAChartPlotIntervalMarker)this.fileChartBoard.getMarkers().get(2)).setInterval((double)this.rangeDataManager.getMarkerStartTime() / 1000000.0, (double)this.rangeDataManager.getMarkerEndTime() / 1000000.0);
    }

    public void updateView(DAViewData data) {
        this.updateScale();
        this.updateProcessCombo();
        this.fileChartBoard.updateChart();
        if (data instanceof DASelectionData) {
            long dataTime;
            DASelectionData selData;
            block12: {
                selData = (DASelectionData)data;
                dataTime = -1L;
                if (selData.isLogData()) {
                    Object obData = selData.getData();
                    if (obData != null && obData instanceof LogData) {
                        LogData ldata = (LogData)obData;
                        dataTime = ldata.getTime();
                        long seq = ldata.getSeq();
                        ResultSet rs = this.chartManager.getApiDB().selectFileEventBySeq(seq);
                        if (rs != null) {
                            try {
                                try {
                                    if (rs.next()) {
                                        int[] selectedIndex = this.fileChartBoard.getChartIndex(rs.getInt(1));
                                        this.fileChartBoard.selectItem(selectedIndex[0], selectedIndex[1]);
                                        if (this.lastSelectedItemForSummary != null) {
                                            AnalyzerManager.getCurrentPage().updateView((DAViewData)new DASelectionData(FilePage.chartViewID, dataTime, dataTime, this.lastSelectedItemForSummary.getData(), null));
                                        }
                                    }
                                }
                                catch (SQLException e) {
                                    Logger.exception((Throwable)e);
                                    SqlConnectionManager.releaseResultSet(rs);
                                    break block12;
                                }
                            }
                            catch (Throwable throwable) {
                                SqlConnectionManager.releaseResultSet(rs);
                                throw throwable;
                            }
                            SqlConnectionManager.releaseResultSet(rs);
                        }
                    }
                } else {
                    dataTime = selData.getStartTime();
                }
            }
            double startTime = (double)dataTime / 1000000.0;
            double endTime = (double)selData.getEndTime() / 1000000.0;
            DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)this.fileChartBoard.getMarkers().get(0);
            intervalMarker.setInterval(startTime, endTime);
        }
    }

    public void clear() {
        this.fileChartBoard.clear();
        this.initIntervalMarkers(this.fileChartBoard);
        this.chartManager.getFileChartDataMaker().clear();
    }

    public Control getControl() {
        return this.fileChartBoard;
    }

    private void initIntervalMarkers(DAChartBoard board) {
        DAChartPlotIntervalMarker selectionMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 1);
        selectionMarker.setBackgroundColor(ColorResources.SELECTION_RANGE);
        selectionMarker.setAlpha(63);
        board.addIntervalMarker((DAChartPlotMarker)selectionMarker);
        DAChartPlotIntervalMarker rangeAnalyzeMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 1);
        rangeAnalyzeMarker.setBackgroundColor(ColorResources.YELLOW);
        rangeAnalyzeMarker.setAlpha(63);
        board.addIntervalMarker((DAChartPlotMarker)rangeAnalyzeMarker);
        DAChartPlotIntervalMarker rangeMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 0);
        rangeMarker.setForegroundColor(ColorResources.RED);
        rangeMarker.setAlpha(63);
        board.addIntervalMarker((DAChartPlotMarker)rangeMarker);
    }

    public void setRangeMarker(double starttime, double endtime) {
        ((DAChartPlotIntervalMarker)this.fileChartBoard.getMarkers().get(2)).setInterval(starttime, endtime);
    }

    public DAChartBoard getChartBoard() {
        return this.fileChartBoard;
    }
}

