/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.appStartup;

import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.InformationViewLabels;
import org.tizen.dynamicanalyzer.nl.TimelinePageLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.SettingConstants;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.TargetData;
import org.tizen.dynamicanalyzer.swap.logparser.DataManagerRegistry;
import org.tizen.dynamicanalyzer.ui.info.appStartup.AppStartupDataManager;
import org.tizen.dynamicanalyzer.ui.info.appStartup.AppStartupTable;
import org.tizen.dynamicanalyzer.ui.info.appStartup.WebAppStartupTable;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class AppStartupView
extends DAViewComposite {
    private static final List<Protocol> notSupportedVersions = Arrays.asList(Protocol.VERSION_30, Protocol.VERSION_30_UIHV, Protocol.VERSION_30A);
    private String[] observingViews = null;
    Composite contents = null;
    private StackLayout stackLayout;
    private AppStartupTable nativeTable = null;
    private WebAppStartupTable webTable = null;
    private Label startUpNotSupportedLabel;

    public AppStartupView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(InformationViewLabels.APP_STARTUP_VIEW_TITLE);
        this.contents = this.getContentArea();
        this.contents.setBackground(ColorResources.TABLE_HEADER_BG);
        this.stackLayout = new StackLayout();
        this.contents.setLayout((Layout)this.stackLayout);
        this.nativeTable = new AppStartupTable(this.contents, 0, 2818);
        this.webTable = new WebAppStartupTable(this.contents, 0, 2818);
        this.startUpNotSupportedLabel = new Label(this.contents, 2112);
        this.startUpNotSupportedLabel.setFont(FontResources.TABLE_HEADER_FONT);
        this.startUpNotSupportedLabel.setForeground(ColorResources.TABLE_HEADER_FONT_COLOR);
        this.startUpNotSupportedLabel.setAlignment(0x1000000);
        if (!this.hideIfNotSupported()) {
            Project currentProject = Global.getProject();
            if (currentProject == null) {
                this.stackLayout.topControl = this.nativeTable;
            } else {
                this.changeTable(currentProject.isWebApplication());
            }
            DataManagerRegistry.registerPageDataManager(AppStartupDataManager.getInstance());
        }
    }

    public void setObservingViews(String[] viewIDs) {
        this.observingViews = viewIDs;
    }

    public String[] getObservingViews() {
        return this.observingViews;
    }

    public void changeTable(boolean isWeb) {
        if (this.hideIfNotSupported()) {
            return;
        }
        this.stackLayout.topControl = isWeb ? this.webTable : this.nativeTable;
        this.contents.layout();
    }

    public void updateView() {
        if (this.hideIfNotSupported()) {
            return;
        }
        if (this.stackLayout.topControl instanceof DATableComposite) {
            ((DATableComposite)this.stackLayout.topControl).updateTable();
        }
    }

    public void updateView(DAViewData data) {
        if (this.hideIfNotSupported()) {
            return;
        }
        if (this.stackLayout.topControl instanceof DATableComposite) {
            ((DATableComposite)this.stackLayout.topControl).deselectAll();
        }
        if (data instanceof DASelectionData) {
            DASelectionData selData = (DASelectionData)data;
            long start = selData.getStartTime();
            long end = selData.getEndTime();
            if (this.stackLayout.topControl == this.nativeTable) {
                this.nativeTable.setSelectionByTime(start, end);
            } else {
                this.webTable.setSelectionByTime(start, end);
            }
            this.updateView();
        }
    }

    private boolean hideIfNotSupported() {
        boolean hide = false;
        Project curProject = Global.getProject();
        hide = curProject != null && curProject.getPageTabList() != null ? Arrays.asList(curProject.getPageTabList()).contains(SettingConstants.PAGE_NAME_HIERARCHY) : SettingDataManager.INSTANCE.getSelectedFlatFeatureSet().contains((Object)FlatFeature.UI_HIERARCHY_ANALYSIS);
        if (!hide) {
            TargetData target = SettingDataManager.INSTANCE.getConnectedTargetOrNull();
            boolean bl = hide = target != null && notSupportedVersions.contains((Object)target.getProtocolVersion());
            if (hide) {
                this.startUpNotSupportedLabel.setText(String.valueOf(TimelinePageLabels.APPSTARTUP_NOT_SUPPORTED_LABEL_TARGET) + target.getTargetName());
            }
        } else {
            this.startUpNotSupportedLabel.setText(TimelinePageLabels.APPSTARTUP_NOT_SUPPORTED_LABEL_UIHV);
        }
        this.stackLayout.topControl = hide ? this.startUpNotSupportedLabel : this.stackLayout.topControl;
        return hide;
    }

    public void clear() {
        this.nativeTable.clear();
        this.webTable.clear();
        this.hideIfNotSupported();
    }

    public Control getControl() {
        return this.stackLayout.topControl;
    }
}

