/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.screenshot;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.tizen.dynamicanalyzer.ui.info.screenshot.IMessage;
import org.tizen.dynamicanalyzer.ui.info.screenshot.SocketConstants;
import org.tizen.dynamicanalyzer.ui.info.screenshot.SocketMessage;
import org.tizen.dynamicanalyzer.ui.info.screenshot.SocketReceive;
import org.tizen.dynamicanalyzer.util.Logger;

public class SocketClient {
    private static SocketClient client = null;
    private Socket socket;
    private String ip = SocketConstants.DefaultIp;
    private int port = SocketConstants.DefaultPort;
    private DataOutputStream output;
    private DataInputStream input;
    private LinkedList<String> receiveQueue = new LinkedList();
    private List<IMessage> listeners = new ArrayList<IMessage>();
    private boolean running = false;

    public DataOutputStream getOutputStream() {
        return this.output;
    }

    public DataInputStream getInputStream() {
        return this.input;
    }

    public static synchronized SocketClient getInstance() {
        if (client == null) {
            client = new SocketClient();
        }
        return client;
    }

    public boolean connect() {
        return this.connect(this.port);
    }

    public boolean connect(int port) {
        try {
            this.socket = new Socket(this.ip, port);
            Logger.info((Object)("socket created.ip: " + this.ip + ", port: " + port));
            this.socket.setReuseAddress(true);
            this.output = new DataOutputStream(this.socket.getOutputStream());
            this.input = new DataInputStream(this.socket.getInputStream());
            this.running = true;
            new Thread(null, new SocketReceive(), "Socket Receive Thread").start();
            new Thread(null, new SocketMessage(), "Socket Message Thread").start();
        }
        catch (SocketException e) {
            Logger.warning((Object)e.getMessage());
            return false;
        }
        catch (IOException e) {
            Logger.warning((Object)e.getMessage());
            return false;
        }
        return true;
    }

    public boolean tryClose(Object ... closeables) {
        if (closeables == null) {
            return false;
        }
        Object[] objectArray = closeables;
        int n = closeables.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj != null) {
                try {
                    if (obj instanceof Closeable) {
                        ((Closeable)obj).close();
                    } else if (obj instanceof BufferedReader) {
                        ((BufferedReader)obj).close();
                    } else if (obj instanceof Socket) {
                        ((Socket)obj).close();
                    }
                }
                catch (IOException e) {
                    Logger.warning((Object)e.getMessage());
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disconnect() {
        boolean result = false;
        this.running = false;
        if (this.receiveQueue != null) {
            LinkedList<String> linkedList = this.receiveQueue;
            synchronized (linkedList) {
                this.receiveQueue.notifyAll();
            }
        }
        result = this.tryClose(this.socket);
        return result;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isConnected() {
        if (this.socket == null) {
            return false;
        }
        return this.socket.isConnected();
    }

    public Socket getSocket() {
        return this.socket;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public InputStream getSockInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean run) {
        this.running = run;
    }

    public LinkedList<String> getReceiveQueue() {
        return this.receiveQueue;
    }

    public void addListener(IMessage iMessage) {
        this.listeners.add(iMessage);
    }

    public List<IMessage> getListener() {
        return this.listeners;
    }
}

