/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.interactive.table;

import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveUIData;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableToggleRenderer;
import org.tizen.dynamicanalyzer.util.Logger;

public class InteractiveTableToggleRenderer
extends DATableToggleRenderer {
    @Override
    public void paint(GC gc, Object value) {
        GridItem item = (GridItem)value;
        DATableDataFormat tableData = (DATableDataFormat)item.getData();
        Font font = item.getFont(0);
        if (font == null) {
            gc.setFont(FontResources.TABLE_CELL_FONT);
        } else {
            gc.setFont(font);
        }
        InteractiveUIData uiData = (InteractiveUIData)tableData.getObject();
        String text = item.getText(0);
        Color cellColor = ColorResources.TABLE_CONTENTS_FONT_COLOR;
        int checkLocation = uiData.getCheckLocation();
        if (checkLocation == 1) {
            cellColor = ColorResources.SERIES_COLOR_INTERACTIVE_BEFORE;
        } else if (checkLocation == 2) {
            cellColor = ColorResources.SERIES_COLOR_INTERACTIVE_AFTER;
        } else {
            Logger.error((Object)"Impossible case!!");
        }
        if (item.hasChildren()) {
            if (this.isExpanded()) {
                Rectangle r = ImageResources.TREE_OPEN.getBounds();
                int offset = (this.getBounds().width - r.width) / 2;
                int x = this.getBounds().x + offset;
                gc.drawImage(ImageResources.TREE_OPEN, x, this.getBounds().y);
                x += r.width + 5;
                if (this.isSelected()) {
                    gc.setForeground(ColorResources.TABLE_CONTENTS_SELECTED_FONT_COLOR);
                } else {
                    gc.setForeground(cellColor);
                }
                gc.drawText(text, x, this.getBounds().y, true);
            } else {
                Rectangle r = ImageResources.TREE_FOLD.getBounds();
                int offset = (this.getBounds().width - r.width) / 2;
                int x = this.getBounds().x + offset;
                gc.drawImage(ImageResources.TREE_FOLD, this.getBounds().x + offset, this.getBounds().y);
                x += r.width + 5;
                if (this.isSelected()) {
                    gc.setForeground(ColorResources.TABLE_CONTENTS_SELECTED_FONT_COLOR);
                } else {
                    gc.setForeground(cellColor);
                }
                gc.drawText(text, x, this.getBounds().y, true);
            }
        } else {
            Rectangle r = ImageResources.TREE_OPEN.getBounds();
            int offset = (this.getBounds().width - r.width) / 2;
            int x = this.getBounds().x + offset;
            x += r.width;
            if (this.isSelected()) {
                gc.setForeground(ColorResources.TABLE_CONTENTS_SELECTED_FONT_COLOR);
            } else {
                gc.setForeground(cellColor);
            }
            gc.drawText(text, x, this.getBounds().y, true);
        }
    }
}

