/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.ui.memory.ExpandableMemoryRangeComposite;
import org.tizen.dynamicanalyzer.ui.memory.StatisticsSelectionListener;
import org.tizen.dynamicanalyzer.ui.memory.StatisticsSortListener;
import org.tizen.dynamicanalyzer.ui.memory.table.MemoryStatisticsTable;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.timeline.MarkerManager;
import org.tizen.dynamicanalyzer.widgets.timeline.markers.IEventListener;
import org.tizen.dynamicanalyzer.widgets.timeline.markers.MarkerAddEvent;
import org.tizen.dynamicanalyzer.widgets.timeline.markers.MarkerEvent;
import org.tizen.dynamicanalyzer.widgets.timeline.markers.MarkerEventType;
import org.tizen.dynamicanalyzer.widgets.timeline.markers.MarkerPositionUpdateEvent;
import org.tizen.dynamicanalyzer.widgets.timeline.markers.MarkerRemoveEvent;

public class MemoryRangeAnalysisView
extends DAViewComposite {
    public static final String ID = MemoryRangeAnalysisView.class.getName();
    private static int childCompositeStyle = 2048;
    private static final int CHILD_MARGIN_HEIGHT = 5;
    private ScrolledComposite scrolledComposite;
    private Composite content;
    private List<ExpandableMemoryRangeComposite> rangeComposites = new LinkedList<ExpandableMemoryRangeComposite>();
    private ExpandableMemoryRangeComposite lastRangeComposite;
    private ExpandableMemoryRangeComposite focusedComposite = null;
    private Label noRangesLabel;
    private StatisticsSelectionListener statisticsSelectionListener;
    private StatisticsSortListener statisticsSortListener;
    private DAState lastUpdateState;

    private void updateLayoutData(int pos) {
        Composite current = (Composite)this.rangeComposites.get(pos);
        FormData currentData = new FormData();
        currentData.left = new FormAttachment(0);
        currentData.right = new FormAttachment(100);
        currentData.top = pos > 0 ? new FormAttachment((Control)this.rangeComposites.get(pos - 1), 5) : new FormAttachment(0, 5);
        current.setLayoutData((Object)currentData);
        if (pos + 1 < this.rangeComposites.size()) {
            Composite nextComposite = (Composite)this.rangeComposites.get(pos + 1);
            FormData nextData = (FormData)nextComposite.getLayoutData();
            nextData.top = new FormAttachment((Control)current, 5);
            nextComposite.setLayoutData((Object)nextData);
        }
    }

    private void recalculateScrollArea() {
        this.content.layout();
        int width = this.scrolledComposite.getClientArea().width;
        this.scrolledComposite.setMinSize(this.content.computeSize(width, -1));
    }

    private void setupChildCompositeListeners(ExpandableMemoryRangeComposite child) {
        child.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                MemoryRangeAnalysisView.this.recalculateScrollArea();
            }
        });
        Listener eventListener = new Listener(){

            public void handleEvent(Event event) {
                MemoryRangeAnalysisView.this.recalculateScrollArea();
            }
        };
        MemoryStatisticsTable table = child.getMemoryTable();
        table.getTable().addListener(18, eventListener);
        table.getTable().addListener(17, eventListener);
        if (this.statisticsSelectionListener != null) {
            table.getTable().addSelectionListener((SelectionListener)this.statisticsSelectionListener);
        }
        if (this.statisticsSortListener != null) {
            table.addListener(1001, this.statisticsSortListener);
        }
    }

    private void focusRangeComposite(ExpandableMemoryRangeComposite composite) {
        composite.setExpanded(true);
        this.recalculateScrollArea();
        this.scrolledComposite.showControl((Control)composite);
        if (this.focusedComposite != null && !this.focusedComposite.isDisposed()) {
            this.focusedComposite.setBackground(ColorResources.WHITE);
        }
        this.focusedComposite = composite;
        composite.setBackground(ColorResources.TABLE_HEADER_BG);
        composite.setFocus();
    }

    private void createRangeComposite(int pos) {
        ExpandableMemoryRangeComposite newComposite = new ExpandableMemoryRangeComposite(this.content, childCompositeStyle);
        this.setupChildCompositeListeners(newComposite);
        this.rangeComposites.add(pos, newComposite);
        int i = pos;
        while (i < this.rangeComposites.size()) {
            this.rangeComposites.get(i).setIndex(i);
            ++i;
        }
        ExpandableMemoryRangeComposite next = this.rangeComposites.get(pos + 1);
        newComposite.moveAbove((Control)next);
        newComposite.updateRange();
        next.updateRange();
        this.updateLayoutData(pos);
        this.noRangesLabel.setVisible(false);
        this.focusRangeComposite(newComposite);
    }

    private void updateRangeCompositePosition(int oldPos, int newPos) {
        if (newPos == oldPos) {
            this.rangeComposites.get(newPos).updateRange();
            this.rangeComposites.get(newPos + 1).updateRange();
            this.updateLayoutData(newPos);
        } else {
            ExpandableMemoryRangeComposite toMove = this.rangeComposites.get(oldPos);
            ExpandableMemoryRangeComposite oldNext = this.rangeComposites.get(oldPos + 1);
            this.rangeComposites.remove(oldPos);
            this.rangeComposites.add(newPos, toMove);
            ExpandableMemoryRangeComposite newNext = this.rangeComposites.get(newPos + 1);
            toMove.moveAbove((Control)newNext);
            int i = Math.min(oldPos, newPos);
            while (i <= Math.max(oldPos, newPos)) {
                this.rangeComposites.get(i).setIndex(i);
                ++i;
            }
            toMove.updateRange();
            oldNext.updateRange();
            newNext.updateRange();
            this.updateLayoutData(oldPos);
            this.updateLayoutData(newPos);
        }
        this.focusRangeComposite(this.rangeComposites.get(newPos));
    }

    private void removeAllRangeComposites() {
        for (ExpandableMemoryRangeComposite composite : this.rangeComposites) {
            if (composite == this.lastRangeComposite) continue;
            composite.dispose();
        }
        this.rangeComposites.clear();
        this.rangeComposites.add(this.lastRangeComposite);
        this.lastRangeComposite.setIndex(0);
        this.lastRangeComposite.updateRange();
        this.noRangesLabel.setVisible(true);
        this.focusedComposite = null;
    }

    private void removeRangeComposite(int pos) {
        this.rangeComposites.get(pos).dispose();
        this.rangeComposites.remove(pos);
        int i = pos;
        while (i < this.rangeComposites.size()) {
            this.rangeComposites.get(i).setIndex(i);
            ++i;
        }
        ExpandableMemoryRangeComposite nextComposite = this.rangeComposites.get(pos);
        nextComposite.updateRange();
        this.updateLayoutData(pos);
        if (this.rangeComposites.size() == 1) {
            this.noRangesLabel.setVisible(true);
        }
        if (nextComposite == this.lastRangeComposite) {
            if (pos - 1 >= 0) {
                this.focusRangeComposite(this.rangeComposites.get(pos - 1));
            }
        } else {
            this.focusRangeComposite(nextComposite);
        }
    }

    public void setStatisticsSelectionListener(StatisticsSelectionListener listener) {
        if (this.statisticsSelectionListener == listener) {
            return;
        }
        for (ExpandableMemoryRangeComposite child : this.rangeComposites) {
            Grid table = child.getMemoryTable().getTable();
            if (this.statisticsSelectionListener != null) {
                table.removeSelectionListener((SelectionListener)this.statisticsSelectionListener);
            }
            if (listener == null) continue;
            table.addSelectionListener((SelectionListener)listener);
        }
        this.statisticsSelectionListener = listener;
    }

    public void setStatisticsSortListener(StatisticsSortListener listener) {
        if (this.statisticsSortListener == listener) {
            return;
        }
        for (ExpandableMemoryRangeComposite child : this.rangeComposites) {
            MemoryStatisticsTable table = child.getMemoryTable();
            if (this.statisticsSortListener != null) {
                table.removeListener(1001, this.statisticsSortListener);
            }
            if (listener == null) continue;
            table.addListener(1001, listener);
        }
        this.statisticsSortListener = listener;
    }

    private void hideRangeComposite(int pos) {
        Composite composite = (Composite)this.rangeComposites.get(pos);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.right = new FormAttachment(0);
        formData.bottom = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        composite.setLayoutData((Object)formData);
        composite.setVisible(false);
        this.recalculateScrollArea();
    }

    private void showRangeComposite(int pos) {
        Composite composite = (Composite)this.rangeComposites.get(pos);
        composite.setVisible(true);
        this.updateLayoutData(pos);
        this.recalculateScrollArea();
    }

    public MemoryRangeAnalysisView(Composite parent, int style) {
        super(parent, style, false);
        MarkerManager.INSTANCE.addEventListener((IEventListener)new MarkerEventsListener());
        this.setLayout((Layout)new FillLayout(512));
        this.setTitle(MemoryPageLabels.MEMORY_RANGE_ANALYSIS_VIEW_TITLE);
        Composite viewContentArea = this.getContentArea();
        viewContentArea.setLayout((Layout)new FillLayout(512));
        this.scrolledComposite = new ScrolledComposite(viewContentArea, 512);
        this.scrolledComposite.setBackgroundMode(1);
        this.scrolledComposite.setBackground(ColorResources.WHITE);
        this.content = new Composite((Composite)this.scrolledComposite, 0);
        this.content.setLayout((Layout)new FormLayout());
        this.scrolledComposite.setContent((Control)this.content);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                MemoryRangeAnalysisView.this.recalculateScrollArea();
            }
        });
        this.lastRangeComposite = new ExpandableMemoryRangeComposite(this.content, childCompositeStyle);
        this.rangeComposites.add(this.lastRangeComposite);
        this.setupChildCompositeListeners(this.lastRangeComposite);
        this.hideRangeComposite(0);
        this.noRangesLabel = new Label(this.content, 0);
        this.noRangesLabel.setText(MemoryPageLabels.MEMORY_RANGE_ANALYSIS_VIEW_NO_RANGES_LABEL);
        this.noRangesLabel.setFont(FontResources.TABLE_HEADER_FONT);
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 5);
        labelData.left = new FormAttachment(0, 5);
        labelData.right = new FormAttachment(100);
        this.noRangesLabel.setLayoutData((Object)labelData);
    }

    public void updateView() {
        DAState currentState = DAState.getCurrentState();
        if (currentState == this.lastUpdateState) {
            return;
        }
        if (currentState != DAState.DONE) {
            this.hideRangeComposite(this.rangeComposites.size() - 1);
            this.noRangesLabel.setVisible(this.rangeComposites.size() == 1);
        } else {
            this.lastRangeComposite.setIndex(this.rangeComposites.size() - 1);
            this.lastRangeComposite.updateRange();
            this.showRangeComposite(this.rangeComposites.size() - 1);
            this.noRangesLabel.setVisible(false);
        }
        this.recalculateScrollArea();
        this.lastUpdateState = currentState;
    }

    private class MarkerEventsListener
    implements IEventListener {
        private MarkerEventsListener() {
        }

        public void handleEvent(MarkerEvent event) {
            switch (event.getType()) {
                case MARKER_CLEAR: {
                    MemoryRangeAnalysisView.this.removeAllRangeComposites();
                    break;
                }
                case MARKER_ADD: {
                    MarkerAddEvent addEvent = (MarkerAddEvent)event;
                    MemoryRangeAnalysisView.this.createRangeComposite(addEvent.getIdx());
                    break;
                }
                case MARKER_REMOVE: {
                    MarkerRemoveEvent removeEvent = (MarkerRemoveEvent)event;
                    MemoryRangeAnalysisView.this.removeRangeComposite(removeEvent.getIdx());
                    break;
                }
                case MARKER_POSITION_UPDATE: {
                    MarkerPositionUpdateEvent updateEvent = (MarkerPositionUpdateEvent)event;
                    MemoryRangeAnalysisView.this.updateRangeCompositePosition(updateEvent.getOldIdx(), updateEvent.getNewIdx());
                    break;
                }
            }
            if (event.getType() != MarkerEventType.MARKER_TIME_UPDATE) {
                MemoryRangeAnalysisView.this.recalculateScrollArea();
            }
        }
    }
}

