/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.chart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseEventListener;
import org.tizen.dynamicanalyzer.ui.common.UIEventChartContextMenuItem;
import org.tizen.dynamicanalyzer.ui.timeline.chart.ScreenshotChart;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineChartManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chart.DAScreenshotChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAUIEventChartPlot;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;

public class MemoryChartMouseEventListener
extends TimelineChartMouseEventListener {
    public MemoryChartMouseEventListener(DAPopupMenu menu, DATimeline timeline, String pageID) {
        super(menu, timeline, pageID);
    }

    @Override
    public void mouseDown(MouseEvent e) {
        DAChart chart = (DAChart)e.widget;
        DAChartPlot plot = chart.getPlot();
        DAChartPlotMarker marker = (DAChartPlotMarker)plot.getMarkers().get(0);
        if (!(marker instanceof DAChartPlotIntervalMarker)) {
            return;
        }
        DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)marker;
        double eventTime = plot.getXFromXPixel(e.x);
        if (e.button == 3) {
            List itemList = this.menu.getItems();
            DAPopupMenuItem startItem = (DAPopupMenuItem)itemList.get(0);
            DAPopupMenuItem endItem = (DAPopupMenuItem)itemList.get(1);
            DAPopupMenuItem fromSelectionItem = (DAPopupMenuItem)itemList.get(2);
            DAPopupMenuItem analysisItem = (DAPopupMenuItem)itemList.get(3);
            DAPopupMenuItem clearItem = (DAPopupMenuItem)itemList.get(4);
            if (eventTime * 1000000.0 <= (double)Toolbar.INSTANCE.getTime()) {
                startItem.setEnabled(true);
                endItem.setEnabled(true);
                analysisItem.setEnabled(this.rangeDataManager.isAnalyzable());
                clearItem.setEnabled(this.rangeDataManager.isBeingAnalyzed());
                startItem.setDoubleData(eventTime);
                endItem.setDoubleData(eventTime);
            } else {
                startItem.setEnabled(false);
                endItem.setEnabled(false);
                analysisItem.setEnabled(this.rangeDataManager.isAnalyzable());
                clearItem.setEnabled(this.rangeDataManager.isBeingAnalyzed());
            }
            if (intervalMarker.getStartVal() != intervalMarker.getEndVal()) {
                fromSelectionItem.setEnabled(true);
            } else {
                fromSelectionItem.setEnabled(false);
            }
            if (plot instanceof DAUIEventChartPlot) {
                ArrayList<Integer> startIndexList = new ArrayList<Integer>();
                ArrayList<Integer> endIndexList = new ArrayList<Integer>();
                for (DAChartSeries chartSeries : chart.getSeriesList()) {
                    int startIndex = chartSeries.getNextIndexByXvalue(intervalMarker.getStartVal());
                    int endIndex = chartSeries.getPrevIndexByXvalue(intervalMarker.getEndVal());
                    startIndexList.add(startIndex);
                    endIndexList.add(endIndex + 1);
                }
                DAPopupMenuItem eventListItem = (DAPopupMenuItem)this.menu.getItems().get(this.menu.getItems().size() - 1);
                ((UIEventChartContextMenuItem)eventListItem).setChartSeriesList(chart.getSeriesList());
                ((UIEventChartContextMenuItem)eventListItem).setStartIndexList(startIndexList);
                ((UIEventChartContextMenuItem)eventListItem).setEndIndexList(endIndexList);
                eventListItem.setEnabled(true);
            }
            return;
        }
        boolean bShift = false;
        if ((e.stateMask & 0x20000) != 0) {
            bShift = true;
        }
        if (plot instanceof DAScreenshotChartPlot) {
            DAChartSeries series = chart.getSeries(0);
            if (series != null) {
                int index = series.getPrevIndexByXvalue(eventTime);
                if (index >= 0 && index < series.getSeriesItemList().size()) {
                    DAChartSeriesItem item = (DAChartSeriesItem)series.getSeriesItemList().get(index);
                    double itemTime = item.getX();
                    int imageWidth = item.getImage().getBounds().width;
                    double imageRightTime = itemTime + plot.getXFromXPixel(imageWidth) - plot.getVisibleStartX();
                    if (eventTime > itemTime && eventTime < imageRightTime) {
                        if (bShift && intervalMarker.getStartVal() != -1.0) {
                            if (this.baseTime > eventTime) {
                                intervalMarker.setInterval(eventTime, this.baseTime);
                            } else {
                                intervalMarker.setInterval(this.baseTime, eventTime);
                            }
                        } else {
                            intervalMarker.setInterval(itemTime, eventTime);
                            this.baseTime = itemTime;
                        }
                    } else if (bShift && intervalMarker.getStartVal() != -1.0) {
                        if (this.baseTime > eventTime) {
                            intervalMarker.setInterval(eventTime, this.baseTime);
                        } else {
                            intervalMarker.setInterval(this.baseTime, eventTime);
                        }
                    } else {
                        intervalMarker.setInterval(eventTime, eventTime);
                        this.baseTime = eventTime;
                    }
                } else if (bShift && intervalMarker.getStartVal() != -1.0) {
                    if (this.baseTime > eventTime) {
                        intervalMarker.setInterval(eventTime, this.baseTime);
                    } else {
                        intervalMarker.setInterval(this.baseTime, eventTime);
                    }
                } else {
                    intervalMarker.setInterval(eventTime, eventTime);
                    this.baseTime = eventTime;
                }
            }
            DAChart chartWidget = ((ScreenshotChart)TimelineChartManager.getInstance().getChartInstance(-108)).getChart();
            DAScreenshotChartPlot screenshotChartPlot = (DAScreenshotChartPlot)chartWidget.getPlot();
            screenshotChartPlot.setSelectedImageIndex(this.getHighlightedImageIndex((DAChartPlot)screenshotChartPlot, chartWidget.getSeriesList(), e.x));
        } else if (bShift && intervalMarker.getStartVal() != -1.0) {
            if (this.baseTime > eventTime) {
                intervalMarker.setInterval(eventTime, this.baseTime);
            } else {
                intervalMarker.setInterval(this.baseTime, eventTime);
            }
        } else {
            intervalMarker.setInterval(eventTime, eventTime);
            this.baseTime = eventTime;
        }
        chart.redraw();
    }
}

