/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.model.TreeInput;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.MemoryData;
import org.tizen.dynamicanalyzer.ui.memory.data.MemAllocDBTable;
import org.tizen.dynamicanalyzer.ui.memory.data.MemFreeDBTable;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;

public class HeapDataManager
extends PageDataManager {
    private static HeapDataManager instance = new HeapDataManager();
    private final int TOTAL_PID = -1;
    private final int MEM_API_TYPE_ALLOC = 0;
    private final int MEM_API_TYPE_FREE = 1;
    private final int PRESISTENT_SIZE_INDEX = 0;
    private final int PRESISTENT_COUNT_INDEX = 1;
    private final int FREE_COUNT_INDEX = 2;
    private final int TOTAL_SIZE_INDEX = 3;
    private final int MAX_LIBRARIES_PER_PID = 500;
    private int REALLOC_ID;
    private MemAllocDBTable allocateDBTable = null;
    private MemFreeDBTable freeDBTable = null;
    private DBInserter allocateDBInserter = null;
    private DBInserter freeDBInserter = null;
    private ArrayList<List<Object>> memoryAllocDataList = new ArrayList();
    private ArrayList<List<Object>> memoryfreeDataList = new ArrayList();
    private List<TableInput> allocationTraceTreeInput = new ArrayList<TableInput>();
    private List<TreeInput> statisticsTreeInput = new ArrayList<TreeInput>();
    private List<List<Object>> preAllocDataList = new ArrayList<List<Object>>();
    private List<List<Object>> preFreeDataList = new ArrayList<List<Object>>();
    private HashSet<Long> addressMap = new HashSet();
    private List<Object> preQueryTime = new ArrayList<Object>();
    private Object lockAllocationCal = new Object();
    private Object lockStatisticsCal = new Object();

    private HeapDataManager() {
        this.allocateDBTable = new MemAllocDBTable();
        this.freeDBTable = new MemFreeDBTable();
        this.allocateDBInserter = this.makeInserter(this.allocateDBTable);
        this.freeDBInserter = this.makeInserter(this.freeDBTable);
        this.preQueryTime.add(-1L);
        this.preQueryTime.add(-1L);
        this.preQueryTime.add("");
    }

    public static HeapDataManager getInstance() {
        return instance;
    }

    public void clear() {
        this.memoryAllocDataList.clear();
        this.memoryfreeDataList.clear();
        this.addressMap.clear();
        this.allocationTraceTreeInput.clear();
        this.statisticsTreeInput.clear();
        this.preAllocDataList.clear();
        this.preFreeDataList.clear();
        this.preQueryTime.clear();
        this.preQueryTime.add(-1L);
        this.preQueryTime.add(-1L);
        this.preQueryTime.add("");
    }

    @Override
    protected void makeData(LogPackage pack) {
        this.REALLOC_ID = Global.getFunctionID("realloc");
        Logs allocatedlogs = this.getLogsFromLogPackage(pack, 257);
        this.makeHeapData(allocatedlogs);
    }

    public List<Object> getAllocationRowBySeqFromDB(long seqNum) {
        String where = "WHERE SEQUENCE_NUMBER = " + Long.toString(seqNum);
        List<List<Object>> queryResult = this.allocateDBTable.selectAllColumnData(where);
        if (queryResult.size() != 1) {
            Logger.error((Object)"Stored data was corrupted!");
            return null;
        }
        return queryResult.get(0);
    }

    private List<List<Object>> getAllocationDataFromDB(long start, long end, String targetPIDs) {
        List<List<Object>> allocatedResult = new ArrayList<List<Object>>();
        String where = this.getTimeWhereQuery(start, end, targetPIDs, MemAllocDBTable.COLUMN.ALLOCATED_TIME.name);
        List<List<Object>> queryResult = this.allocateDBTable.selectAllColumnData(where = String.valueOf(where) + " ORDER BY " + MemAllocDBTable.COLUMN.SEQUENCE_NUMBER.name);
        if (queryResult == null) {
            return allocatedResult;
        }
        allocatedResult = queryResult;
        return allocatedResult;
    }

    private List<List<Object>> getFreeDataFromDB(long start, long end, String targetPIDs) {
        List<List<Object>> freeResult = new ArrayList<List<Object>>();
        String where = this.getTimeWhereQuery(start, end, targetPIDs, MemFreeDBTable.COLUMN.FREE_TIME.name);
        List<List<Object>> queryResult = this.freeDBTable.selectAllColumnData(where = String.valueOf(where) + " ORDER BY " + MemFreeDBTable.COLUMN.SEQUENCE_NUMBER.name);
        if (queryResult == null) {
            return freeResult;
        }
        freeResult = queryResult;
        return freeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeWholeAllocationTraceData() {
        if (DAState.isRunning()) {
            return;
        }
        List<List<Object>> allocDataList = null;
        String pidliststring = this.getTargetPIDString();
        allocDataList = this.remainedAllocatedListForRange(0L, 0L, pidliststring);
        if (allocDataList == null || allocDataList.size() == 0) {
            return;
        }
        int index = 0;
        int size = allocDataList.size();
        ArrayList<TableInput> output = new ArrayList<TableInput>();
        int j = 0;
        while (j < size) {
            List<Object> iAllocData = allocDataList.get(j);
            TableInput alloInput = this.makeTreeInputForLeakData(iAllocData, index++);
            if (alloInput != null) {
                output.add(alloInput);
            }
            ++j;
        }
        Object object = this.lockAllocationCal;
        synchronized (object) {
            this.allocationTraceTreeInput = output;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeStatisticsData(long startTime, long endTime) {
        String pidliststring = this.getTargetPIDString();
        Map<Integer, Map<Integer, List<Object>>> staticdatas = this.remainedAllocStaticData(startTime, endTime, pidliststring);
        int index = 0;
        ArrayList<TreeInput> output = new ArrayList<TreeInput>();
        for (Map.Entry<Integer, Map<Integer, List<Object>>> elem : staticdatas.entrySet()) {
            long persistentSizeForPid = 0L;
            long persistentCountForPid = 0L;
            long freeCountForPid = 0L;
            long totalSizeForPid = 0L;
            ArrayList<TreeInput> children = new ArrayList<TreeInput>();
            index = elem.getKey() == -1 ? 0 : elem.getKey() * 500;
            int parentIndex = index++;
            for (Map.Entry<Integer, List<Object>> libEntry : elem.getValue().entrySet()) {
                String apiName = Global.getLibraryName(libEntry.getKey());
                TreeInput staticInput = this.makeTreeInputForDatas(apiName, false, libEntry.getValue(), index++);
                if (staticInput == null) continue;
                children.add(staticInput);
                persistentSizeForPid += ((Long)libEntry.getValue().get(0)).longValue();
                persistentCountForPid += ((Long)libEntry.getValue().get(1)).longValue();
                freeCountForPid += ((Long)libEntry.getValue().get(2)).longValue();
                totalSizeForPid += ((Long)libEntry.getValue().get(3)).longValue();
            }
            ArrayList<Object> total = new ArrayList<Object>();
            total.add(persistentSizeForPid);
            total.add(persistentCountForPid);
            total.add(freeCountForPid);
            total.add(totalSizeForPid);
            total.add(persistentCountForPid + freeCountForPid);
            TreeInput parent = elem.getKey() == -1 ? this.makeTreeInputForDatas("Total", false, total, parentIndex) : this.makeTreeInputForDatas(elem.getKey().toString(), true, total, parentIndex);
            if (parent == null) continue;
            parent.getChildren().addAll(children);
            output.add(parent);
        }
        Object object = this.lockStatisticsCal;
        synchronized (object) {
            this.statisticsTreeInput = output;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableInput> getWholeAllocationTraceTreeInput() {
        List<TableInput> output = null;
        Object object = this.lockAllocationCal;
        synchronized (object) {
            if (this.allocationTraceTreeInput == null) {
                this.allocationTraceTreeInput = new ArrayList<TableInput>();
            }
            output = this.allocationTraceTreeInput;
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TreeInput> getStatisticsTreeInput() {
        List<TreeInput> output = null;
        Object object = this.lockStatisticsCal;
        synchronized (object) {
            if (this.statisticsTreeInput == null) {
                this.statisticsTreeInput = new ArrayList<TreeInput>();
            }
            output = this.statisticsTreeInput;
        }
        return output;
    }

    public Map<Integer, Map<Integer, List<Object>>> remainedAllocStaticData(long startTime, long endTime, String targetPIDs) {
        this.getAllocationFreeDatas(startTime, endTime, targetPIDs);
        Map<Integer, Map<Integer, List<Object>>> result = this.makeRemainedAllocatedStatic(this.preAllocDataList, this.preFreeDataList);
        return result;
    }

    public List<List<Object>> remainedAllocatedListForRange(long startTime, long endTime) {
        return this.remainedAllocatedListForRange(startTime, endTime, this.getTargetPIDString());
    }

    public List<List<Object>> remainedAllocatedListForRange(long startTime, long endTime, String targetPIDs) {
        ArrayList<List<Object>> rangeDataList = new ArrayList<List<Object>>();
        this.getAllocationFreeDatas(startTime, endTime, targetPIDs);
        if (this.preAllocDataList != null) {
            if (this.preFreeDataList == null) {
                rangeDataList.addAll(this.preAllocDataList);
            } else {
                List<List<Object>> result = this.makeRemainedAllocatedList(this.preAllocDataList, this.preFreeDataList);
                if (result != null && !result.isEmpty()) {
                    rangeDataList.addAll(result);
                }
            }
        }
        return rangeDataList;
    }

    private void updateStatisticDataAllocs(Map<Integer, List<Object>> libStatisticMap, int binaryId, long allocSize) {
        if (libStatisticMap.containsKey(binaryId)) {
            List<Object> libstaticdata = libStatisticMap.get(binaryId);
            libstaticdata.set(0, (Long)libstaticdata.get(0) + allocSize);
            libstaticdata.set(1, (Long)libstaticdata.get(1) + 1L);
            libstaticdata.set(3, (Long)libstaticdata.get(3) + allocSize);
            libStatisticMap.put(binaryId, libstaticdata);
        } else {
            libStatisticMap.put(binaryId, Arrays.asList(allocSize, 1L, 0L, allocSize));
        }
    }

    private void updateStatisticDataFrees(Map<Integer, List<Object>> libStatisticMap, int binaryId, long freeSize) {
        if (libStatisticMap.containsKey(binaryId)) {
            List<Object> libstaticdata = libStatisticMap.get(binaryId);
            libstaticdata.set(0, (Long)libstaticdata.get(0) - freeSize);
            libstaticdata.set(1, (Long)libstaticdata.get(1) - 1L);
            libstaticdata.set(2, (Long)libstaticdata.get(2) + 1L);
            libStatisticMap.put(binaryId, libstaticdata);
        }
    }

    private Map<Integer, Map<Integer, List<Object>>> makeRemainedAllocatedStatic(List<List<Object>> allocData, List<List<Object>> freeData) {
        List onedata;
        long address;
        HashMap addressMap = new HashMap();
        HashMap<Integer, Map<Integer, List<Object>>> pidStatisticMap = new HashMap<Integer, Map<Integer, List<Object>>>();
        HashMap<Integer, List<Object>> libStatisticMapTotal = new HashMap<Integer, List<Object>>();
        pidStatisticMap.put(-1, libStatisticMapTotal);
        int allocDataSize = allocData.size();
        int j = 0;
        while (j < allocDataSize) {
            List<Object> iAllocData = allocData.get(j);
            address = (Long)iAllocData.get(MemAllocDBTable.COLUMN.ALLOCATED_ADDRESS.index);
            long alloctime = (Long)iAllocData.get(MemAllocDBTable.COLUMN.ALLOCATED_TIME.index);
            long allocSize = (Long)iAllocData.get(MemAllocDBTable.COLUMN.ALLOCATED_MEMORY_SIZE.index);
            int binaryId = (Integer)iAllocData.get(MemAllocDBTable.COLUMN.CALLER_LIBRARY_ID.index);
            int pid = (Integer)iAllocData.get(MemAllocDBTable.COLUMN.PID.index);
            if (!addressMap.containsKey(address)) {
                ArrayList newlist = new ArrayList();
                addressMap.put(address, newlist);
            }
            onedata = new ArrayList<Number>();
            onedata.add(alloctime);
            onedata.add(allocSize);
            onedata.add(binaryId);
            ((List)addressMap.get(address)).add(onedata);
            if (!pidStatisticMap.containsKey(pid)) {
                pidStatisticMap.put(pid, new HashMap());
            }
            this.updateStatisticDataAllocs((Map)pidStatisticMap.get(pid), binaryId, allocSize);
            this.updateStatisticDataAllocs(libStatisticMapTotal, binaryId, allocSize);
            ++j;
        }
        int i = 0;
        while (i < freeData.size()) {
            List<Object> iFreeData = freeData.get(i);
            address = (Long)iFreeData.get(MemFreeDBTable.COLUMN.ALLOCATED_ADDRESS.index);
            long freetime = (Long)iFreeData.get(MemFreeDBTable.COLUMN.FREE_TIME.index);
            int pid = (Integer)iFreeData.get(MemFreeDBTable.COLUMN.PID.index);
            Map libStatisticMapPid = (Map)pidStatisticMap.get(pid);
            if (addressMap.containsKey(address)) {
                int size = ((List)addressMap.get(address)).size();
                int removeindex = 0;
                while (removeindex < size) {
                    onedata = (List)((List)addressMap.get(address)).get(removeindex);
                    if ((Long)onedata.get(0) <= freetime) {
                        long freeSize = (Long)onedata.get(1);
                        int binaryId = (Integer)onedata.get(2);
                        this.updateStatisticDataFrees(libStatisticMapPid, binaryId, freeSize);
                        this.updateStatisticDataFrees(libStatisticMapTotal, binaryId, freeSize);
                        ((List)addressMap.get(address)).remove(removeindex);
                        break;
                    }
                    ++removeindex;
                }
            }
            ++i;
        }
        return pidStatisticMap;
    }

    private List<List<Object>> makeRemainedAllocatedList(List<List<Object>> allocData, List<List<Object>> freeData) {
        HashMap addressMap = new HashMap();
        ArrayList<List<Object>> output = new ArrayList<List<Object>>();
        int i = 0;
        while (i < freeData.size()) {
            List<Object> iFreeData = freeData.get(i);
            long freetime = (Long)iFreeData.get(MemFreeDBTable.COLUMN.FREE_TIME.index);
            long address = (Long)iFreeData.get(MemFreeDBTable.COLUMN.ALLOCATED_ADDRESS.index);
            if (!addressMap.containsKey(address)) {
                ArrayList newlist = new ArrayList();
                addressMap.put(address, newlist);
            }
            ((List)addressMap.get(address)).add(freetime);
            ++i;
        }
        int allocDataSize = allocData.size();
        int i2 = 0;
        while (i2 < allocDataSize) {
            List<Object> iAllocData = allocData.get(i2);
            boolean live = true;
            long alloctime = (Long)iAllocData.get(MemAllocDBTable.COLUMN.ALLOCATED_TIME.index);
            long address = (Long)iAllocData.get(MemAllocDBTable.COLUMN.ALLOCATED_ADDRESS.index);
            if (addressMap.containsKey(address)) {
                int size = ((List)addressMap.get(address)).size();
                int j = 0;
                while (j < size) {
                    Long freetime = (Long)((List)addressMap.get(address)).get(j);
                    if (alloctime <= freetime) {
                        live = false;
                        ((List)addressMap.get(address)).remove(j);
                        break;
                    }
                    ++j;
                }
            }
            if (live) {
                output.add(iAllocData);
            }
            ++i2;
        }
        return output;
    }

    private String getDisplayedEntryName(String apiName, boolean isProcess) {
        if (isProcess) {
            return "PID #" + apiName;
        }
        if (apiName.equals(Global.getProject().getApplicationInfo().getExecPath())) {
            return MemoryPageLabels.MEMORY_MAIN_EXCUTABLE;
        }
        return apiName;
    }

    public TreeInput makeTreeInputForDatas(String apiName, boolean isProcess, List<Object> staticdata, int index) {
        DATableDataFormat tableData = new DATableDataFormat(index);
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Object> data = new ArrayList<Object>();
        if (staticdata == null) {
            Logger.error((String)"No statistics data for '%d' entry!", (Object[])new Object[]{apiName});
            return null;
        }
        String entryName = this.getDisplayedEntryName(apiName, isProcess);
        Long PByte = (Long)staticdata.get(0);
        Long PCount = (Long)staticdata.get(1);
        Long FCount = (Long)staticdata.get(2);
        Long TotalByte = (Long)staticdata.get(3);
        Long TotalCount = PCount + FCount;
        text.add(entryName);
        data.add(apiName);
        text.add(String.format("%,d", TotalCount));
        data.add(TotalCount);
        text.add(String.format("%,d", FCount));
        data.add(FCount);
        text.add(String.format("%,d", PCount));
        data.add(PCount);
        text.add(Formatter.toByteFormat(TotalByte));
        data.add(TotalByte);
        text.add(Formatter.toByteFormat(PByte));
        data.add(PByte);
        tableData.getData().addAll(data);
        tableData.setObject(entryName);
        TreeInput output = new TreeInput();
        output.setText(text);
        output.setData(tableData);
        return output;
    }

    public TableInput makeTreeInputForLeakData(List<Object> allocData, int index) {
        DATableDataFormat tableData = new DATableDataFormat(index);
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Object> data = new ArrayList<Object>();
        if (allocData == null) {
            Logger.error((Object)"very strange case !!");
            return null;
        }
        Long seq = (Long)allocData.get(MemAllocDBTable.COLUMN.SEQUENCE_NUMBER.index);
        text.add(Long.toString(seq));
        data.add(seq);
        long time = (Long)allocData.get(MemAllocDBTable.COLUMN.ALLOCATED_TIME.index);
        data.add(time);
        try {
            text.add(Formatter.toTimeFormat(time));
        }
        catch (NumberFormatException e) {
            Logger.exception((Throwable)e);
            text.add(Long.toString(time));
        }
        int pid = (Integer)allocData.get(MemAllocDBTable.COLUMN.PID.index);
        text.add(Integer.toString(pid));
        data.add(pid);
        int tid = (Integer)allocData.get(MemAllocDBTable.COLUMN.TID.index);
        text.add(Integer.toString(tid));
        data.add(tid);
        Long address = (Long)allocData.get(MemAllocDBTable.COLUMN.ALLOCATED_ADDRESS.index);
        text.add("0x" + Long.toHexString(address));
        data.add(address);
        Long size = (Long)allocData.get(MemAllocDBTable.COLUMN.ALLOCATED_MEMORY_SIZE.index);
        text.add(Long.toString(size));
        data.add(size);
        String libName = Global.getLibraryName((Integer)allocData.get(MemAllocDBTable.COLUMN.CALLER_LIBRARY_ID.index));
        if (libName == null || libName.isEmpty()) {
            libName = "unknown";
        }
        text.add(libName);
        data.add(libName);
        int apiId = (Integer)allocData.get(MemAllocDBTable.COLUMN.API_ID.index);
        String apiName = Global.getFunctionName(apiId);
        text.add(apiName);
        data.add(apiName);
        TreeInput output = new TreeInput();
        output.setText(text);
        tableData.getData().addAll(data);
        output.setData(tableData);
        return output;
    }

    private String getTargetPIDString() {
        ArrayList<Integer> pidlist = new ArrayList<Integer>();
        int[] pids = Global.getProject().getProcessIDs();
        int targetPID = Toolbar.INSTANCE.getSelectedPid();
        if (targetPID > 0) {
            pidlist.add(targetPID);
        } else {
            int i = 0;
            while (i < pids.length) {
                pidlist.add(pids[i]);
                ++i;
            }
        }
        StringBuilder pidliststring = new StringBuilder();
        pidliststring.append("(");
        int i = 0;
        while (i < pidlist.size()) {
            pidliststring.append(Integer.toString((Integer)pidlist.get(i)));
            if (i != pidlist.size() - 1) {
                pidliststring.append(", ");
            }
            ++i;
        }
        pidliststring.append(")");
        return pidliststring.toString();
    }

    private Logs getLogsFromLogPackage(LogPackage logPack, int logCenterConstants) {
        Logs logs = logPack.getLogs(logCenterConstants);
        if (logs == null || logs.getRawLogs().size() == 0) {
            return null;
        }
        return logs;
    }

    private void makeHeapData(Logs alloclogs) {
        List<LogData> memoryLogList;
        List<LogData> list = memoryLogList = alloclogs == null ? null : alloclogs.getRawLogs();
        if (memoryLogList == null) {
            return;
        }
        Collections.sort(memoryLogList, new AscCompare());
        int size = memoryLogList.size();
        int i = 0;
        while (i < size) {
            MemoryData logData = (MemoryData)memoryLogList.get(i);
            long errorNo = logData.getErrno();
            if (errorNo == 0L) {
                int memApiType = logData.getMemoryApiType();
                int pid = logData.getPid();
                long calleraddress = logData.getCallerPcAddr();
                int binaryid = Global.getBinaryID(pid, logData.getTime(), calleraddress);
                if (memApiType == 0) {
                    this.makeAllocData(logData, binaryid);
                } else if (1 == memApiType) {
                    this.makeFreeData(logData, binaryid);
                }
            }
            ++i;
        }
        if (this.memoryAllocDataList.size() > 0) {
            List mList = (List)this.memoryAllocDataList.clone();
            this.memoryAllocDataList.clear();
            this.allocateDBInserter.pushData(mList);
        }
        if (this.memoryfreeDataList.size() > 0) {
            List fList = (List)this.memoryfreeDataList.clone();
            this.memoryfreeDataList.clear();
            this.freeDBInserter.pushData(fList);
        }
    }

    private void makeAllocData(MemoryData mData, int binaryid) {
        ArrayList<Number> dbAllocData = new ArrayList<Number>();
        int pid = mData.getPid();
        int tid = mData.getTid();
        long address = mData.getAddress();
        long mallocsize = mData.getSize();
        if (this.REALLOC_ID == mData.getApiId()) {
            try {
                Long freeaddress = Long.parseLong(mData.getArgs().replace("0x", "").split(",")[0], 16);
                this.makeFreeData(mData, freeaddress, binaryid);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.warning((String)"realloc address invalide : %s", (Object[])new Object[]{mData.getArgs()});
            }
        }
        dbAllocData.add(mData.getSeq());
        dbAllocData.add(pid);
        dbAllocData.add(tid);
        dbAllocData.add(mData.getApiId());
        dbAllocData.add(mData.getMemoryApiType());
        dbAllocData.add(address);
        dbAllocData.add(mData.getTime());
        dbAllocData.add(mData.getCallerPcAddr());
        dbAllocData.add(binaryid);
        dbAllocData.add(mData.getMsgID());
        dbAllocData.add(mallocsize);
        this.memoryAllocDataList.add(dbAllocData);
    }

    private void makeFreeData(MemoryData mData, int binaryid) {
        this.makeFreeData(mData, mData.getAddress(), binaryid);
    }

    private void makeFreeData(MemoryData mData, Long address, int binaryid) {
        ArrayList<Number> dbFreeData = new ArrayList<Number>();
        int pid = mData.getPid();
        dbFreeData.add(mData.getSeq());
        dbFreeData.add(pid);
        dbFreeData.add(mData.getMsgID());
        dbFreeData.add(mData.getTime());
        dbFreeData.add(address);
        dbFreeData.add(binaryid);
        this.memoryfreeDataList.add(dbFreeData);
    }

    private String getTimeWhereQuery(long start, long end, String targetIds, String timecolumn) {
        String where = "WHERE";
        if (start != 0L || end != 0L) {
            where = String.valueOf(where) + String.format(" %s BETWEEN %s AND %s AND", timecolumn, Long.toString(start), Long.toString(end));
        }
        where = String.valueOf(where) + String.format(" PID IN %s", targetIds);
        return where;
    }

    private void getAllocationFreeDatas(long start, long end, String targetIds) {
        if ((Long)this.preQueryTime.get(0) == start && (Long)this.preQueryTime.get(1) == end && ((String)this.preQueryTime.get(2)).equals(targetIds)) {
            return;
        }
        this.preAllocDataList = this.getAllocationDataFromDB(start, end, targetIds);
        this.preFreeDataList = this.getFreeDataFromDB(start, end, targetIds);
        this.preQueryTime.set(0, start);
        this.preQueryTime.set(1, end);
        this.preQueryTime.set(2, targetIds);
    }

    private static class AscCompare
    implements Comparator<LogData> {
        private AscCompare() {
        }

        @Override
        public int compare(LogData arg0, LogData arg1) {
            return Long.compare(arg0.getSeq(), arg1.getSeq());
        }
    }
}

