/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.data;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.MemoryData;
import org.tizen.dynamicanalyzer.swap.model.data.ProcessProfileData;
import org.tizen.dynamicanalyzer.swap.model.data.SystemData;
import org.tizen.dynamicanalyzer.ui.memory.data.ProcessMemoryDBTable;
import org.tizen.dynamicanalyzer.ui.memory.data.SystemMemoryDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.TargetProcessDBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class MemoryDataManager
extends PageDataManager {
    private static MemoryDataManager instance = new MemoryDataManager();
    private static final int MEM_API_TYPE_ALLOC = 0;
    private static final int MEM_API_TYPE_FREE = 1;
    private int REALLOC_ID;
    private Map<Integer, Long> mainAllocByteMap = new HashMap<Integer, Long>();
    private Map<Integer, Map<Integer, Long>> libraryAllocByteMap = new HashMap<Integer, Map<Integer, Long>>();
    private HashMap<String, List<List<Object>>> allocAddressDataMap = new HashMap();
    private List<MemoryData> freedatalist = new ArrayList<MemoryData>();
    private SystemMemoryDBTable systemMemoryDBTable = new SystemMemoryDBTable();
    private ProcessMemoryDBTable processMemoryDBTable = new ProcessMemoryDBTable();
    private DBInserter systemMemoryDBInserter = this.makeInserter(this.systemMemoryDBTable);
    private DBInserter processMemoryDBInserter = this.makeInserter(this.processMemoryDBTable);

    public static MemoryDataManager getInstance() {
        return instance;
    }

    protected MemoryDataManager() {
    }

    public void clear() {
        this.mainAllocByteMap = new HashMap<Integer, Long>();
        this.libraryAllocByteMap = new HashMap<Integer, Map<Integer, Long>>();
        this.allocAddressDataMap.clear();
        this.freedatalist.clear();
    }

    @Override
    public void saveData(Map<String, String> dataMap) {
    }

    @Override
    public void openData(Map<String, String> dataMap) {
    }

    @Override
    protected void makeData(LogPackage pack) {
        Logs systemmemorylogs = this.getLogsFromLogPackage(pack, 5);
        Logs allocatedlogs = this.getLogsFromLogPackage(pack, 257);
        this.REALLOC_ID = Global.getFunctionID("realloc");
        this.makeSystemMemoryData(systemmemorylogs, allocatedlogs);
    }

    private Logs getLogsFromLogPackage(LogPackage logPack, int logCenterConstants) {
        Logs logs = logPack.getLogs(logCenterConstants);
        if (logs == null || logs.getRawLogs().size() == 0) {
            return null;
        }
        return logs;
    }

    private void makeSystemMemoryData(Logs syslogs, Logs alloclogs) {
        List<LogData> systemLogList;
        List<LogData> memoryLogList = alloclogs == null ? null : alloclogs.getRawLogs();
        List<LogData> list = systemLogList = syslogs == null ? null : syslogs.getRawLogs();
        if (memoryLogList != null) {
            this.GetAllocationData(memoryLogList);
        }
        if (systemLogList != null) {
            this.GetSystemMemoryData(systemLogList);
        }
    }

    private void plusAllocData(MemoryData log) {
        int pid = log.getPid();
        long address = log.getAddress();
        long tracetime = log.getTime();
        if (address == 0L) {
            return;
        }
        String keystring = String.format("%d-%d", pid, address);
        int binaryId = Global.getBinaryID(pid, tracetime, log.getCallerPcAddr());
        String appname = Global.getCurrentDeviceInfo().getSelectedPackageLabel();
        if (log.getLibName().endsWith(appname)) {
            binaryId = -10;
        }
        if (this.REALLOC_ID == log.getApiId()) {
            try {
                Long freeaddress = Long.parseLong(log.getArgs().replace("0x", "").split(",")[0], 16);
                MemoryData freetempdata = log.clone();
                freetempdata.setAddress(freeaddress);
                this.freedatalist.add(freetempdata);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.warning((String)"realloc address invalide : %s", (Object[])new Object[]{log.getArgs()});
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        try {
            long allocsize = log.getSize();
            if (binaryId == -10) {
                this.mainAllocByteMap.put(pid, this.mainAllocByteMap.get(pid) + allocsize);
            } else {
                Long libraryAllocByte;
                if (this.libraryAllocByteMap.get(pid).containsKey(binaryId)) {
                    libraryAllocByte = this.libraryAllocByteMap.get(pid).get(binaryId);
                    if (libraryAllocByte == null) {
                        libraryAllocByte = 0L;
                    }
                } else {
                    libraryAllocByte = 0L;
                }
                this.libraryAllocByteMap.get(pid).put(binaryId, libraryAllocByte + allocsize);
            }
            if (!this.allocAddressDataMap.containsKey(keystring)) {
                ArrayList newlist = new ArrayList();
                ArrayList<Number> onedata = new ArrayList<Number>();
                onedata.add(tracetime);
                onedata.add(allocsize);
                onedata.add(binaryId);
                newlist.add(onedata);
                this.allocAddressDataMap.put(keystring, newlist);
            } else {
                ArrayList<Number> onedata = new ArrayList<Number>();
                onedata.add(tracetime);
                onedata.add(allocsize);
                onedata.add(binaryId);
                this.allocAddressDataMap.get(keystring).add(onedata);
            }
        }
        catch (NumberFormatException ne) {
            Logger.exception((Throwable)ne);
        }
    }

    private void minusFreeData(MemoryData log) {
        int pid = log.getPid();
        long address = log.getAddress();
        long tracetime = log.getTime();
        String keystring = String.format("%d-%d", pid, address);
        if (!this.allocAddressDataMap.containsKey(keystring)) {
            return;
        }
        long allocsize = -1L;
        int alloclib = 0;
        if (this.allocAddressDataMap.containsKey(keystring)) {
            int listsize = this.allocAddressDataMap.get(keystring).size();
            int j = 0;
            while (j < listsize) {
                List<Object> onedata = this.allocAddressDataMap.get(keystring).get(j);
                if ((Long)onedata.get(0) <= tracetime) {
                    allocsize = (Long)onedata.get(1);
                    alloclib = (Integer)onedata.get(2);
                    this.allocAddressDataMap.get(keystring).remove(j);
                    break;
                }
                ++j;
            }
        }
        if (allocsize == -1L) {
            return;
        }
        if (alloclib == -10) {
            Long allocByte = this.mainAllocByteMap.get(pid);
            this.mainAllocByteMap.put(pid, allocByte - allocsize);
        } else if (this.libraryAllocByteMap.get(pid).containsKey(alloclib)) {
            Long libraryAllocByte = this.libraryAllocByteMap.get(pid).get(alloclib);
            if (libraryAllocByte != null) {
                long calsize = libraryAllocByte - allocsize;
                if (calsize < 0L) {
                    calsize = 0L;
                }
                this.libraryAllocByteMap.get(pid).put(alloclib, calsize);
            } else {
                libraryAllocByte = 0L;
                this.libraryAllocByteMap.get(pid).put(alloclib, libraryAllocByte);
            }
        }
    }

    private void GetAllocationData(List<LogData> memoryLogList) {
        int size = memoryLogList.size();
        int i = 0;
        while (i < size) {
            MemoryData logData = (MemoryData)memoryLogList.get(i);
            long errorNo = logData.getErrno();
            if (errorNo == 0L) {
                int pid = logData.getPid();
                int memApiType = logData.getMemoryApiType();
                if (this.mainAllocByteMap.get(pid) == null) {
                    this.mainAllocByteMap.put(pid, 0L);
                    this.libraryAllocByteMap.put(pid, new HashMap());
                }
                if (memApiType == 0) {
                    this.plusAllocData(logData);
                } else if (memApiType == 1) {
                    this.freedatalist.add(logData);
                }
            }
            ++i;
        }
    }

    private void calculateFreeData() {
        for (MemoryData freelog : this.freedatalist) {
            this.minusFreeData(freelog);
        }
        this.freedatalist.clear();
    }

    private void GetSystemMemoryData(List<LogData> systemLogList) {
        ArrayList systemDataList = new ArrayList();
        ArrayList targetProcessDataList = new ArrayList();
        int size = systemLogList.size();
        int i = 0;
        while (i < size) {
            SystemData log = (SystemData)systemLogList.get(i);
            ArrayList<Integer> pIDList = new ArrayList<Integer>();
            ArrayList<String> processLoadList = new ArrayList<String>();
            String[] processLoadDatas = log.getOtherProcessLoad().split(",");
            int ii = 0;
            while (ii < processLoadDatas.length) {
                String processLoad = processLoadDatas[ii];
                if (processLoad != null && !processLoad.isEmpty()) {
                    pIDList.add(Integer.parseInt(processLoad));
                    processLoadList.add(processLoadDatas[++ii]);
                }
                ++ii;
            }
            ArrayList<Serializable> dbSystemData = new ArrayList<Serializable>();
            dbSystemData.add(Long.valueOf(log.getTime()));
            dbSystemData.add(Long.valueOf(log.getSystemMemoryUsed()));
            dbSystemData.add(pIDList);
            dbSystemData.add(processLoadList);
            systemDataList.add(dbSystemData);
            ProcessProfileData[] targetProcessList = log.getProcessProfileDataList();
            if (targetProcessList != null) {
                int j = 0;
                while (j < targetProcessList.length) {
                    ProcessProfileData process = targetProcessList[j];
                    ArrayList<Serializable> dbTargetProcessData = new ArrayList<Serializable>();
                    this.calculateFreeData();
                    ArrayList<Integer> binaryIDList = new ArrayList<Integer>();
                    ArrayList<Long> allocByteList = new ArrayList<Long>();
                    binaryIDList.add(-10);
                    if (this.mainAllocByteMap.get(process.getPid()) == null) {
                        allocByteList.add(new Long(0L));
                    } else {
                        allocByteList.add(this.mainAllocByteMap.get(process.getPid()));
                    }
                    Map<Integer, Long> libraryList = this.libraryAllocByteMap.get(process.getPid());
                    if (libraryList == null) {
                        libraryList = new HashMap<Integer, Long>();
                    }
                    for (Map.Entry<Integer, Long> entry : libraryList.entrySet()) {
                        binaryIDList.add(entry.getKey());
                        allocByteList.add(entry.getValue());
                    }
                    ArrayList<Integer> threadIdList = new ArrayList<Integer>();
                    ArrayList<String> threadLoadList = new ArrayList<String>();
                    String[] threadLoads = process.getThreadLoad().split(",");
                    int iii = 0;
                    while (iii < threadLoads.length) {
                        String threadLoad = threadLoads[iii];
                        if (threadLoad != null && !threadLoad.isEmpty()) {
                            threadIdList.add(new Integer(threadLoad));
                            threadLoadList.add(threadLoads[++iii]);
                        }
                        ++iii;
                    }
                    dbTargetProcessData.add(Long.valueOf(log.getTime()));
                    dbTargetProcessData.add(Integer.valueOf(process.getPid()));
                    dbTargetProcessData.add(Float.valueOf(process.getProcessLoad()));
                    dbTargetProcessData.add(Long.valueOf(process.getVirtualMemory()));
                    dbTargetProcessData.add(Long.valueOf(process.getResidentMemory()));
                    dbTargetProcessData.add(Long.valueOf(process.getSharedMemory()));
                    dbTargetProcessData.add(Long.valueOf(process.getPssMemory()));
                    dbTargetProcessData.add(Long.valueOf(process.getThreeDMemory()));
                    dbTargetProcessData.add(Long.valueOf(process.getGemMemory()));
                    dbTargetProcessData.add(Integer.valueOf(process.getThreadCount()));
                    dbTargetProcessData.add(Long.valueOf(process.getTotalAllocSize()));
                    dbTargetProcessData.add(binaryIDList);
                    dbTargetProcessData.add(allocByteList);
                    dbTargetProcessData.add(threadIdList);
                    dbTargetProcessData.add(threadLoadList);
                    targetProcessDataList.add(dbTargetProcessData);
                    ++j;
                }
            }
            ++i;
        }
        this.systemMemoryDBInserter.pushData(systemDataList);
        this.processMemoryDBInserter.pushData(targetProcessDataList);
    }

    public List<List<Object>> getSystemDataFromDB(long start, long end) {
        List<List<Object>> result;
        String where = "";
        if (start != 0L || end != 0L) {
            where = String.format("WHERE %s BETWEEN %s AND %s", SystemMemoryDBTable.COLUMN.SAMPLING_TIME.name, Long.toString(start), Long.toString(end));
        }
        if ((result = this.systemMemoryDBTable.selectAllColumnData(where = String.valueOf(where) + " ORDER BY " + SystemMemoryDBTable.COLUMN.SAMPLING_TIME.name)) != null) {
            return result;
        }
        return new ArrayList<List<Object>>();
    }

    public List<Long> getSystemMemoryMinMaxFromDB(long start, long end) {
        List<Long> output = null;
        String tableName = this.systemMemoryDBTable.getTableName();
        String columnName = SystemMemoryDBTable.COLUMN.MEMORY_USAGE_SYSTEM.name;
        String timecolumn = SystemMemoryDBTable.COLUMN.SAMPLING_TIME.name;
        output = this.getColumnLongFromDB(tableName, columnName, timecolumn, start, end);
        return output;
    }

    public List<Long> getColumnLongFromDB(String tableName, String columnName, String timecolumn, long start, long end) {
        return this.getColumnLongFromDB(tableName, columnName, timecolumn, 0, start, end);
    }

    public List<Long> getColumnLongFromDB(String tableName, String columnName, String timecolumn, int targetID, long start, long end) {
        ResultSet rs;
        String query;
        ArrayList<Long> output = new ArrayList<Long>();
        if (start == 0L && end == 0L) {
            query = String.format("SELECT %s FROM %s", columnName, tableName);
            if (targetID != 0) {
                query = String.valueOf(query) + " WHERE PID = " + targetID;
            }
        } else {
            query = String.format("SELECT %s FROM %s WHERE %s BETWEEN %s AND %s", columnName, tableName, timecolumn, start, end);
            if (targetID != 0) {
                query = String.valueOf(query) + " AND PID = " + targetID;
            }
        }
        if ((rs = SqlConnectionManager.executeQueryRS(query)) != null) {
            try {
                try {
                    while (rs.next()) {
                        output.add(rs.getLong(1));
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    SqlConnectionManager.releaseResultSet(rs);
                }
            }
            finally {
                SqlConnectionManager.releaseResultSet(rs);
            }
        }
        return output;
    }

    public long getCurrentColumnLongFromDB(String tableName, String columnName, String timecolumn, int targetID, long current) {
        ResultSet rs;
        long output = 0L;
        String query = "SELECT " + columnName + " FROM " + tableName + " WHERE";
        if (targetID != 0) {
            query = String.valueOf(query) + " PID = " + targetID + " AND";
        }
        if ((rs = SqlConnectionManager.executeQueryRS(query = String.valueOf(query) + " " + timecolumn + " = " + "(SELECT MAX(" + timecolumn + ") FROM " + tableName + " WHERE " + timecolumn + " <= " + current + ")")) != null) {
            try {
                try {
                    while (rs.next()) {
                        output += rs.getLong(1);
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    SqlConnectionManager.releaseResultSet(rs);
                }
            }
            finally {
                SqlConnectionManager.releaseResultSet(rs);
            }
        }
        return output;
    }

    public List<List<Object>> getTargetProcessDataFromDB(long start, long end, int targetPID) {
        List<List<Object>> queryResult;
        List<List<Object>> processedResult = new ArrayList<List<Object>>();
        String where = "WHERE";
        if (start != 0L || end != 0L) {
            where = String.valueOf(where) + String.format(" %s BETWEEN %s AND %s", ProcessMemoryDBTable.COLUMN.SAMPLING_TIME.name, Long.toString(start), Long.toString(end));
        }
        if (targetPID > 0) {
            if (start != 0L || end != 0L) {
                where = String.valueOf(where) + " AND";
            }
            where = String.valueOf(where) + String.format(" %s = %s", ProcessMemoryDBTable.COLUMN.PID.name, Integer.toString(targetPID));
        }
        if (where == "WHERE") {
            where = "";
        }
        if ((queryResult = this.processMemoryDBTable.selectAllColumnData(where = String.valueOf(where) + " ORDER BY " + ProcessMemoryDBTable.COLUMN.SAMPLING_TIME.name)) == null) {
            return processedResult;
        }
        processedResult = queryResult;
        return processedResult;
    }

    public Map<Integer, List<List<Object>>> getTargetProcessDataMapFromDB(long start, long end, int targetPID) {
        List<List<Object>> queryResult;
        HashMap<Integer, List<List<Object>>> processedResult = new HashMap<Integer, List<List<Object>>>();
        String where = "WHERE";
        if (start != 0L || end != 0L) {
            where = String.valueOf(where) + String.format(" %s BETWEEN %s AND %s", ProcessMemoryDBTable.COLUMN.SAMPLING_TIME.name, Long.toString(start), Long.toString(end));
        }
        if (targetPID > 0) {
            if (start != 0L || end != 0L) {
                where = String.valueOf(where) + " AND";
            }
            where = String.valueOf(where) + String.format(" %s = %s", ProcessMemoryDBTable.COLUMN.PID.name, Integer.toString(targetPID));
        }
        if (where == "WHERE") {
            where = "";
        }
        if ((queryResult = this.processMemoryDBTable.selectAllColumnData(where = String.valueOf(where) + " ORDER BY " + ProcessMemoryDBTable.COLUMN.SAMPLING_TIME.name)) == null) {
            return processedResult;
        }
        int i = 0;
        while (i < queryResult.size()) {
            List<Object> row = queryResult.get(i);
            Integer pid = (Integer)row.get(TargetProcessDBTable.COLUMN.PID.ordinal());
            ArrayList<List<Object>> processData = (ArrayList<List<Object>>)processedResult.get(pid);
            if (processData == null) {
                processData = new ArrayList<List<Object>>();
                processedResult.put(pid, processData);
            }
            processData.add(row);
            ++i;
        }
        return processedResult;
    }

    public Map<Integer, List<List<Object>>> getTargetProcessDataMapFromDB(long start, long end, String targetPIDs) {
        HashMap<Integer, List<List<Object>>> processedResult = new HashMap<Integer, List<List<Object>>>();
        String where = "WHERE";
        if (start != 0L || end != 0L) {
            where = String.valueOf(where) + String.format(" SAMPLING_TIME BETWEEN %s AND %s AND", Long.toString(start), Long.toString(end));
        }
        where = String.valueOf(where) + String.format(" PID IN %s", targetPIDs);
        List<List<Object>> queryResult = this.processMemoryDBTable.selectAllColumnData(where = String.valueOf(where) + " ORDER BY SAMPLING_TIME");
        if (queryResult == null) {
            return processedResult;
        }
        int i = 0;
        while (i < queryResult.size()) {
            List<Object> row = queryResult.get(i);
            Integer pid = (Integer)row.get(TargetProcessDBTable.COLUMN.PID.ordinal());
            ArrayList<List<Object>> processData = (ArrayList<List<Object>>)processedResult.get(pid);
            if (processData == null) {
                processData = new ArrayList<List<Object>>();
                processedResult.put(pid, processData);
            }
            processData.add(row);
            ++i;
        }
        return processedResult;
    }

    public long getSystemMemoriesFromDB(long time) {
        long processMemories = 0L;
        String tableName = this.systemMemoryDBTable.getTableName();
        String columnName = SystemMemoryDBTable.COLUMN.MEMORY_USAGE_SYSTEM.name;
        String timecolumn = SystemMemoryDBTable.COLUMN.SAMPLING_TIME.name;
        String query = "SELECT " + columnName + " FROM " + tableName + " WHERE " + timecolumn + " = " + "(SELECT MAX(" + timecolumn + ") FROM " + tableName + " WHERE " + timecolumn + " <= " + time + ")";
        ResultSet rs = SqlConnectionManager.executeQueryRS(query);
        if (rs != null) {
            try {
                try {
                    while (rs.next()) {
                        processMemories += rs.getLong(1);
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    SqlConnectionManager.releaseResultSet(rs);
                }
            }
            finally {
                SqlConnectionManager.releaseResultSet(rs);
            }
        }
        return processMemories;
    }
}

