/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.table;

import java.util.List;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.project.callstack.RuntimeCallstackManager;
import org.tizen.dynamicanalyzer.ui.memory.MemoryPersistentAllocationsTableView;
import org.tizen.dynamicanalyzer.ui.memory.data.HeapDataManager;
import org.tizen.dynamicanalyzer.ui.memory.data.MemAllocDBTable;
import org.tizen.dynamicanalyzer.ui.memory.table.MemoryPersistentAllocationsTable;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineTableView;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class MemoryCallStackTable
extends DATableComposite {
    private String UNKNOWN = "<unknown>";
    private String UNKNOWN_LIBRARY = "<unknown library>";

    public MemoryCallStackTable(Composite parent, int style) {
        super(parent, style);
    }

    public MemoryCallStackTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AnalyzerManager.getCurrentPage().updateView(new DAViewData(TimelineTableView.tabID, null));
                GridItem[] sels = MemoryCallStackTable.this.table.getSelection();
                if (sels.length <= 0) {
                    return;
                }
                MemoryCallStackTable.this.table.setFocusItem(sels[0]);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setContextMenu(2);
        this.applyFilterImage();
    }

    /*
     * Unable to fully structure code
     */
    public void updateCallstackTable(DASelectionData selData) {
        block15: {
            this.table.removeAll();
            if (selData == null) {
                return;
            }
            viewId = selData.getViewID();
            if (!viewId.equals(MemoryPersistentAllocationsTableView.class.getName())) {
                return;
            }
            obj = selData.getData();
            if (!(obj instanceof GridItem[])) break block15;
            items = (GridItem[])obj;
            if (items.length <= 0) {
                return;
            }
            tableData = (DATableDataFormat)items[0].getData();
            seqNum = -1L;
            time = -1L;
            allocCallerAddr = 0L;
            pid = 0;
            allocPath = null;
            allocName = null;
            if (tableData.getType() == 4099) {
                memAllocationData = tableData.getData();
                seqNum = (Long)memAllocationData.get(MemoryPersistentAllocationsTable.MemoryPersistentAllocationsTableIndex.SEQ.getIndex());
                time = (Long)memAllocationData.get(MemoryPersistentAllocationsTable.MemoryPersistentAllocationsTableIndex.TIMESTAMP.getIndex());
                allocPath = (String)memAllocationData.get(MemoryPersistentAllocationsTable.MemoryPersistentAllocationsTableIndex.LIBRARY.getIndex());
                allocName = (String)memAllocationData.get(MemoryPersistentAllocationsTable.MemoryPersistentAllocationsTableIndex.CALLED.getIndex());
                pid = (Integer)memAllocationData.get(MemoryPersistentAllocationsTable.MemoryPersistentAllocationsTableIndex.PID.getIndex());
                row = this.getAllocationInfo(seqNum);
                if (row != null) {
                    allocCallerAddr = (Long)row.get(MemAllocDBTable.COLUMN.CALLER_PC_ADDRESS.index);
                }
            }
            if ((addrMap = Global.getRuntimeCallstackManager().getCallStackApiAddrByPidMap(pid)) == null || addrMap.isEmpty()) {
                return;
            }
            addrs = this.getAddrs(seqNum);
            if (addrs == null && (addrs = this.getAddrs(0x7FFFFFFFFFFFFFFFL)) == null) {
                Logger.error((Object)"Function entry or exit not found");
                return;
            }
            callstackTableData = new DATableDataFormat(allocCallerAddr);
            callstackTableData.setType(4100);
            callstackTableData.setObject(allocCallerAddr);
            gridItem = new GridItem(this.table, 0);
            gridItem.setData((Object)callstackTableData);
            gridItem.setData("address", (Object)0L);
            gridItem.setData("pid", (Object)pid);
            gridItem.setData("time", (Object)time);
            gridItem.setData("libName", (Object)"");
            gridItem.setData("caller address", (Object)allocCallerAddr);
            gridItem.setData("start address", (Object)0L);
            gridItem.setText(0, allocName);
            gridItem.setText(1, this.UNKNOWN);
            gridItem.setText(2, this.UNKNOWN_LIBRARY);
            gridItem = new GridItem(this.table, 0);
            gridItem.setData((Object)callstackTableData);
            gridItem.setData("address", (Object)allocCallerAddr);
            gridItem.setData("pid", (Object)pid);
            gridItem.setData("time", (Object)time);
            gridItem.setData("libName", (Object)allocPath);
            gridItem.setData("caller address", (Object)0L);
            gridItem.setData("start address", (Object)0L);
            gridItem.setText(0, this.UNKNOWN);
            addrInput = allocCallerAddr == 0L ? this.UNKNOWN : Formatter.toHexString(Long.toString(allocCallerAddr)).toLowerCase();
            gridItem.setText(1, addrInput);
            gridItem.setText(2, allocPath);
            size = addrs.size();
            i = 0;
            while (i < size) {
                hexAddr = Formatter.toHexString(addrs.get(i).toString());
                api = addrMap.get(addrs.get(i));
                if (api == null) {
                    Logger.debug((Object)("callstackunit for addr : " + hexAddr + " not found"));
                    break;
                }
                path = api.getPath();
                if (path == null) {
                    Logger.debug((Object)("callstackunit for addr : " + hexAddr + " not found"));
                    break;
                }
                address = addrs.get(i);
                if (i != 0) ** GOTO lbl82
                if (allocPath.equals(Global.getLibraryName(api.getBinaryID()))) {
                    gridItem.setText(0, api.getFunctionName());
                    gridItem.setData("caller address", (Object)addrs.get(1));
                    gridItem.setData("start address", (Object)api.getFunctionStartAddr());
                } else {
                    if (addrs.size() > 1) {
                        address = 0L;
                    }
lbl82:
                    // 4 sources

                    gridItem = new GridItem(this.table, 0);
                    callstackTableData = new DATableDataFormat(address);
                    callstackTableData.setType(4100);
                    callstackTableData.setObject(address);
                    gridItem.setData((Object)callstackTableData);
                    gridItem.setData("address", (Object)address);
                    gridItem.setData("pid", (Object)pid);
                    gridItem.setData("time", (Object)time);
                    gridItem.setData("libName", (Object)path);
                    if (i + 1 < addrs.size()) {
                        gridItem.setData("caller address", (Object)addrs.get(i + 1));
                    } else {
                        gridItem.setData("caller address", (Object)0L);
                    }
                    gridItem.setData("start address", (Object)api.getFunctionStartAddr());
                    addrInput = address == 0L ? this.UNKNOWN : hexAddr;
                    gridItem.setText(1, addrInput.toLowerCase());
                    fName = api.getFunctionName();
                    gridItem.setText(0, fName);
                    gridItem.setText(2, path);
                }
                ++i;
            }
        }
    }

    private List<Object> getAllocationInfo(long seqNum) {
        return HeapDataManager.getInstance().getAllocationRowBySeqFromDB(seqNum);
    }

    private List<Long> getAddrs(long seqNum) {
        RuntimeCallstackManager callstackManager = Global.getRuntimeCallstackManager();
        if (callstackManager.getCallStackDataBySeqMap().floorEntry(seqNum) == null) {
            return null;
        }
        return callstackManager.getCallStackDataBySeqMap().floorEntry(seqNum).getValue().getAddrs();
    }

    @Override
    protected List<TableInput> makeTableInput() {
        return null;
    }
}

