/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl;

import java.util.Map;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.ui.opengl.GLDetailsView;
import org.tizen.dynamicanalyzer.ui.opengl.chart.GLChartView;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.table.api.GLAPIListView;
import org.tizen.dynamicanalyzer.ui.opengl.table.state.GLContextTableView;
import org.tizen.dynamicanalyzer.ui.opengl.table.state.GLProgramTableView;
import org.tizen.dynamicanalyzer.ui.opengl.table.state.GLRedundantTableView;
import org.tizen.dynamicanalyzer.ui.opengl.table.state.GLStatisticsTableView;
import org.tizen.dynamicanalyzer.ui.opengl.table.state.GLTextureTableView;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.page.PageInfoRegistry;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAPageComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DATabComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;

public class GLPage
extends DAPageComposite {
    public static final String pageID = GLPage.class.getName();
    public static final String chartViewID = GLChartView.class.getName();
    public static final String apiListViewID = GLAPIListView.class.getName();
    public static final String detailViewID = GLDetailsView.class.getName();
    public static final String leftTabID = "GLLeftTablID.id";
    public static final String rigthTabID = "GLRightTablID.id";
    public static final String contextViewID = GLContextTableView.class.getName();
    public static final String contextHistoryID = "contextHistoryID.id";
    public static final String programViewID = GLProgramTableView.class.getName();
    public static final String textureViewID = GLTextureTableView.class.getName();
    public static final String statisticsViewID = GLStatisticsTableView.class.getName();
    public static final String redundantViewID = GLRedundantTableView.class.getName();
    public static final int RIGHT_TAB_WIDTH = 97;
    private DATabComposite glLeftTableView = null;
    private DATabComposite glRightTableView = null;
    SashForm baseForm;
    SashForm topForm;
    SashForm bottomForm;
    SashForm bottomLeftForm;
    SashForm bottomRightForm;
    GLChartView glChartView;
    GLAPIListView glAPIListView;
    GLContextTableView glContextView;
    GLProgramTableView glProgramView;
    GLTextureTableView glTextureView;
    GLStatisticsTableView glStatisticsView;
    GLRedundantTableView glRedundantView;
    boolean isDetailMode = true;
    int tableHeight = -1;
    int tableWeight = 50;
    boolean wasSashCreated = false;

    public GLPage(Composite parent, int style) {
        super(parent, style);
        this.setTitle(AnalyzerLabels.COOLBAR_AREA_OPENGLES);
        this.setData("tooltip", ShortCutManager.COOLBAR_AREA_GRAPHICS_TOOLTIP);
        this.setBackground(ColorResources.WHITE);
        this.setLayout((Layout)new FillLayout());
        this.baseForm = new SashForm((Composite)this, 512);
        this.baseForm.setLayout((Layout)new FillLayout());
        this.baseForm.setForeground(ColorResources.WHITE);
        this.baseForm.setBackground(ColorResources.WHITE);
        this.topForm = new SashForm((Composite)this.baseForm, 512);
        GLChartView glChartView = new GLChartView((Composite)this.topForm, 0);
        this.addView((DABaseComposite)glChartView);
        this.bottomForm = new SashForm((Composite)this.baseForm, 256);
        this.bottomLeftForm = new SashForm((Composite)this.bottomForm, 0);
        this.bottomLeftForm.setForeground(ColorResources.TAB_SELECTED_COLOR_START);
        this.bottomLeftForm.setLayout((Layout)new FillLayout());
        this.bottomRightForm = new SashForm((Composite)this.bottomForm, 0);
        this.bottomRightForm.setForeground(ColorResources.TAB_SELECTED_COLOR_START);
        this.bottomRightForm.setLayout((Layout)new FillLayout());
        this.glLeftTableView = new DATabComposite((Composite)this.bottomLeftForm, 0, false, true);
        GLStatisticsTableView glStatisticsView = new GLStatisticsTableView(this.glLeftTableView.getContentComposite(), 0);
        this.glLeftTableView.addView((DABaseComposite)glStatisticsView);
        this.addView((DABaseComposite)glStatisticsView);
        GLAPIListView glAPIListView = new GLAPIListView(this.glLeftTableView.getContentComposite(), 0);
        this.glLeftTableView.addView((DABaseComposite)glAPIListView);
        this.addView((DABaseComposite)glAPIListView);
        this.addView((DABaseComposite)this.glLeftTableView);
        this.glRightTableView = new DATabComposite((Composite)this.bottomRightForm, 0, false, true);
        GLRedundantTableView glRedundantView = new GLRedundantTableView(this.glRightTableView.getContentComposite(), 0);
        this.glRightTableView.addView((DABaseComposite)glRedundantView);
        this.addView((DABaseComposite)glRedundantView);
        GLContextTableView glContextTableView = new GLContextTableView(this.glRightTableView.getContentComposite(), 0);
        this.glRightTableView.addView((DABaseComposite)glContextTableView);
        this.addView((DABaseComposite)glContextTableView);
        GLProgramTableView glProgramTableView = new GLProgramTableView(this.glRightTableView.getContentComposite(), 0);
        this.glRightTableView.addView((DABaseComposite)glProgramTableView);
        this.addView((DABaseComposite)glProgramTableView);
        GLTextureTableView glTextureTableView = new GLTextureTableView(this.glRightTableView.getContentComposite(), 0);
        this.glRightTableView.addView((DABaseComposite)glTextureTableView);
        this.addView((DABaseComposite)glTextureTableView);
        this.addView((DABaseComposite)this.glRightTableView);
        this.topForm.setSashWidth(2);
        this.bottomForm.setSashWidth(2);
        this.bottomLeftForm.setSashWidth(2);
        this.bottomRightForm.setSashWidth(2);
        this.bottomForm.setWeights(new int[]{this.tableWeight, 100 - this.tableWeight});
        this.addTableWeightListener();
    }

    private void addTableWeightListener() {
        ((SashForm)this.bottomForm.getChildren()[0]).addListener(11, new Listener(){

            public void handleEvent(Event event) {
                GLPage.this.resizeLeftTableButton();
                GLPage.this.resizeRightTableButton();
            }
        });
    }

    private void addHeightWeightListener() {
        if (this.baseForm.getChildren().length > 2) {
            ((Sash)this.baseForm.getChildren()[2]).addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    GLPage.this.tableHeight = (int)((double)GLPage.this.baseForm.getWeights()[0] / (double)GLPage.this.baseForm.getWeights()[0] + (double)GLPage.this.baseForm.getWeights()[1]) * GLPage.this.baseForm.getSize().y * 1 / 1000;
                }
            });
            this.wasSashCreated = true;
        }
    }

    public Composite getTopTable() {
        DAViewComposite view = (DAViewComposite)this.glLeftTableView.getTopComposite();
        Composite comp = (Composite)view.getControl();
        Logger.debug((Object)comp.toString());
        return comp;
    }

    public SashForm getBaseForm() {
        return this.baseForm;
    }

    public void setDetailMode(boolean mode) {
        this.isDetailMode = mode;
    }

    protected void onResized(int width, int height) {
        if (!this.wasSashCreated) {
            this.addHeightWeightListener();
        }
        this.resizePageButton();
        this.resizeLeftTableButton();
        this.resizeRightTableButton();
        if (!this.isDetailMode) {
            int[] nArray = new int[2];
            nArray[0] = 100;
            this.baseForm.setWeights(nArray);
        } else {
            int hrate;
            int n = hrate = this.tableHeight == -1 ? (int)(23500.0 / (double)height) : this.tableHeight * 100 / height;
            if (hrate > 100) {
                return;
            }
            this.baseForm.setWeights(new int[]{100 - hrate, hrate});
        }
    }

    private void resizePageButton() {
        int width = WorkbenchUtil.getWorkbenchWindow().getShell().getBounds().width;
        int pageCount = PageInfoRegistry.getPageNamesByTarget(SettingDataManager.INSTANCE.getConnectedTargetOrSelected().getTargetName()).size();
        int newWidth = width / pageCount > 190 ? 190 : width / pageCount;
        ((BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID)).getMainTab().updateTabButtonsWidth(newWidth);
    }

    private void resizeLeftTableButton() {
        int tabCount;
        double weight = (double)this.bottomForm.getWeights()[0] / 1000.0;
        int width = (int)((double)WorkbenchUtil.getWorkbenchWindow().getShell().getBounds().width * weight);
        int newWidth = width / (tabCount = this.glLeftTableView.getTabButtons().size()) > 190 ? 190 : width / tabCount;
        this.glLeftTableView.updateTabButtonsWidth(newWidth);
    }

    private void resizeRightTableButton() {
        int tabCount;
        double weight = (double)this.bottomForm.getWeights()[1] / 1000.0;
        int width = (int)((double)WorkbenchUtil.getWorkbenchWindow().getShell().getBounds().width * weight);
        int newWidth = width / (tabCount = this.glRightTableView.getTabButtons().size()) > 190 ? 190 : width / tabCount;
        this.glRightTableView.updateTabButtonsWidth(newWidth);
    }

    public void clear() {
        super.clear();
        GLDataManager.getInstance().clear();
    }

    public void updateView() {
        for (Map.Entry entry : this.childMap.entrySet()) {
            ((DABaseComposite)entry.getValue()).updateView();
        }
        if (!this.isDetailMode) {
            if (this.baseForm.getChildren().length > 2) {
                ((Sash)this.baseForm.getChildren()[2]).setVisible(false);
            }
        } else if (this.baseForm.getChildren().length > 2) {
            ((Sash)this.baseForm.getChildren()[2]).setVisible(true);
        }
    }
}

